/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.metrics.api.BuiltInMeterNameFormat;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfig;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class KeyPerformanceIndicatorMetricsImpls {
    static final String DEFERRED_NAME = "deferred";
    static final String REQUESTS_COUNT_NAME = "count";
    static final String INFLIGHT_REQUESTS_NAME = "inFlight";
    static final String LONG_RUNNING_REQUESTS_NAME = "longRunning";
    static final String LOAD_NAME = "load";
    static final String KPI_METERS_SCOPE = "vendor";
    private static final Map<String, KeyPerformanceIndicatorSupport.Metrics> KPI_METRICS = new HashMap<String, KeyPerformanceIndicatorSupport.Metrics>();
    private static final Map<String, String> CAMEL_TO_SNAKE_CASE_METER_NAMES = Map.of("inFlight", "in_flight", "longRunning", "long_running");

    private KeyPerformanceIndicatorMetricsImpls() {
    }

    static KeyPerformanceIndicatorSupport.Metrics get(MeterRegistry kpiMeterRegistry, String meterNamePrefix, KeyPerformanceIndicatorMetricsConfig kpiConfig, BuiltInMeterNameFormat builtInMeterNameFormat) {
        return KPI_METRICS.computeIfAbsent(meterNamePrefix, prefix -> kpiConfig.extended() ? new Extended(kpiMeterRegistry, meterNamePrefix, kpiConfig, builtInMeterNameFormat) : new Basic(kpiMeterRegistry, meterNamePrefix, builtInMeterNameFormat));
    }

    static void close() {
        KPI_METRICS.clear();
    }

    private static class Extended
    extends Basic {
        protected static final String LOAD_DESCRIPTION = "Measures the total number of in-flight requests over the life of the server";
        private final Gauge inflightRequests;
        private final DeferredRequests deferredRequests;
        private final Counter longRunningRequests;
        private final Counter load;
        private final long longRunningRequestThresdholdMs;
        private AtomicInteger inflightRequestsCount = new AtomicInteger();

        protected Extended(MeterRegistry kpiMeterRegistry, String meterNamePrefix, KeyPerformanceIndicatorMetricsConfig kpiConfig, BuiltInMeterNameFormat builtInMeterNameFormat) {
            this(kpiMeterRegistry, meterNamePrefix, kpiConfig.longRunningRequestThreshold(), builtInMeterNameFormat);
        }

        private Extended(MeterRegistry kpiMeterRegistry, String meterNamePrefix, Duration longRunningRequestThreshold, BuiltInMeterNameFormat builtInMeterNameFormat) {
            super(kpiMeterRegistry, meterNamePrefix, builtInMeterNameFormat);
            this.longRunningRequestThresdholdMs = longRunningRequestThreshold.toMillis();
            this.inflightRequests = (Gauge)kpiMeterRegistry.getOrCreate((Meter.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)(meterNamePrefix + this.meterName(KeyPerformanceIndicatorMetricsImpls.INFLIGHT_REQUESTS_NAME)), (Object)this.inflightRequestsCount, AtomicInteger::get).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)).description("Measures the number of requests currently being processed")));
            this.longRunningRequests = (Counter)kpiMeterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.LONG_RUNNING_REQUESTS_NAME)).description("Measures the total number of long-running requests and rates at which they occur")).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)));
            this.load = (Counter)kpiMeterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)(meterNamePrefix + this.meterName(KeyPerformanceIndicatorMetricsImpls.LOAD_NAME))).description(LOAD_DESCRIPTION)).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)));
            this.deferredRequests = new DeferredRequests();
            kpiMeterRegistry.getOrCreate((Meter.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)(meterNamePrefix + this.meterName(KeyPerformanceIndicatorMetricsImpls.DEFERRED_NAME)), (Object)this.deferredRequests, DeferredRequests::value).description("Measures deferred requests")).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)));
        }

        @Override
        public void onRequestReceived() {
            super.onRequestReceived();
            this.deferredRequests.deferRequest();
        }

        public void onRequestStarted() {
            super.onRequestStarted();
            this.inflightRequestsCount.incrementAndGet();
            this.load.increment();
            this.deferredRequests.startRequest();
        }

        public void onRequestCompleted(boolean isSuccessful, long processingTimeMs) {
            super.onRequestCompleted(isSuccessful, processingTimeMs);
            this.inflightRequestsCount.decrementAndGet();
            if (processingTimeMs >= this.longRunningRequestThresdholdMs) {
                this.longRunningRequests.increment();
            }
            this.deferredRequests.completeRequest();
        }

        private static class DeferredRequests {
            private long hits;
            private long load;

            private DeferredRequests() {
            }

            void deferRequest() {
                ++this.hits;
            }

            void startRequest() {
                ++this.load;
            }

            void completeRequest() {
                --this.hits;
                --this.load;
            }

            double value() {
                return this.hits - this.load;
            }
        }
    }

    private static class Basic
    implements KeyPerformanceIndicatorSupport.Metrics {
        private final Counter totalCount;
        private final MeterRegistry meterRegistry;
        private final List<Meter> meters = new ArrayList<Meter>();
        private final BuiltInMeterNameFormat builtInMeterNameFormat;

        protected Basic(MeterRegistry kpiMeterRegistry, String meterNamePrefix, BuiltInMeterNameFormat builtInMeterNameFormat) {
            this.meterRegistry = kpiMeterRegistry;
            this.builtInMeterNameFormat = builtInMeterNameFormat;
            this.totalCount = this.add((Counter)kpiMeterRegistry.getOrCreate(((Counter.Builder)Counter.builder((String)(meterNamePrefix + this.meterName(KeyPerformanceIndicatorMetricsImpls.REQUESTS_COUNT_NAME))).description("Each request (regardless of HTTP method) will increase this counter")).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)));
        }

        public void onRequestReceived() {
            this.totalCount.increment();
        }

        public void close() {
            this.meters.forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
            KPI_METRICS.clear();
        }

        protected <M extends Meter> M add(M meter) {
            this.meters.add(meter);
            return meter;
        }

        protected Counter totalCount() {
            return this.totalCount;
        }

        protected String meterName(String camelCaseMeterName) {
            return this.builtInMeterNameFormat == BuiltInMeterNameFormat.CAMEL ? camelCaseMeterName : CAMEL_TO_SNAKE_CASE_METER_NAMES.getOrDefault(camelCaseMeterName, camelCaseMeterName);
        }
    }
}

