/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpException;
import io.helidon.http.Status;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MeterRegistryFormatter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.spi.MeterRegistryFormatterProvider;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.SecureHandler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.observe.metrics.KeyPerformanceIndicatorMetricsImpls;
import io.helidon.webserver.observe.metrics.MetricsObserverConfig;
import io.helidon.webserver.observe.metrics.PostRequestMetricsSupport;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;

class MetricsFeature {
    static final String KPI_METER_NAME_PREFIX = "requests";
    private static final String KPI_METER_NAME_PREFIX_WITH_DOT = "requests.";
    private static final Handler DISABLED_ENDPOINT_HANDLER = (req, res) -> res.status(Status.NOT_FOUND_404).send((Object)"Metrics are disabled");
    private final MetricsConfig metricsConfig;
    private final MeterRegistry meterRegistry;
    private KeyPerformanceIndicatorSupport.Metrics kpiMetrics;

    MetricsFeature(MetricsObserverConfig config) {
        this.metricsConfig = config.metricsConfig();
        this.meterRegistry = config.meterRegistry().orElseGet(() -> MetricsFactory.getInstance().globalRegistry(this.metricsConfig));
    }

    void configureVendorMetrics(HttpRouting.Builder rules) {
        this.kpiMetrics = KeyPerformanceIndicatorMetricsImpls.get(this.meterRegistry, KPI_METER_NAME_PREFIX_WITH_DOT, this.metricsConfig.keyPerformanceIndicatorMetricsConfig(), this.metricsConfig.builtInMeterNameFormat());
        rules.addFilter((chain, req, res) -> {
            KeyPerformanceIndicatorSupport.Context kpiContext = MetricsFeature.kpiContext((ServerRequest)req);
            PostRequestMetricsSupport prms = PostRequestMetricsSupport.create();
            req.context().register((Object)prms);
            kpiContext.requestHandlingStarted(this.kpiMetrics);
            try {
                chain.proceed();
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, null, kpiContext);
            }
            catch (Exception e) {
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, e, kpiContext);
                throw e;
            }
        });
    }

    void register(HttpRouting.Builder routing, String endpoint) {
        this.configureVendorMetrics(routing);
        routing.register(endpoint, new HttpService[]{new MetricsService()});
    }

    Optional<?> output(MediaType mediaType, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MeterRegistryFormatter formatter = this.chooseFormatter(this.meterRegistry, mediaType, SystemTagsManager.instance().scopeTagName(), scopeSelection, nameSelection);
        return formatter.format();
    }

    Optional<?> outputMetadata(MediaType mediaType, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MeterRegistryFormatter formatter = this.chooseFormatter(this.meterRegistry, mediaType, SystemTagsManager.instance().scopeTagName(), scopeSelection, nameSelection);
        return formatter.formatMetadata();
    }

    private static MediaType bestAccepted(ServerRequest req) {
        return req.headers().bestAccepted(new MediaType[]{MediaTypes.TEXT_PLAIN, MediaTypes.APPLICATION_OPENMETRICS_TEXT, MediaTypes.APPLICATION_JSON}).orElse(null);
    }

    private static MediaType bestAcceptedForMetadata(ServerRequest req) {
        return req.headers().bestAccepted(new MediaType[]{MediaTypes.APPLICATION_JSON}).orElse(null);
    }

    private static KeyPerformanceIndicatorSupport.Context kpiContext(ServerRequest request) {
        return request.context().get(KeyPerformanceIndicatorSupport.Context.class).orElseGet(KeyPerformanceIndicatorSupport.Context::create);
    }

    private MeterRegistryFormatter chooseFormatter(MeterRegistry meterRegistry, MediaType mediaType, Optional<String> scopeTagName, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        Optional<MeterRegistryFormatter> formatter = HelidonServiceLoader.builder(ServiceLoader.load(MeterRegistryFormatterProvider.class)).build().stream().map(provider -> provider.formatter(mediaType, this.metricsConfig, meterRegistry, scopeTagName, scopeSelection, nameSelection)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (formatter.isPresent()) {
            return formatter.get();
        }
        throw new HttpException("Unsupported media type for metrics formatting: " + String.valueOf(mediaType), Status.UNSUPPORTED_MEDIA_TYPE_415, true);
    }

    private void getAll(ServerRequest req, ServerResponse res) {
        this.getMatching(req, res, req.query().all("scope", List::of), req.query().all("name", List::of));
    }

    private void getMatching(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MediaType mediaType = MetricsFeature.bestAccepted(req);
        res.header(HeaderValues.CACHE_NO_CACHE);
        if (mediaType == null) {
            res.status(Status.NOT_ACCEPTABLE_406);
            res.send();
            return;
        }
        this.getOrOptionsMatching(mediaType, res, () -> this.output(mediaType, scopeSelection, nameSelection));
    }

    private void getOrOptionsMatching(MediaType mediaType, ServerResponse res, Supplier<Optional<?>> dataSupplier) {
        Optional<?> output = dataSupplier.get();
        if (output.isPresent()) {
            res.status(Status.OK_200).headers().contentType(mediaType);
            res.send(output.get());
        } else {
            res.status(Status.NOT_FOUND_404);
            res.send();
        }
    }

    private void setUpEndpoints(HttpRules rules) {
        if (!this.metricsConfig.permitAll()) {
            rules.any(new Handler[]{SecureHandler.authorize((String[])this.metricsConfig.roles().toArray(new String[0]))});
        }
        rules.get("/", new Handler[]{this::getAll}).options("/", new Handler[]{this::optionsAll});
        Meter.Scope.BUILT_IN_SCOPES.forEach(scope -> {
            boolean isScopeEnabled = this.metricsConfig.isScopeEnabled(scope);
            rules.get("/" + scope, new Handler[]{isScopeEnabled ? (req, res) -> this.getMatching(req, res, Set.of(scope), Set.of()) : DISABLED_ENDPOINT_HANDLER}).get("/" + scope + "/{metric}", new Handler[]{isScopeEnabled ? (req, res) -> this.getByName(req, res, Set.of(scope)) : DISABLED_ENDPOINT_HANDLER}).options("/" + scope, new Handler[]{isScopeEnabled ? (req, res) -> this.optionsMatching(req, res, Set.of(scope), Set.of()) : DISABLED_ENDPOINT_HANDLER}).options("/" + scope + "/{metric}", new Handler[]{isScopeEnabled ? (req, res) -> this.optionsByName(req, res, Set.of(scope)) : DISABLED_ENDPOINT_HANDLER});
        });
    }

    private void getByName(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection) {
        String metricName = req.path().pathParameters().get("metric");
        this.getMatching(req, res, scopeSelection, Set.of(metricName));
    }

    private void postRequestProcessing(PostRequestMetricsSupport prms, ServerRequest request, ServerResponse response, Throwable throwable, KeyPerformanceIndicatorSupport.Context kpiContext) {
        kpiContext.requestProcessingCompleted(throwable == null && response.status().code() < 500);
        prms.runTasks(request, response, throwable);
    }

    private void optionsAll(ServerRequest req, ServerResponse res) {
        this.optionsMatching(req, res, req.query().all("scope", List::of), req.query().all("name", List::of));
    }

    private void optionsByName(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection) {
        String metricName = req.path().pathParameters().get("metric");
        this.optionsMatching(req, res, scopeSelection, Set.of(metricName));
    }

    private void optionsMatching(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MediaType mediaType = MetricsFeature.bestAcceptedForMetadata(req);
        if (mediaType == null) {
            res.header(HeaderNames.ALLOW, new String[]{"GET"});
            res.status(Status.METHOD_NOT_ALLOWED_405);
            res.send();
        }
        this.getOrOptionsMatching(mediaType, res, () -> this.outputMetadata(mediaType, scopeSelection, nameSelection));
    }

    private void setUpDisabledEndpoints(HttpRules rules) {
        rules.get("/", new Handler[]{DISABLED_ENDPOINT_HANDLER}).options("/", new Handler[]{DISABLED_ENDPOINT_HANDLER});
    }

    private class MetricsService
    implements HttpService {
        private MetricsService() {
        }

        public void routing(HttpRules rules) {
            if (MetricsFeature.this.metricsConfig.enabled()) {
                MetricsFeature.this.setUpEndpoints(rules);
            } else {
                MetricsFeature.this.setUpDisabledEndpoints(rules);
            }
        }

        public void afterStop() {
            MetricsFeature.this.kpiMetrics.close();
        }
    }
}

