/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.Weighted;
import io.helidon.common.config.Config;
import io.helidon.common.config.GlobalConfig;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.webserver.cors.CorsSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.observe.spi.ObserveProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class ObserveFeature
implements HttpFeature,
Weighted {
    private static final double WEIGHT = 80.0;
    private final List<ProviderSetup> providers;
    private final boolean enabled;
    private final String endpoint;
    private final double weight;

    private ObserveFeature(Builder builder, List<ProviderSetup> providerSetups) {
        this.enabled = builder.enabled;
        this.endpoint = builder.endpoint;
        this.weight = builder.weight;
        this.providers = providerSetups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ObserveFeature create(ObserveProvider ... providers) {
        return ((Builder)ObserveFeature.builder().useSystemServices(false).update(it -> {
            for (ObserveProvider provider : providers) {
                it.addProvider(provider);
            }
        })).build();
    }

    public static ObserveFeature create() {
        return ObserveFeature.builder().build();
    }

    public static ObserveFeature create(Config config) {
        return ObserveFeature.builder().config(config).build();
    }

    public void setup(HttpRouting.Builder routing) {
        if (this.enabled) {
            for (ProviderSetup provider : this.providers) {
                routing.register(provider.endpoint + "/*", new Supplier[]{provider.cors()});
                provider.provider().register(provider.config(), provider.endpoint(), routing);
            }
        } else {
            routing.get(this.endpoint, new Handler[]{(req, res) -> {
                throw new HttpException("Observe endpoint is disabled", Http.Status.SERVICE_UNAVAILABLE_503, true);
            }});
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, ObserveFeature> {
        private final HelidonServiceLoader.Builder<ObserveProvider> observeProviders = HelidonServiceLoader.builder(ServiceLoader.load(ObserveProvider.class));
        private double weight = 80.0;
        private CorsSupport corsSupport = CorsSupport.create();
        private boolean enabled = true;
        private String endpoint = "/observe";
        private Config config;

        private Builder() {
            this.config(GlobalConfig.config().get("observe"));
        }

        public ObserveFeature build() {
            List<ProviderSetup> providerSetups;
            if (this.enabled) {
                List observeProviders = this.observeProviders.build().asList();
                providerSetups = new ArrayList<ProviderSetup>(observeProviders.size());
                for (ObserveProvider provider : observeProviders) {
                    Config providerConfig = this.config.get(provider.configKey());
                    boolean enabled = (Boolean)providerConfig.get("enabled").asBoolean().orElse((Object)true);
                    if (!enabled) continue;
                    String endpoint = this.providerEndpoint((String)providerConfig.get("endpoint").asString().orElseGet(provider::defaultEndpoint));
                    CorsSupport cors = (CorsSupport)providerConfig.get("cors").map(CorsSupport::create).orElse((Object)this.corsSupport);
                    providerSetups.add(new ProviderSetup(endpoint, providerConfig, cors, provider));
                }
            } else {
                providerSetups = List.of();
            }
            return new ObserveFeature(this, providerSetups);
        }

        public Builder useSystemServices(boolean useServices) {
            this.observeProviders.useSystemServiceLoader(useServices);
            return this;
        }

        public Builder addProvider(ObserveProvider provider) {
            this.observeProviders.addService((Object)provider);
            return this;
        }

        public Builder config(Config config) {
            config.get("cors").map(CorsSupport::create).ifPresent(this::corsSupport);
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("endpoint").asString().ifPresent(this::endpoint);
            config.get("weight").asDouble().ifPresent(this::weight);
            this.config = config;
            return this;
        }

        private Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder corsSupport(CorsSupport cors) {
            this.corsSupport = cors;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private String providerEndpoint(String endpoint) {
            if (endpoint.startsWith("/")) {
                return endpoint;
            }
            return this.endpoint + "/" + endpoint;
        }
    }

    private record ProviderSetup(String endpoint, Config config, CorsSupport cors, ObserveProvider provider) {
    }
}

