/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import heretical.pointer.operation.BuildSpec;
import heretical.pointer.operation.BuildSpecDecorator;
import heretical.pointer.path.NestedPointerCompiler;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.BiFunction;

public class Builder<Node, Result>
implements Serializable {
    private final NestedPointerCompiler<Node, Result> nestedPointerCompiler;
    private final BuildSpecDecorator<Node>[] buildSpecs;

    public Builder(NestedPointerCompiler<Node, Result> nestedPointerCompiler, BuildSpec ... buildSpecs) {
        this.nestedPointerCompiler = nestedPointerCompiler;
        this.buildSpecs = BuildSpecDecorator.array(this.nestedPointerCompiler, buildSpecs);
        this.verify();
    }

    protected void verify() {
        for (BuildSpecDecorator<Node> copySpec : this.buildSpecs) {
            copySpec.verify();
        }
    }

    protected BuildSpecDecorator<Node>[] getBuildSpecs() {
        return this.buildSpecs;
    }

    public void build(BiFunction<Comparable, Type, Object> valuesLookup, Node resultNode) {
        this.buildLiterals(resultNode);
        this.buildNodes(valuesLookup, resultNode);
    }

    public void buildLiterals(Node resultNode) {
        for (BuildSpecDecorator<Node> buildSpec : this.buildSpecs) {
            if (buildSpec.getLiteralList().isEmpty()) continue;
            Node node = buildSpec.getIntoPointer().objectAt(resultNode);
            for (BuildSpecDecorator.LiteralDecorator literal : buildSpec.getLiteralList()) {
                Node canonical = this.nestedPointerCompiler.node(literal.getValue());
                literal.getIntoPointer().set(node, canonical);
            }
        }
    }

    public void buildNodes(BiFunction<Comparable, Type, Object> valuesLookup, Node resultNode) {
        for (BuildSpecDecorator<Node> buildSpec : this.buildSpecs) {
            Node node = buildSpec.getIntoPointer().objectAt(resultNode);
            for (BuildSpecDecorator.CopyDecorator copy : buildSpec.getCopyList()) {
                Object value = valuesLookup.apply(copy.getFromKey(), copy.getAsType());
                if (value == null) continue;
                Node canonical = this.nestedPointerCompiler.node(value);
                switch (copy.getMode()) {
                    case put: {
                        copy.getIntoPointer().set(node, canonical);
                        break;
                    }
                    case add: {
                        copy.getIntoPointer().add(node, canonical);
                    }
                }
            }
        }
    }
}

