/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import heretical.pointer.operation.Transform;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CopySpec<T extends CopySpec>
implements Serializable {
    public static final String ROOT = "";
    String into;
    Map<String, From> fromMap = new LinkedHashMap<String, From>();
    transient List<Transform> resettableTransforms;

    public CopySpec() {
        this.into = ROOT;
    }

    public CopySpec(String intoPointer) {
        this.into = intoPointer;
    }

    protected T self() {
        return (T)this;
    }

    public T from(String fromPointer) {
        this.getFrom(fromPointer);
        return this.self();
    }

    public T from(String fromPointer, Predicate<?> predicate) {
        this.getFrom(fromPointer, predicate);
        return this.self();
    }

    public T fromInclude(String fromPointer, String ... includePointers) {
        this.getFrom(fromPointer).addIncludes(includePointers);
        return this.self();
    }

    public T fromInclude(String fromPointer, String includePointer, Predicate<?> predicate) {
        this.getFrom(fromPointer).addInclude(includePointer, predicate);
        return this.self();
    }

    public T include(String ... includePointers) {
        this.getFrom(ROOT).addIncludes(includePointers);
        return this.self();
    }

    public T include(String includePointer, Predicate predicate) {
        this.getFrom(ROOT).addInclude(includePointer, predicate);
        return this.self();
    }

    public T fromExclude(String fromPointer, String ... excludePointers) {
        this.getFrom(fromPointer).addExcludes(excludePointers);
        return this.self();
    }

    public T exclude(String ... excludePointers) {
        this.getFrom(ROOT).addExcludes(excludePointers);
        return this.self();
    }

    public T fromTransform(String fromPointer, String valuePointer, Function<?, ?> transform) {
        this.getFrom(fromPointer).addTransform(valuePointer, transform);
        return this.self();
    }

    public T transform(String valuePointer, Function<?, ?> transform) {
        this.getFrom(ROOT).addTransform(valuePointer, transform);
        return this.self();
    }

    void resetTransforms(Map<Comparable, Object> values) {
        this.getResettableTransforms().forEach(transform -> transform.reset(values));
    }

    protected List<Transform> getResettableTransforms() {
        if (this.resettableTransforms != null) {
            return this.resettableTransforms;
        }
        this.resettableTransforms = this.getFromMap().values().stream().flatMap(from -> from.getTransforms().values().stream()).filter(Transform.class::isInstance).map(Transform.class::cast).filter(Transform::isResettable).collect(Collectors.toList());
        return this.resettableTransforms;
    }

    protected From getFrom(String from) {
        return this.getFrom(from, null);
    }

    protected From getFrom(String from, Predicate<?> predicate) {
        From result = this.fromMap.get(from);
        if (result != null) {
            if (predicate != null && result.filter != null) {
                throw new IllegalStateException("may only have one filter, found: " + result.filter);
            }
            if (predicate != null) {
                result.filter = predicate;
            }
            return result;
        }
        result = new From(from, predicate);
        this.fromMap.put(from, result);
        return result;
    }

    public String getInto() {
        return this.into;
    }

    public Map<String, From> getFromMap() {
        return this.fromMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CopySpec{");
        sb.append("into='").append(this.into).append('\'');
        sb.append(", fromMap=").append(this.fromMap);
        sb.append(", resettableTransforms=").append(this.resettableTransforms);
        sb.append('}');
        return sb.toString();
    }

    protected static class From
    implements Serializable {
        String from;
        Predicate<?> filter;
        Map<String, Predicate<?>> includes = new LinkedHashMap();
        List<String> excludes = new LinkedList<String>();
        Map<String, Function<?, ?>> transforms = new LinkedHashMap();

        protected From(String from, Predicate<?> filter) {
            this.from = from;
            this.filter = filter;
        }

        public String getFrom() {
            return this.from;
        }

        public Predicate<?> getFilter() {
            return this.filter;
        }

        public Map<String, Predicate<?>> getIncludes() {
            if (this.includes.isEmpty()) {
                return Collections.singletonMap(CopySpec.ROOT, this.filter);
            }
            return this.includes;
        }

        public From addInclude(String include, Predicate<?> predicate) {
            this.includes.put(include, predicate);
            return this;
        }

        public From addIncludes(String ... includes) {
            for (String include : includes) {
                this.includes.put(include, null);
            }
            return this;
        }

        public List<String> getExcludes() {
            return this.excludes;
        }

        public From addExcludes(String ... excludes) {
            Collections.addAll(this.excludes, excludes);
            return this;
        }

        public Map<String, Function<?, ?>> getTransforms() {
            return this.transforms;
        }

        public void addTransform(String pointer, Function<?, ?> transform) {
            this.transforms.put(pointer, transform);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("From{");
            sb.append("from='").append(this.from).append('\'');
            sb.append(", includes=").append(this.includes);
            sb.append(", excludes=").append(this.excludes);
            sb.append(", transforms=").append(this.transforms);
            sb.append('}');
            return sb.toString();
        }
    }
}

