/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import heretical.pointer.operation.CopySpec;
import heretical.pointer.path.NestedPointer;
import heretical.pointer.path.NestedPointerCompiler;
import heretical.pointer.path.Pointer;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class CopySpecDecorator<Node>
implements Serializable {
    private final CopySpec<?> copySpec;
    private final NestedPointerCompiler<Node, ?> compiler;
    private transient List<FromDecorator> fromSpecs;
    private transient Pointer<Node> intoPointer;

    public static <Node> CopySpecDecorator<Node>[] array(NestedPointerCompiler<Node, ?> compiler, CopySpec ... copySpecs) {
        CopySpecDecorator[] results = new CopySpecDecorator[copySpecs.length];
        for (int i = 0; i < copySpecs.length; ++i) {
            results[i] = new CopySpecDecorator<Node>(copySpecs[i], compiler);
        }
        return results;
    }

    public CopySpecDecorator(CopySpec copySpec, NestedPointerCompiler<Node, ?> compiler) {
        this.copySpec = copySpec;
        this.compiler = compiler;
    }

    public void resetTransforms(Map<Comparable, Object> values) {
        this.copySpec.resetTransforms(values);
    }

    public String getInto() {
        return this.copySpec.getInto();
    }

    public List<FromDecorator> getFromSpecs() {
        if (this.fromSpecs != null) {
            return this.fromSpecs;
        }
        this.fromSpecs = this.copySpec.getFromMap().values().stream().map(x$0 -> new FromDecorator((CopySpec.From)x$0)).collect(Collectors.toList());
        return this.fromSpecs;
    }

    public void verify() {
        try {
            this.getIntoPointer();
            for (FromDecorator from : this.getFromSpecs()) {
                from.getFromPointer();
                from.getIncludePointers();
                from.getExcludePointers();
            }
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException("CopySpec has invalid pointer: " + this.toString(), exception);
        }
    }

    public Pointer<Node> getIntoPointer() {
        if (this.intoPointer == null) {
            this.intoPointer = this.compiler.compile(this.copySpec.getInto());
        }
        return this.intoPointer;
    }

    public String toString() {
        return this.copySpec.toString();
    }

    public class FromDecorator {
        private final CopySpec.From from;
        private transient Map<NestedPointer<Node, ?>, Predicate<Node>> includePointers;
        private transient List<NestedPointer<Node, ?>> excludePointers;
        private transient Map<NestedPointer<Node, ?>, Function<Node, Node>> transformPointers;

        public FromDecorator(CopySpec.From from) {
            this.from = from;
        }

        public NestedPointer<Node, ?> getFromPointer() {
            return CopySpecDecorator.this.compiler.nested(this.from.from);
        }

        public Map<NestedPointer<Node, ?>, Predicate<Node>> getIncludePointers() {
            if (this.includePointers != null) {
                return this.includePointers;
            }
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry<String, Predicate<?>> entry : this.from.getIncludes().entrySet()) {
                map.putIfAbsent(CopySpecDecorator.this.compiler.nested(entry.getKey()), entry.getValue());
            }
            this.includePointers = map;
            return this.includePointers;
        }

        public List<NestedPointer<Node, ?>> getExcludePointers() {
            if (this.excludePointers != null) {
                return this.excludePointers;
            }
            this.excludePointers = this.from.getExcludes().stream().map(CopySpecDecorator.this.compiler::nested).collect(Collectors.toList());
            return this.excludePointers;
        }

        public Predicate<Node> getFilter() {
            return this.from.getFilter();
        }

        public Map<NestedPointer<Node, ?>, Function<Node, Node>> getTransformPointers() {
            if (this.transformPointers != null) {
                return this.transformPointers;
            }
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry<String, Function<?, ?>> entry : this.from.getTransforms().entrySet()) {
                map.putIfAbsent(CopySpecDecorator.this.compiler.nested(entry.getKey()), entry.getValue());
            }
            this.transformPointers = map;
            return this.transformPointers;
        }

        public String toString() {
            return this.from.toString();
        }
    }
}

