/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path;

import heretical.pointer.path.DescentResolver;
import heretical.pointer.path.FinalResolver;
import heretical.pointer.path.NestedPointer;
import heretical.pointer.path.Pointer;
import heretical.pointer.path.PointerCompiler;
import heretical.pointer.path.PointerResolver;
import heretical.pointer.path.Resolver;
import heretical.pointer.path.WildCardResolver;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class BaseNestedPointer<Node, Result>
implements NestedPointer<Node, Result> {
    private static Pattern pattern = Pattern.compile("((?<=/[*]{1,2}+)|(?=/[*]{1,2}+))");
    final PointerCompiler<Node, Result> compiler;
    final String pointer;
    Resolver<Node, Result> resolver;
    boolean isAbsolute = true;

    protected BaseNestedPointer(PointerCompiler<Node, Result> compiler, String pointer) {
        this.compiler = compiler;
        this.pointer = pointer;
        this.build();
    }

    private void build() {
        String[] split = pattern.split(this.pointer);
        this.resolver = new Resolver<Node, Result>(this.compiler);
        Resolver<Node, Result> current = this.resolver;
        String[] stringArray = split;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String token;
            switch (token = stringArray[i]) {
                case "/**": {
                    current = current.setNext(new DescentResolver<Node, Result>(this.compiler));
                    this.isAbsolute = false;
                    continue block8;
                }
                case "/*": {
                    current = current.setNext(new WildCardResolver<Node, Result>(this.compiler));
                    this.isAbsolute = false;
                    continue block8;
                }
                default: {
                    current = current.setNext(new PointerResolver<Node, Result>(this.compiler, token));
                }
            }
        }
        current.setNext(new FinalResolver<Node, Result>(this.compiler));
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public Pointer<Node> asPointer() {
        if (!this.isAbsolute) {
            return null;
        }
        return ((PointerResolver)this.resolver.next).pointer;
    }

    protected Node absoluteAt(Node node) {
        return this.asPointer().at(node);
    }

    @Override
    public Result allAt(Node root) {
        if (this.isAbsolute()) {
            return this.compiler.add(this.compiler.resultNode(), this.absoluteAt(root));
        }
        return this.resolver.resolve(this.resolver, root, this.compiler.resultNode());
    }

    @Override
    public Node at(Node root) {
        if (root == null) {
            return null;
        }
        if (this.isAbsolute()) {
            return this.absoluteAt(root);
        }
        Result result = this.resolver.resolve(this.resolver, root, this.compiler.resultNode());
        return this.compiler.first(result);
    }

    @Override
    public Result remove(Node root) {
        if (this.isAbsolute()) {
            return this.compiler.add(this.compiler.resultNode(), this.asPointer().remove(root));
        }
        return this.resolver.remove(this.resolver, null, null, root);
    }

    @Override
    public void copy(Node from, Node into, Predicate<Node> filter) {
        if (this.isAbsolute()) {
            this.asPointer().copy(from, into, filter);
        } else {
            this.resolver.copy(this.resolver, null, from, from, null, into, filter);
        }
    }

    @Override
    public void apply(Node root, Function<Node, Node> transform) {
        if (this.isAbsolute()) {
            this.asPointer().apply(root, transform);
        } else {
            this.resolver.set(this.resolver, null, null, root, transform);
        }
    }

    public String toString() {
        return this.pointer;
    }
}

