/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path;

import heretical.pointer.path.Pointer;
import heretical.pointer.path.PointerCompiler;
import heretical.pointer.path.Resolver;
import heretical.pointer.util.PathTree;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

class DescentResolver<Node, Result>
extends Resolver<Node, Result> {
    public DescentResolver(PointerCompiler<Node, Result> compiler) {
        super(compiler);
    }

    @Override
    boolean isDescent() {
        return true;
    }

    @Override
    Result resolve(Resolver<Node, Result> previous, Node node, Result result) {
        if (node == null) {
            return null;
        }
        this.next.resolve(this, node, result);
        return this.recursiveAdd(this.compiler.iterable(node), result);
    }

    private Result recursiveAdd(Iterable<Node> node, Result result) {
        for (Node child : node) {
            this.next.resolve(this, child, result);
            if (!this.compiler.isContainer(child)) continue;
            this.recursiveAdd(this.compiler.iterable(child), result);
        }
        return result;
    }

    @Override
    Result remove(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node child) {
        if (child == null) {
            return null;
        }
        Object result = this.compiler.resultNode();
        Object remove = this.next.remove(this, parent, pointer, child);
        this.compiler.addAll(result, remove);
        return this.recursiveRemove(result, child);
    }

    private Result recursiveRemove(Result result, Node node) {
        switch (this.compiler.kind(node)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(node)) {
                    Object removed = this.next.remove(this, node, this.compiler.compile("/" + i), child);
                    this.compiler.addAll(result, removed);
                    this.recursiveRemove(result, child);
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(node);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    String key = next.getKey();
                    Node child = next.getValue();
                    Object removed = this.next.remove(this, node, this.compiler.compile("/" + key), child);
                    this.compiler.addAll(result, removed);
                    this.recursiveRemove(result, child);
                }
                break;
            }
        }
        return result;
    }

    @Override
    public void set(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node child, Function<Node, Node> transform) {
        if (child == null) {
            return;
        }
        this.next.set(this, parent, pointer, child, transform);
        this.recursiveSet(child, transform);
    }

    private void recursiveSet(Node node, Function<Node, Node> transform) {
        switch (this.compiler.kind(node)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(node)) {
                    this.next.set(this, node, this.compiler.compile("/" + i), child, transform);
                    ++i;
                    this.recursiveSet(child, transform);
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(node);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    String key = next.getKey();
                    Node child = next.getValue();
                    this.next.set(this, node, this.compiler.compile("/" + key), child, transform);
                    this.recursiveSet(child, transform);
                }
                break;
            }
        }
    }

    @Override
    public void copy(Resolver<Node, Result> previous, Deque<String> queue, Node root, Node from, Pointer<Node> pointer, Node into, Predicate<Node> filter) {
        this.copyNew(queue, root, from, pointer, into, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNew(Deque<String> queue, Node root, Node from, Pointer<Node> pointer, Node into, Predicate<Node> filter) {
        if (from == null) {
            return;
        }
        if (this.next.isFinal() && filter == null) {
            this.next.copy(this, queue, root, from, pointer, into, filter);
            return;
        }
        PathTree pathTree = new PathTree();
        this.buildTree(pathTree.root(), from);
        for (String path : pathTree.depthFirstPointers()) {
            queue.addLast(path);
            Pointer<Node> childPointer = this.compiler.compile(path);
            Object child = childPointer.at(from);
            try {
                this.next.copy(this, queue, root, child, childPointer, into, filter);
            }
            finally {
                queue.removeLast();
            }
        }
    }

    private void buildTree(PathTree.Element current, Node from) {
        switch (this.compiler.kind(from)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(from)) {
                    this.buildTree(current.child(i++), child);
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(from);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    String key = next.getKey();
                    Node child = next.getValue();
                    this.buildTree(current.child(key), child);
                }
                break;
            }
        }
    }
}

