/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PathTree {
    private Element root = new Element();

    public Element root() {
        return this.root;
    }

    public Element child(String path) {
        return this.root.child(path);
    }

    public List<String> leafPointers() {
        LinkedList<String> pointers = new LinkedList<String>();
        this.addPointer(pointers, this.root, true);
        return pointers;
    }

    public List<String> depthFirstPointers() {
        LinkedList<String> pointers = new LinkedList<String>();
        this.addPointer(pointers, this.root, false);
        return pointers;
    }

    private void addPointer(List<String> pointers, Element element, boolean leavesOnly) {
        element.children.values().forEach(e -> this.addPointer(pointers, (Element)e, leavesOnly));
        if (!leavesOnly || element.children.isEmpty()) {
            pointers.add(element.pointer());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PathTree{");
        sb.append(this.leafPointers());
        sb.append('}');
        return sb.toString();
    }

    public class Element {
        PathTree tree;
        Element parent;
        String path;
        Map<Comparable, Element> children;

        private Element() {
            this.tree = PathTree.this;
            this.parent = null;
            this.path = "";
            this.children = new LinkedHashMap<Comparable, Element>();
        }

        Element(Element parent, Comparable path) {
            this.tree = PathTree.this;
            this.parent = null;
            this.path = "";
            this.children = new LinkedHashMap<Comparable, Element>();
            this.parent = parent;
            this.path = path.toString();
        }

        public PathTree tree() {
            return this.tree;
        }

        public Element child(String path) {
            return this.children.computeIfAbsent((Comparable)((Object)path), p -> new Element(this, (Comparable)p));
        }

        public Element child(int ordinal) {
            return this.children.computeIfAbsent(Integer.valueOf(ordinal), o -> new Element(this, (Comparable)o));
        }

        public String pointer() {
            LinkedList<String> paths = new LinkedList<String>();
            this.addPath(paths, this);
            return paths.stream().collect(Collectors.joining("/"));
        }

        private void addPath(LinkedList<String> paths, Element element) {
            if (element == null) {
                return;
            }
            paths.addFirst(element.path);
            this.addPath(paths, element.parent);
        }
    }
}

