/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateMacroDesc;
import org.apache.hadoop.hive.ql.plan.DropMacroDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(MacroSemanticAnalyzer.class);

    public MacroSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 781) {
            LOG.debug("Analyzing create macro " + ast.dump());
            this.analyzeCreateMacro(ast);
        }
        if (ast.getToken().getType() == 818) {
            LOG.debug("Analyzing drop macro " + ast.dump());
            this.analyzeDropMacro(ast);
        }
    }

    private void analyzeCreateMacro(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        if (FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary macro cannot be created with a qualified name.");
        }
        List<FieldSchema> arguments = BaseSemanticAnalyzer.getColumns((ASTNode)ast.getChild(1), true, this.conf);
        boolean isNoArgumentMacro = arguments.size() == 0;
        RowResolver rowResolver = new RowResolver();
        ArrayList<String> macroColNames = new ArrayList<String>(arguments.size());
        ArrayList<TypeInfo> macroColTypes = new ArrayList<TypeInfo>(arguments.size());
        final HashSet actualColumnNames = new HashSet();
        if (!isNoArgumentMacro) {
            Node expression = (Node)ast.getChild(2);
            PreOrderWalker walker = new PreOrderWalker(new Dispatcher(){

                @Override
                public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
                    ASTNode node;
                    if (nd instanceof ASTNode && (node = (ASTNode)nd).getType() == 1058) {
                        actualColumnNames.add(node.getChild(0).getText());
                    }
                    return null;
                }
            });
            walker.startWalking(Collections.singletonList(expression), null);
        }
        for (FieldSchema argument : arguments) {
            TypeInfo colType = TypeInfoUtils.getTypeInfoFromTypeString(argument.getType());
            rowResolver.put("", argument.getName(), new ColumnInfo(argument.getName(), colType, "", false));
            macroColNames.add(argument.getName());
            macroColTypes.add(colType);
        }
        LinkedHashSet expectedColumnNames = new LinkedHashSet(macroColNames);
        if (!expectedColumnNames.equals(actualColumnNames)) {
            throw new SemanticException("Expected columns " + expectedColumnNames + " but found " + actualColumnNames);
        }
        if (expectedColumnNames.size() != macroColNames.size()) {
            throw new SemanticException("At least one parameter name was used more than once " + macroColNames);
        }
        SemanticAnalyzer sa = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(this.queryState) : new SemanticAnalyzer(this.queryState);
        ExprNodeDesc body = isNoArgumentMacro ? sa.genExprNodeDesc((ASTNode)ast.getChild(1), rowResolver) : sa.genExprNodeDesc((ASTNode)ast.getChild(2), rowResolver);
        CreateMacroDesc desc = new CreateMacroDesc(functionName, macroColNames, macroColTypes, body);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc)));
        this.addEntities();
    }

    private void analyzeDropMacro(ASTNode ast) throws SemanticException {
        boolean throwException;
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(855) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary macro name cannot be a qualified name.");
        }
        if (throwException && FunctionRegistry.getFunctionInfo(functionName) == null) {
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
        }
        DropMacroDesc desc = new DropMacroDesc(functionName);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc)));
        this.addEntities();
    }

    private void addEntities() throws SemanticException {
        Database database = this.getDatabase("default");
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

