/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.datatypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.datatypes.PrimitiveDataType;
import org.apache.carbondata.processing.loading.complexobjects.StructObject;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;

public class StructDataType
implements GenericDataType<StructObject> {
    private List<GenericDataType> children = new ArrayList<GenericDataType>();
    private String name;
    private String parentName;
    private String columnId;
    private int outputArrayIndex;
    private boolean isDictionary;
    private int dataCounter;
    private int depth;

    private StructDataType(List<GenericDataType> children, int outputArrayIndex, int dataCounter, String name) {
        this.children = children;
        this.outputArrayIndex = outputArrayIndex;
        this.dataCounter = dataCounter;
        this.name = name;
    }

    public StructDataType(String name, String parentName, String columnId) {
        this.name = name;
        this.parentName = parentName;
        this.columnId = columnId;
    }

    public StructDataType(String name, String parentName, String columnId, Boolean isDictionary) {
        this.name = name;
        this.parentName = parentName;
        this.columnId = columnId;
        this.isDictionary = isDictionary;
    }

    @Override
    public void addChildren(GenericDataType newChild) {
        if (this.getName().equals(newChild.getParentName())) {
            this.children.add(newChild);
        } else {
            for (GenericDataType child : this.children) {
                child.addChildren(newChild);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getColumnNames() {
        return this.columnId;
    }

    @Override
    public void getAllPrimitiveChildren(List<GenericDataType> primitiveChild) {
        for (int i = 0; i < this.children.size(); ++i) {
            GenericDataType child = this.children.get(i);
            if (child instanceof PrimitiveDataType) {
                primitiveChild.add(child);
                continue;
            }
            child.getAllPrimitiveChildren(primitiveChild);
        }
    }

    @Override
    public void setSurrogateIndex(int surrIndex) {
    }

    @Override
    public boolean getIsColumnDictionary() {
        return this.isDictionary;
    }

    @Override
    public void writeByteArray(StructObject input, DataOutputStream dataOutputStream, BadRecordLogHolder logHolder, Boolean isWithoutConverter) throws IOException {
        dataOutputStream.writeShort(this.children.size());
        if (input == null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).writeByteArray(null, dataOutputStream, logHolder, isWithoutConverter);
            }
        } else {
            int i;
            Object[] data = input.getData();
            for (i = 0; i < data.length && i < this.children.size(); ++i) {
                this.children.get(i).writeByteArray(data[i], dataOutputStream, logHolder, isWithoutConverter);
            }
            for (i = data.length; i < this.children.size(); ++i) {
                this.children.get(i).writeByteArray(null, dataOutputStream, logHolder, isWithoutConverter);
            }
        }
    }

    @Override
    public void parseComplexValue(ByteBuffer byteArrayInput, DataOutputStream dataOutputStream) throws IOException, KeyGenException {
        int childElement = byteArrayInput.getShort();
        dataOutputStream.writeShort(childElement);
        for (int i = 0; i < childElement; ++i) {
            if (this.children.get(i) instanceof PrimitiveDataType && this.children.get(i).getIsColumnDictionary()) {
                dataOutputStream.writeInt(ByteUtil.dateBytesSize());
            }
            this.children.get(i).parseComplexValue(byteArrayInput, dataOutputStream);
        }
    }

    @Override
    public int getColsCount() {
        int colsCount = 1;
        for (int i = 0; i < this.children.size(); ++i) {
            colsCount += this.children.get(i).getColsCount();
        }
        return colsCount;
    }

    @Override
    public void setOutputArrayIndex(int outputArrayIndex) {
        this.outputArrayIndex = outputArrayIndex++;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) instanceof PrimitiveDataType) {
                this.children.get(i).setOutputArrayIndex(outputArrayIndex++);
                continue;
            }
            this.children.get(i).setOutputArrayIndex(outputArrayIndex++);
            outputArrayIndex = this.getMaxOutputArrayIndex() + 1;
        }
    }

    @Override
    public int getMaxOutputArrayIndex() {
        int currentMax = this.outputArrayIndex;
        for (int i = 0; i < this.children.size(); ++i) {
            int childMax = this.children.get(i).getMaxOutputArrayIndex();
            if (childMax <= currentMax) continue;
            currentMax = childMax;
        }
        return currentMax;
    }

    @Override
    public void getColumnarDataForComplexType(List<ArrayList<byte[]>> columnsArray, ByteBuffer inputArray) {
        ByteBuffer b = ByteBuffer.allocate(2);
        int childElement = inputArray.getShort();
        b.putShort((short)childElement);
        columnsArray.get(this.outputArrayIndex).add(b.array());
        for (int i = 0; i < childElement; ++i) {
            PrimitiveDataType child;
            if (this.children.get(i) instanceof PrimitiveDataType && (child = (PrimitiveDataType)this.children.get(i)).getIsColumnDictionary()) {
                child.setKeySize(inputArray.getInt());
            }
            this.children.get(i).getColumnarDataForComplexType(columnsArray, inputArray);
        }
        ++this.dataCounter;
    }

    @Override
    public int getDataCounter() {
        return this.dataCounter;
    }

    @Override
    public GenericDataType<StructObject> deepCopy() {
        ArrayList<GenericDataType> childrenClone = new ArrayList<GenericDataType>();
        for (GenericDataType child : this.children) {
            childrenClone.add(child.deepCopy());
        }
        return new StructDataType(childrenClone, this.outputArrayIndex, this.dataCounter, this.name);
    }

    @Override
    public void getComplexColumnInfo(List<ComplexColumnInfo> columnInfoList) {
        columnInfoList.add(new ComplexColumnInfo(ColumnType.COMPLEX_STRUCT, DataTypeUtil.valueOf((String)"struct"), this.name, false));
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).getComplexColumnInfo(columnInfoList);
        }
    }

    @Override
    public int getDepth() {
        if (this.depth == 0) {
            ArrayList<ComplexColumnInfo> complexColumnInfoList = new ArrayList<ComplexColumnInfo>();
            this.getComplexColumnInfo(complexColumnInfoList);
            this.depth = complexColumnInfoList.size();
        }
        return this.depth;
    }
}

