/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.index.IndexMeta;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.processing.index.IndexWriterException;
import org.apache.carbondata.processing.store.TablePage;
import org.apache.log4j.Logger;

public class IndexWriterListener {
    private static final Logger LOG = LogServiceFactory.getLogService((String)IndexWriterListener.class.getCanonicalName());
    private Map<List<CarbonColumn>, List<IndexWriter>> registry = new ConcurrentHashMap<List<CarbonColumn>, List<IndexWriter>>();
    private CarbonTableIdentifier tblIdentifier;

    public CarbonTableIdentifier getTblIdentifier() {
        return this.tblIdentifier;
    }

    public void registerAllWriter(CarbonTable carbonTable, String segmentId, String taskNo, SegmentProperties segmentProperties) {
        List tableIndices;
        IndexStoreManager.getInstance().clearIndex(carbonTable.getTableId());
        try {
            tableIndices = IndexStoreManager.getInstance().getAllCGAndFGIndexes(carbonTable);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while retrieving indexes", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.tblIdentifier = carbonTable.getCarbonTableIdentifier();
        for (TableIndex tableIndex : tableIndices) {
            if (tableIndex.getIndexSchema().isLazy()) continue;
            IndexFactory factory = tableIndex.getIndexFactory();
            this.register(factory, segmentId, taskNo, segmentProperties);
        }
    }

    private void register(IndexFactory factory, String segmentId, String taskNo, SegmentProperties segmentProperties) {
        assert (factory != null);
        assert (segmentId != null);
        IndexMeta meta = factory.getMeta();
        if (meta == null) {
            return;
        }
        List columns = factory.getMeta().getIndexedColumns();
        List<IndexWriter> writers = this.registry.get(columns);
        IndexWriter writer = null;
        try {
            writer = factory.createWriter(new Segment(segmentId), taskNo, segmentProperties);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create IndexWriter: " + e.getMessage()), (Throwable)e);
            throw new IndexWriterException(e);
        }
        if (writers != null) {
            writers.add(writer);
        } else {
            writers = new ArrayList<IndexWriter>();
            writers.add(writer);
            this.registry.put(columns, writers);
        }
        LOG.info((Object)("IndexWriter " + writer + " added"));
    }

    public void onBlockStart(String blockId) throws IOException {
        for (List<IndexWriter> writers : this.registry.values()) {
            for (IndexWriter writer : writers) {
                writer.onBlockStart(blockId);
            }
        }
    }

    public void onBlockEnd(String blockId) throws IOException {
        for (List<IndexWriter> writers : this.registry.values()) {
            for (IndexWriter writer : writers) {
                writer.onBlockEnd(blockId);
            }
        }
    }

    public void onBlockletStart(int blockletId) throws IOException {
        for (List<IndexWriter> writers : this.registry.values()) {
            for (IndexWriter writer : writers) {
                writer.onBlockletStart(blockletId);
            }
        }
    }

    public void onBlockletEnd(int blockletId) throws IOException {
        for (List<IndexWriter> writers : this.registry.values()) {
            for (IndexWriter writer : writers) {
                writer.onBlockletEnd(blockletId);
            }
        }
    }

    public void onPageAdded(int blockletId, int pageId, TablePage tablePage) throws IOException {
        Set<Map.Entry<List<CarbonColumn>, List<IndexWriter>>> entries = this.registry.entrySet();
        for (Map.Entry<List<CarbonColumn>, List<IndexWriter>> entry : entries) {
            List<CarbonColumn> indexedColumns = entry.getKey();
            ColumnPage[] pages = new ColumnPage[indexedColumns.size()];
            for (int i = 0; i < indexedColumns.size(); ++i) {
                pages[i] = tablePage.getColumnPage(indexedColumns.get(i).getColName());
            }
            List<IndexWriter> writers = entry.getValue();
            int pageSize = pages[0].getPageSize();
            for (IndexWriter writer : writers) {
                writer.onPageAdded(blockletId, pageId, pageSize, pages);
            }
        }
    }

    public void finish() throws IOException {
        for (List<IndexWriter> writers : this.registry.values()) {
            for (IndexWriter writer : writers) {
                writer.finish();
            }
        }
        this.registry.clear();
    }
}

