/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;

public class BadRecordsLoggerProvider {
    public static BadRecordsLogger createBadRecordLogger(CarbonDataLoadConfiguration configuration) {
        boolean badRecordsLogRedirect = false;
        boolean badRecordConvertNullDisable = false;
        boolean isDataLoadFail = false;
        boolean badRecordsLoggerEnable = Boolean.parseBoolean(configuration.getDataLoadProperty("BAD_RECORDS_LOGGER_ENABLE").toString());
        String bad_records_action = configuration.getDataLoadProperty("BAD_RECORDS_LOGGER_ACTION").toString();
        if (null != bad_records_action) {
            LoggerAction loggerAction = null;
            try {
                loggerAction = LoggerAction.valueOf((String)bad_records_action.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                loggerAction = LoggerAction.FORCE;
            }
            switch (loggerAction) {
                case FORCE: {
                    badRecordConvertNullDisable = false;
                    break;
                }
                case REDIRECT: {
                    badRecordsLogRedirect = true;
                    badRecordConvertNullDisable = true;
                    break;
                }
                case IGNORE: {
                    badRecordsLogRedirect = false;
                    badRecordConvertNullDisable = true;
                    break;
                }
                case FAIL: {
                    isDataLoadFail = true;
                }
            }
        }
        CarbonTableIdentifier identifier = configuration.getTableIdentifier().getCarbonTableIdentifier();
        return new BadRecordsLogger(identifier.getBadRecordLoggerKey(), identifier.getTableName() + '_' + System.currentTimeMillis(), BadRecordsLoggerProvider.getBadLogStoreLocation(configuration), badRecordsLogRedirect, badRecordsLoggerEnable, badRecordConvertNullDisable, isDataLoadFail);
    }

    public static String getBadLogStoreLocation(CarbonDataLoadConfiguration configuration) {
        String badLogStoreLocation = (String)configuration.getDataLoadProperty("carbon.options.bad.record.path");
        return CarbonTablePath.generateBadRecordsPath((String)badLogStoreLocation, (String)configuration.getSegmentId(), (String)configuration.getTaskNo(), (boolean)configuration.isCarbonTransactionalTable());
    }
}

