/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.SortColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.processing.loading.DataField;

public class CarbonDataLoadConfiguration {
    private DataField[] dataFields;
    private AbsoluteTableIdentifier tableIdentifier;
    private String[] header;
    private String segmentId;
    private String taskNo;
    private BucketingInfo bucketingInfo;
    private String bucketHashMethod;
    private String segmentPath;
    private Map<String, Object> dataLoadProperties = new HashMap<String, Object>();
    private boolean preFetch;
    private int dimensionCount;
    private int measureCount;
    private int noDictionaryCount;
    private int complexDictionaryColumnCount;
    private int complexNonDictionaryColumnCount;
    private long schemaUpdatedTimeStamp;
    private int numberOfSortColumns;
    private int numberOfNoDictSortColumns;
    private TableSpec tableSpec;
    private short writingCoresCount;
    private SortColumnRangeInfo sortColumnRangeInfo;
    private boolean carbonTransactionalTable;
    private String dataWritePath;
    private String columnCompressor;
    private int numberOfLoadingCores;
    private DataLoadMetrics metrics;
    private boolean nonSchemaColumnsPresent;
    private boolean skipParsers = false;

    public boolean isSkipParsers() {
        return this.skipParsers;
    }

    public void setSkipParsers(boolean skipParsers) {
        this.skipParsers = skipParsers;
    }

    public void setDataFields(DataField[] dataFields) {
        this.dataFields = dataFields;
        for (DataField dataField : dataFields) {
            CarbonColumn column = dataField.getColumn();
            if (column.isDimension().booleanValue()) {
                ++this.dimensionCount;
                if (column.isComplex().booleanValue()) {
                    if (!dataField.isDateDataType()) {
                        ++this.complexNonDictionaryColumnCount;
                    } else {
                        ++this.complexDictionaryColumnCount;
                    }
                } else if (!dataField.isDateDataType()) {
                    ++this.noDictionaryCount;
                }
            }
            if (!column.isMeasure().booleanValue()) continue;
            ++this.measureCount;
        }
    }

    public DataField[] getDataFields() {
        return this.dataFields;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public int getNoDictionaryCount() {
        return this.noDictionaryCount;
    }

    public int getComplexDictionaryColumnCount() {
        return this.complexDictionaryColumnCount;
    }

    public int getMeasureCount() {
        return this.measureCount;
    }

    public void setNumberOfSortColumns(int numberOfSortColumns) {
        this.numberOfSortColumns = numberOfSortColumns;
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public boolean isSortTable() {
        return this.numberOfSortColumns > 0;
    }

    public void setNumberOfNoDictSortColumns(int numberOfNoDictSortColumns) {
        this.numberOfNoDictSortColumns = numberOfNoDictSortColumns;
    }

    public int getNumberOfNoDictSortColumns() {
        return this.numberOfNoDictSortColumns;
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public AbsoluteTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setTableIdentifier(AbsoluteTableIdentifier tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public void setDataLoadProperty(String key, Object value) {
        this.dataLoadProperties.put(key, value);
    }

    public Object getDataLoadProperty(String key) {
        return this.dataLoadProperties.get(key);
    }

    public BucketingInfo getBucketingInfo() {
        return this.bucketingInfo;
    }

    public void setBucketingInfo(BucketingInfo bucketingInfo) {
        this.bucketingInfo = bucketingInfo;
    }

    public boolean isPreFetch() {
        return this.preFetch;
    }

    public void setPreFetch(boolean preFetch) {
        this.preFetch = preFetch;
    }

    public long getSchemaUpdatedTimeStamp() {
        return this.schemaUpdatedTimeStamp;
    }

    public void setSchemaUpdatedTimeStamp(long schemaUpdatedTimeStamp) {
        this.schemaUpdatedTimeStamp = schemaUpdatedTimeStamp;
    }

    public DataType[] getMeasureDataType() {
        List visibleMeasures = this.tableSpec.getCarbonTable().getVisibleMeasures();
        DataType[] type = new DataType[visibleMeasures.size()];
        for (int i = 0; i < type.length; ++i) {
            type[i] = ((CarbonMeasure)visibleMeasures.get(i)).getDataType();
        }
        return type;
    }

    public DataType[] getMeasureDataTypeAsDataFieldOrder() {
        ArrayList<Integer> measureIndexes = new ArrayList<Integer>(this.dataFields.length);
        int measureCount = 0;
        for (int i = 0; i < this.dataFields.length; ++i) {
            if (this.dataFields[i].getColumn().isDimension().booleanValue()) continue;
            measureIndexes.add(i);
            ++measureCount;
        }
        DataType[] type = new DataType[measureCount];
        for (int i = 0; i < type.length; ++i) {
            type[i] = this.dataFields[(Integer)measureIndexes.get(i)].getColumn().getDataType();
        }
        return type;
    }

    public CarbonColumn[] getNoDictAndComplexDimensions() {
        List visibleDimensions = this.tableSpec.getCarbonTable().getVisibleDimensions();
        ArrayList noDictionaryDimensions = new ArrayList();
        for (int i = 0; i < visibleDimensions.size(); ++i) {
            if (((CarbonDimension)visibleDimensions.get(i)).getDataType() == DataTypes.DATE) continue;
            noDictionaryDimensions.add(visibleDimensions.get(i));
        }
        return noDictionaryDimensions.toArray(new CarbonColumn[0]);
    }

    public boolean[] getSortColumnMapping() {
        boolean[] sortColumnMapping = new boolean[this.dataFields.length];
        for (int i = 0; i < sortColumnMapping.length; ++i) {
            if (!this.dataFields[i].getColumn().getColumnSchema().isSortColumn()) continue;
            sortColumnMapping[i] = true;
        }
        return sortColumnMapping;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public void setTableSpec(TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public short getWritingCoresCount() {
        return this.writingCoresCount;
    }

    public void setWritingCoresCount(short writingCoresCount) {
        this.writingCoresCount = writingCoresCount;
    }

    public String getDataWritePath() {
        return this.dataWritePath;
    }

    public void setDataWritePath(String dataWritePath) {
        this.dataWritePath = dataWritePath;
    }

    public SortColumnRangeInfo getSortColumnRangeInfo() {
        return this.sortColumnRangeInfo;
    }

    public void setSortColumnRangeInfo(SortColumnRangeInfo sortColumnRangeInfo) {
        this.sortColumnRangeInfo = sortColumnRangeInfo;
    }

    public boolean isCarbonTransactionalTable() {
        return this.carbonTransactionalTable;
    }

    public void setCarbonTransactionalTable(boolean carbonTransactionalTable) {
        this.carbonTransactionalTable = carbonTransactionalTable;
    }

    public int getComplexNonDictionaryColumnCount() {
        return this.complexNonDictionaryColumnCount;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }

    public int getNumberOfLoadingCores() {
        return this.numberOfLoadingCores;
    }

    public void setNumberOfLoadingCores(int numberOfLoadingCores) {
        this.numberOfLoadingCores = numberOfLoadingCores;
    }

    public String getSegmentPath() {
        return this.segmentPath;
    }

    public void setSegmentPath(String segmentPath) {
        this.segmentPath = segmentPath;
    }

    public DataLoadMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(DataLoadMetrics metrics) {
        this.metrics = metrics;
    }

    public String getBucketHashMethod() {
        return this.bucketHashMethod;
    }

    public void setBucketHashMethod(String bucketHashMethod) {
        this.bucketHashMethod = bucketHashMethod;
    }

    public boolean isNonSchemaColumnsPresent() {
        return this.nonSchemaColumnsPresent;
    }

    public void setNonSchemaColumnsPresent(boolean nonSchemaColumnsPresent) {
        this.nonSchemaColumnsPresent = nonSchemaColumnsPresent;
    }
}

