/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.DataLoadProcessBuilder;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.exception.NoRetryException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonBadRecordUtil;
import org.apache.log4j.Logger;

public class DataLoadExecutor {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DataLoadExecutor.class.getName());
    private AbstractDataLoadProcessorStep loadProcessorStep;
    private boolean isClosed;

    public void execute(CarbonLoadModel loadModel, String[] storeLocation, CarbonIterator<Object[]>[] inputIterators) {
        try {
            this.loadProcessorStep = new DataLoadProcessBuilder().build(loadModel, storeLocation, inputIterators);
            this.loadProcessorStep.initialize();
            LOGGER.info((Object)("Data Loading is started for table " + loadModel.getTableName()));
            this.loadProcessorStep.execute();
            if (CarbonBadRecordUtil.hasBadRecord(loadModel)) {
                LOGGER.error((Object)("Data Load is partially success for table " + loadModel.getTableName()));
            }
        }
        catch (CarbonDataLoadingException e) {
            if (e instanceof BadRecordFoundException) {
                throw new NoRetryException(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Data Loading failed for table " + loadModel.getTableName()), (Throwable)e);
            throw new CarbonDataLoadingException("Data Loading failed for table " + loadModel.getTableName(), e);
        }
    }

    public void close() {
        if (!this.isClosed && this.loadProcessorStep != null) {
            this.loadProcessorStep.close();
        }
        this.isClosed = true;
    }
}

