/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.SortScopeOptions;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.SortColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.steps.CarbonRowDataWriterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.DataConverterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.DataWriterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.InputProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.InputProcessorStepWithNoConverterImpl;
import org.apache.carbondata.processing.loading.steps.JsonInputProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.SortProcessorStepImpl;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class DataLoadProcessBuilder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DataLoadProcessBuilder.class.getName());

    public AbstractDataLoadProcessorStep build(CarbonLoadModel loadModel, String[] storeLocation, CarbonIterator[] inputIterators) {
        CarbonDataLoadConfiguration configuration = DataLoadProcessBuilder.createConfiguration(loadModel, storeLocation);
        SortScopeOptions.SortScope sortScope = CarbonDataProcessorUtil.getSortScope(configuration);
        if (configuration.getBucketingInfo() != null && CarbonProperties.isBadRecordHandlingEnabledForInsert().booleanValue()) {
            return this.buildInternalForBucketing(inputIterators, configuration);
        }
        if (loadModel.isLoadWithoutConverterStep()) {
            return this.buildInternalWithNoConverter(inputIterators, configuration, sortScope, false);
        }
        if (loadModel.isLoadWithoutConverterWithoutReArrangeStep()) {
            return this.buildInternalWithNoConverter(inputIterators, configuration, sortScope, true);
        }
        if (loadModel.isJsonFileLoad()) {
            return this.buildInternalWithJsonInputProcessor(inputIterators, configuration, sortScope);
        }
        if (configuration.getBucketingInfo() != null) {
            return this.buildInternalForBucketing(inputIterators, configuration);
        }
        if (!configuration.isSortTable() || sortScope.equals((Object)SortScopeOptions.SortScope.NO_SORT)) {
            return this.buildInternalForNoSort(inputIterators, configuration);
        }
        return this.buildInternal(inputIterators, configuration);
    }

    private AbstractDataLoadProcessorStep buildInternal(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
        return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalForNoSort(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        return new CarbonRowDataWriterProcessorStepImpl(configuration, converterProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalWithNoConverter(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration, SortScopeOptions.SortScope sortScope, boolean withoutReArrange) {
        InputProcessorStepWithNoConverterImpl inputProcessorStep = new InputProcessorStepWithNoConverterImpl(configuration, inputIterators, withoutReArrange);
        if (sortScope.equals((Object)SortScopeOptions.SortScope.LOCAL_SORT) || configuration.getBucketingInfo() != null) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, inputProcessorStep);
            return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
        }
        return new CarbonRowDataWriterProcessorStepImpl(configuration, inputProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalWithJsonInputProcessor(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration, SortScopeOptions.SortScope sortScope) {
        JsonInputProcessorStepImpl inputProcessorStep = new JsonInputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        if (sortScope.equals((Object)SortScopeOptions.SortScope.LOCAL_SORT)) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
            return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
        }
        return new CarbonRowDataWriterProcessorStepImpl(configuration, converterProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalForBucketing(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
        return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
    }

    public static CarbonDataLoadConfiguration createConfiguration(CarbonLoadModel loadModel, String[] storeLocation) {
        CarbonDataProcessorUtil.createLocations(storeLocation);
        String databaseName = loadModel.getDatabaseName();
        String tableName = loadModel.getTableName();
        String tempLocationKey = CarbonDataProcessorUtil.getTempStoreLocationKey(databaseName, tableName, loadModel.getSegmentId(), loadModel.getTaskNo(), false, false);
        CarbonProperties.getInstance().addProperty(tempLocationKey, StringUtils.join((Object[])storeLocation, (String)File.pathSeparator));
        return DataLoadProcessBuilder.createConfiguration(loadModel);
    }

    public static CarbonDataLoadConfiguration createConfiguration(CarbonLoadModel loadModel) {
        CarbonDataLoadConfiguration configuration = new CarbonDataLoadConfiguration();
        CarbonTable carbonTable = loadModel.getCarbonDataLoadSchema().getCarbonTable();
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        configuration.setTableIdentifier(identifier);
        configuration.setCarbonTransactionalTable(loadModel.isCarbonTransactionalTable());
        configuration.setSchemaUpdatedTimeStamp(carbonTable.getTableLastUpdatedTime());
        configuration.setHeader(loadModel.getCsvHeaderColumns());
        configuration.setSegmentId(loadModel.getSegmentId());
        configuration.setNonSchemaColumnsPresent(loadModel.isNonSchemaColumnsPresent());
        List<LoadMetadataDetails> loadMetadataDetails = loadModel.getLoadMetadataDetails();
        if (loadMetadataDetails != null) {
            for (LoadMetadataDetails detail : loadMetadataDetails) {
                if (!detail.getLoadName().equals(loadModel.getSegmentId()) || !StringUtils.isNotEmpty((CharSequence)detail.getPath())) continue;
                configuration.setSegmentPath(detail.getPath());
            }
        }
        configuration.setSkipParsers(loadModel.isSkipParsers());
        configuration.setTaskNo(loadModel.getTaskNo());
        configuration.setMetrics(loadModel.getMetrics());
        String[] complexDelimiters = new String[loadModel.getComplexDelimiters().size()];
        loadModel.getComplexDelimiters().toArray(complexDelimiters);
        configuration.setDataLoadProperty("COMPLEX_DELIMITERS", complexDelimiters);
        configuration.setDataLoadProperty("SERIALIZATION_NULL_FORMAT", loadModel.getSerializationNullFormat().split(",")[1]);
        configuration.setDataLoadProperty("FACT_TIME_STAMP", loadModel.getFactTimeStamp());
        configuration.setDataLoadProperty("BAD_RECORDS_LOGGER_ENABLE", loadModel.getBadRecordsLoggerEnable().split(",")[1]);
        configuration.setDataLoadProperty("BAD_RECORDS_LOGGER_ACTION", loadModel.getBadRecordsAction().split(",")[1]);
        configuration.setDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD", loadModel.getIsEmptyDataBadRecord().split(",")[1]);
        configuration.setDataLoadProperty("SKIP_EMPTY_LINE", loadModel.getSkipEmptyLine());
        configuration.setDataLoadProperty("FACT_FILE_PATH", loadModel.getFactFilePath());
        configuration.setDataLoadProperty("carbon.load.sort.scope", loadModel.getSortScope());
        configuration.setDataLoadProperty("carbon.load.global.sort.partitions", loadModel.getGlobalSortPartitions());
        configuration.setDataLoadProperty("carbon.options.bad.record.path", loadModel.getBadRecordsLocation());
        configuration.setDataLoadProperty("carbon.binary.decoder", loadModel.getBinaryDecoder());
        if (loadModel.isLoadWithoutConverterWithoutReArrangeStep()) {
            configuration.setDataLoadProperty("NO_REARRANGE_OF_ROWS", loadModel.isLoadWithoutConverterWithoutReArrangeStep());
        }
        List dimensions = carbonTable.getVisibleDimensions();
        List measures = carbonTable.getVisibleMeasures();
        List<DataField> dataFields = new ArrayList<DataField>();
        ArrayList<DataField> complexDataFields = new ArrayList<DataField>();
        ArrayList<DataField> partitionColumns = new ArrayList<DataField>();
        if (loadModel.isLoadWithoutConverterWithoutReArrangeStep()) {
            DataLoadProcessBuilder.getReArrangedDataFields(loadModel, carbonTable, dimensions, measures, complexDataFields, partitionColumns, dataFields);
        } else {
            DataLoadProcessBuilder.getDataFields(loadModel, dimensions, measures, complexDataFields, dataFields);
            dataFields = DataLoadProcessBuilder.updateDataFieldsBasedOnSortColumns(dataFields);
        }
        configuration.setDataFields(dataFields.toArray(new DataField[0]));
        configuration.setBucketingInfo(carbonTable.getBucketingInfo());
        configuration.setBucketHashMethod(carbonTable.getBucketHashMethod());
        configuration.setPreFetch(loadModel.isPreFetch());
        configuration.setNumberOfSortColumns(carbonTable.getNumberOfSortColumns());
        configuration.setNumberOfNoDictSortColumns(carbonTable.getNumberOfNoDictSortColumns());
        configuration.setDataWritePath(loadModel.getDataWritePath());
        DataLoadProcessBuilder.setSortColumnInfo(carbonTable, loadModel, configuration);
        if (carbonTable.isHivePartitionTable()) {
            configuration.setWritingCoresCount((short)1);
        }
        TableSpec tableSpec = new TableSpec(carbonTable, false);
        configuration.setTableSpec(tableSpec);
        if (loadModel.getSdkWriterCores() > 0) {
            configuration.setWritingCoresCount(loadModel.getSdkWriterCores());
        }
        configuration.setNumberOfLoadingCores(CarbonProperties.getInstance().getNumberOfLoadingCores());
        configuration.setColumnCompressor(loadModel.getColumnCompressor());
        return configuration;
    }

    private static void getDataFields(CarbonLoadModel loadModel, List<CarbonDimension> dimensions, List<CarbonMeasure> measures, List<DataField> complexDataFields, List<DataField> dataFields) {
        for (CarbonColumn carbonColumn : dimensions) {
            DataField dataField = new DataField(carbonColumn);
            if (carbonColumn.getDataType() == DataTypes.DATE) {
                dataField.setDateFormat(loadModel.getDateFormat());
                carbonColumn.setDateFormat(loadModel.getDateFormat());
            } else if (carbonColumn.getDataType() == DataTypes.TIMESTAMP) {
                dataField.setTimestampFormat(loadModel.getTimestampFormat());
                carbonColumn.setTimestampFormat(loadModel.getTimestampFormat());
            }
            if (carbonColumn.isComplex().booleanValue()) {
                complexDataFields.add(dataField);
                List childDimensions = ((CarbonDimension)dataField.getColumn()).getListOfChildDimensions();
                for (CarbonDimension childDimension : childDimensions) {
                    if (childDimension.getDataType() == DataTypes.DATE) {
                        childDimension.setDateFormat(loadModel.getDateFormat());
                        continue;
                    }
                    if (childDimension.getDataType() != DataTypes.TIMESTAMP) continue;
                    childDimension.setTimestampFormat(loadModel.getTimestampFormat());
                }
                continue;
            }
            dataFields.add(dataField);
        }
        dataFields.addAll(complexDataFields);
        for (CarbonColumn carbonColumn : measures) {
            if (carbonColumn.getColName().equals("default_dummy_measure")) continue;
            dataFields.add(new DataField(carbonColumn));
        }
    }

    private static void getReArrangedDataFields(CarbonLoadModel loadModel, CarbonTable carbonTable, List<CarbonDimension> dimensions, List<CarbonMeasure> measures, List<DataField> complexDataFields, List<DataField> partitionColumns, List<DataField> dataFields) {
        ArrayList partitionColumnSchemaList = carbonTable.getPartitionInfo() != null ? carbonTable.getPartitionInfo().getColumnSchemaList() : new ArrayList();
        ArrayList<DataField> sortDataFields = new ArrayList<DataField>();
        ArrayList<DataField> noSortDataFields = new ArrayList<DataField>();
        for (CarbonColumn carbonColumn : dimensions) {
            DataField dataField = new DataField(carbonColumn);
            if (carbonColumn.isComplex().booleanValue()) {
                List childDimensions = ((CarbonDimension)dataField.getColumn()).getListOfChildDimensions();
                for (CarbonDimension childDimension : childDimensions) {
                    if (childDimension.getDataType() == DataTypes.DATE) {
                        childDimension.setDateFormat(loadModel.getDateFormat());
                        continue;
                    }
                    if (childDimension.getDataType() != DataTypes.TIMESTAMP) continue;
                    childDimension.setTimestampFormat(loadModel.getTimestampFormat());
                }
                if (partitionColumnSchemaList.size() != 0 && partitionColumnSchemaList.contains(carbonColumn.getColumnSchema())) {
                    partitionColumns.add(dataField);
                    continue;
                }
                complexDataFields.add(dataField);
                continue;
            }
            if (carbonColumn.getDataType() == DataTypes.DATE) {
                dataField.setDateFormat(loadModel.getDateFormat());
                carbonColumn.setDateFormat(loadModel.getDateFormat());
            } else if (carbonColumn.getDataType() == DataTypes.TIMESTAMP) {
                dataField.setTimestampFormat(loadModel.getTimestampFormat());
                carbonColumn.setTimestampFormat(loadModel.getTimestampFormat());
            }
            if (partitionColumnSchemaList.size() != 0 && partitionColumnSchemaList.contains(carbonColumn.getColumnSchema())) {
                partitionColumns.add(dataField);
                continue;
            }
            if (dataField.getColumn().getColumnSchema().isSortColumn()) {
                sortDataFields.add(dataField);
                continue;
            }
            noSortDataFields.add(dataField);
        }
        if (sortDataFields.size() != 0) {
            dataFields.addAll(sortDataFields);
        }
        if (noSortDataFields.size() != 0) {
            dataFields.addAll(noSortDataFields);
        }
        if (complexDataFields.size() != 0) {
            dataFields.addAll(complexDataFields);
        }
        for (CarbonColumn carbonColumn : measures) {
            if (partitionColumnSchemaList.size() != 0 && partitionColumnSchemaList.contains(carbonColumn.getColumnSchema())) {
                partitionColumns.add(new DataField(carbonColumn));
                continue;
            }
            if (carbonColumn.getColName().equals("default_dummy_measure")) continue;
            dataFields.add(new DataField(carbonColumn));
        }
        if (partitionColumns.size() != 0) {
            ArrayList<DataField> reArrangedPartitionColumns = new ArrayList<DataField>();
            block3: for (ColumnSchema col : partitionColumnSchemaList) {
                for (DataField field : partitionColumns) {
                    if (!field.getColumn().getColumnSchema().equals((Object)col)) continue;
                    reArrangedPartitionColumns.add(field);
                    continue block3;
                }
            }
            dataFields.addAll(reArrangedPartitionColumns);
        }
    }

    private static void setSortColumnInfo(CarbonTable carbonTable, CarbonLoadModel loadModel, CarbonDataLoadConfiguration configuration) {
        String[] sortColumnBounds;
        List sortCols = carbonTable.getSortColumns();
        SortScopeOptions.SortScope sortScope = SortScopeOptions.getSortScope((String)loadModel.getSortScope());
        if (!SortScopeOptions.SortScope.LOCAL_SORT.equals((Object)sortScope) || sortCols.size() == 0 || StringUtils.isBlank((CharSequence)loadModel.getSortColumnsBoundsStr())) {
            if (!StringUtils.isBlank((CharSequence)loadModel.getSortColumnsBoundsStr())) {
                LOGGER.warn((Object)"sort column bounds will be ignored");
            }
            configuration.setSortColumnRangeInfo(null);
            return;
        }
        int[] sortColIndex = new int[sortCols.size()];
        boolean[] isSortColNoDict = new boolean[sortCols.size()];
        DataField[] outFields = configuration.getDataFields();
        int j = 0;
        for (String[] sortCol : sortCols) {
            boolean columnExist = false;
            for (int i = 0; !columnExist && i < outFields.length; ++i) {
                if (!outFields[i].getColumn().getColName().equalsIgnoreCase((String)sortCol)) continue;
                columnExist = true;
                sortColIndex[j] = i;
                isSortColNoDict[j] = !outFields[i].isDateDataType();
                ++j;
            }
            if (columnExist) continue;
            throw new CarbonDataLoadingException("Field " + (String)sortCol + " does not exist.");
        }
        for (String bound : sortColumnBounds = StringUtils.splitPreserveAllTokens((String)loadModel.getSortColumnsBoundsStr(), (String)";", (int)-1)) {
            String[] fieldInBounds = StringUtils.splitPreserveAllTokens((String)bound, (String)",", (int)-1);
            if (fieldInBounds.length == sortCols.size()) continue;
            String msg = "The number of field in bounds should be equal to that in sort columns." + " Expected " + sortCols.size() + ", actual " + String.valueOf(fieldInBounds.length) + "." + " The illegal bound is '" + bound + "'.";
            throw new CarbonDataLoadingException(msg);
        }
        SortColumnRangeInfo sortColumnRangeInfo = new SortColumnRangeInfo(sortColIndex, isSortColNoDict, sortColumnBounds, ",");
        configuration.setSortColumnRangeInfo(sortColumnRangeInfo);
    }

    private static List<DataField> updateDataFieldsBasedOnSortColumns(List<DataField> dataFields) {
        ArrayList<DataField> updatedDataFields = new ArrayList<DataField>();
        ArrayList<DataField> sortFields = new ArrayList<DataField>();
        ArrayList<DataField> nonSortFields = new ArrayList<DataField>();
        for (DataField dataField : dataFields) {
            if (dataField.getColumn().getColumnSchema().isSortColumn()) {
                sortFields.add(dataField);
                continue;
            }
            nonSortFields.add(dataField);
        }
        updatedDataFields.addAll(sortFields);
        updatedDataFields.addAll(nonSortFields);
        return updatedDataFields;
    }
}

