/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.impl.binary.BinaryDecoder;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.log4j.Logger;

public class BinaryFieldConverterImpl
implements FieldConverter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BinaryFieldConverterImpl.class.getName());
    private int index;
    private DataType dataType;
    private CarbonDimension dimension;
    private String nullformat;
    private boolean isEmptyBadRecord;
    private DataField dataField;
    private BinaryDecoder binaryDecoder;

    public BinaryFieldConverterImpl(DataField dataField, String nullformat, int index, boolean isEmptyBadRecord, BinaryDecoder binaryDecoder) {
        this.dataType = dataField.getColumn().getDataType();
        this.dimension = (CarbonDimension)dataField.getColumn();
        this.nullformat = nullformat;
        this.index = index;
        this.isEmptyBadRecord = isEmptyBadRecord;
        this.dataField = dataField;
        this.binaryDecoder = binaryDecoder;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) throws CarbonDataLoadingException {
        row.update(this.convert(row.getObject(this.index), logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        if (value instanceof String) {
            return this.binaryDecoder.decode((String)value);
        }
        if (value instanceof byte[]) {
            return value;
        }
        throw new CarbonDataLoadingException("Binary only support String and byte[] data type, binary decoder only support Base64, Hex or no decode for string");
    }

    @Override
    public DataField getDataField() {
        return this.dataField;
    }

    @Override
    public void clear() {
    }
}

