/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.ArrayDataType;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.datatypes.PrimitiveDataType;
import org.apache.carbondata.processing.datatypes.StructDataType;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.impl.BinaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.ComplexFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.DirectDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.MeasureFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.NonDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.SpatialIndexFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.binary.Base64BinaryDecoder;
import org.apache.carbondata.processing.loading.converter.impl.binary.BinaryDecoder;
import org.apache.carbondata.processing.loading.converter.impl.binary.DefaultBinaryDecoder;
import org.apache.carbondata.processing.loading.converter.impl.binary.HexBinaryDecoder;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.commons.lang3.StringUtils;

public class FieldEncoderFactory {
    private static FieldEncoderFactory instance;

    private FieldEncoderFactory() {
    }

    public static FieldEncoderFactory getInstance() {
        if (instance == null) {
            instance = new FieldEncoderFactory();
        }
        return instance;
    }

    public FieldConverter createFieldEncoder(DataField dataField, int index, String nullFormat, boolean isEmptyBadRecord, boolean isConvertToBinary, String binaryDecoder, CarbonDataLoadConfiguration configuration) {
        if (dataField.getColumn().isDimension().booleanValue()) {
            if (dataField.getColumn().isSpatialColumn()) {
                return new SpatialIndexFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord, configuration);
            }
            if (dataField.getColumn().getDataType() == DataTypes.DATE && !dataField.getColumn().isComplex().booleanValue()) {
                return new DirectDictionaryFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
            }
            if (dataField.getColumn().isComplex().booleanValue()) {
                return new ComplexFieldConverterImpl(dataField, FieldEncoderFactory.createComplexDataType(dataField, nullFormat, this.getBinaryDecoder(binaryDecoder)), index);
            }
            if (dataField.getColumn().getDataType() == DataTypes.BINARY) {
                BinaryDecoder binaryDecoderObject = this.getBinaryDecoder(binaryDecoder);
                return new BinaryFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord, binaryDecoderObject);
            }
            if (DataTypeUtil.isPrimitiveColumn((DataType)dataField.getColumn().getDataType()) && !isConvertToBinary) {
                return new MeasureFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
            }
            return new NonDictionaryFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
        }
        return new MeasureFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
    }

    private BinaryDecoder getBinaryDecoder(String binaryDecoder) {
        BinaryDecoder binaryDecoderObject;
        if (binaryDecoder == null) {
            return null;
        }
        if (binaryDecoder.equalsIgnoreCase("base64")) {
            binaryDecoderObject = new Base64BinaryDecoder();
        } else if (binaryDecoder.equalsIgnoreCase("hex")) {
            binaryDecoderObject = new HexBinaryDecoder();
        } else {
            if (!StringUtils.isBlank((CharSequence)binaryDecoder)) {
                throw new CarbonDataLoadingException("Binary decoder only support Base64, Hex or no decode for string, don't support " + binaryDecoder);
            }
            binaryDecoderObject = new DefaultBinaryDecoder();
        }
        return binaryDecoderObject;
    }

    public static GenericDataType createComplexDataType(DataField dataField, String nullFormat, BinaryDecoder binaryDecoder) {
        return FieldEncoderFactory.createComplexType(dataField.getColumn(), dataField.getColumn().getColName(), nullFormat, binaryDecoder);
    }

    private static GenericDataType createComplexType(CarbonColumn carbonColumn, String parentName, String nullFormat, BinaryDecoder binaryDecoder) {
        DataType dataType = carbonColumn.getDataType();
        if (DataTypes.isArrayType((DataType)dataType) || DataTypes.isMapType((DataType)dataType)) {
            List listOfChildDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            ArrayDataType arrayDataType = new ArrayDataType(carbonColumn.getColName(), parentName, carbonColumn.getColumnId(), carbonColumn.getDataType() == DataTypes.DATE);
            for (CarbonDimension dimension : listOfChildDimensions) {
                arrayDataType.addChildren(FieldEncoderFactory.createComplexType((CarbonColumn)dimension, carbonColumn.getColName(), nullFormat, binaryDecoder));
            }
            return arrayDataType;
        }
        if (DataTypes.isStructType((DataType)dataType)) {
            List dimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            StructDataType structDataType = new StructDataType(carbonColumn.getColName(), parentName, carbonColumn.getColumnId(), carbonColumn.getDataType() == DataTypes.DATE);
            for (CarbonDimension dimension : dimensions) {
                structDataType.addChildren(FieldEncoderFactory.createComplexType((CarbonColumn)dimension, carbonColumn.getColName(), nullFormat, binaryDecoder));
            }
            return structDataType;
        }
        return new PrimitiveDataType(carbonColumn, parentName, carbonColumn.getColumnId(), (CarbonDimension)carbonColumn, nullFormat, binaryDecoder);
    }
}

