/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.util.ArrayList;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.RowConverter;
import org.apache.carbondata.processing.loading.converter.impl.FieldEncoderFactory;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.log4j.Logger;

public class RowConverterImpl
implements RowConverter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)RowConverterImpl.class.getName());
    private CarbonDataLoadConfiguration configuration;
    private DataField[] fields;
    private FieldConverter[] fieldConverters;
    private BadRecordsLogger badRecordLogger;
    private BadRecordLogHolder logHolder;
    private boolean isConvertToBinary;

    public RowConverterImpl(DataField[] fields, CarbonDataLoadConfiguration configuration, BadRecordsLogger badRecordLogger) {
        this.fields = fields;
        this.configuration = configuration;
        this.badRecordLogger = badRecordLogger;
    }

    public RowConverterImpl(DataField[] fields, CarbonDataLoadConfiguration configuration, BadRecordsLogger badRecordLogger, boolean isConvertToBinary) {
        this.fields = fields;
        this.configuration = configuration;
        this.badRecordLogger = badRecordLogger;
        this.isConvertToBinary = isConvertToBinary;
    }

    @Override
    public void initialize() {
        String nullFormat = this.configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        boolean isEmptyBadRecord = Boolean.parseBoolean(this.configuration.getDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD").toString());
        ArrayList<FieldConverter> fieldConverterList = new ArrayList<FieldConverter>();
        ArrayList<FieldConverter> nonSchemaFieldConverterList = new ArrayList<FieldConverter>();
        long lruCacheStartTime = System.currentTimeMillis();
        for (int i = 0; i < this.fields.length; ++i) {
            FieldConverter fieldConverter = FieldEncoderFactory.getInstance().createFieldEncoder(this.fields[i], i, nullFormat, isEmptyBadRecord, this.isConvertToBinary, (String)this.configuration.getDataLoadProperty("carbon.binary.decoder"), this.configuration);
            if (this.fields[i].getColumn().isSpatialColumn()) {
                nonSchemaFieldConverterList.add(fieldConverter);
                continue;
            }
            fieldConverterList.add(fieldConverter);
        }
        fieldConverterList.addAll(nonSchemaFieldConverterList);
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordLruCacheLoadTime((double)(System.currentTimeMillis() - lruCacheStartTime) / 1000.0);
        this.fieldConverters = fieldConverterList.toArray(new FieldConverter[0]);
        this.logHolder = new BadRecordLogHolder();
    }

    @Override
    public CarbonRow convert(CarbonRow row) throws CarbonDataLoadingException {
        this.logHolder.setLogged(false);
        this.logHolder.clear();
        for (int i = 0; i < this.fieldConverters.length; ++i) {
            if (this.configuration.isNonSchemaColumnsPresent() && !this.fieldConverters[i].getDataField().getColumn().isSpatialColumn()) continue;
            this.fieldConverters[i].convert(row, this.logHolder);
            if (this.logHolder.isLogged() || !this.logHolder.isBadRecordNotAdded()) continue;
            this.badRecordLogger.addBadRecordsToBuilder(row.getRawData(), this.logHolder.getReason());
            if (this.badRecordLogger.isDataLoadFail()) {
                String error = "Data load failed due to bad record: " + this.logHolder.getReason();
                if (!this.badRecordLogger.isBadRecordLoggerEnable()) {
                    error = error + "Please enable bad record logger to know the detail reason.";
                }
                throw new BadRecordFoundException(error);
            }
            this.logHolder.clear();
            this.logHolder.setLogged(true);
            if (!this.badRecordLogger.isBadRecordConvertNullDisable()) continue;
            return null;
        }
        row.setRawData(null);
        return row;
    }

    @Override
    public void finish() {
        for (int i = 0; i < this.fieldConverters.length; ++i) {
            this.fieldConverters[i].clear();
        }
    }

    @Override
    public RowConverter createCopyForNewThread() {
        RowConverterImpl converter = new RowConverterImpl(this.fields, this.configuration, this.badRecordLogger, this.isConvertToBinary);
        ArrayList<FieldConverter> fieldConverterList = new ArrayList<FieldConverter>();
        ArrayList<FieldConverter> nonSchemaFieldConverterList = new ArrayList<FieldConverter>();
        String nullFormat = this.configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        boolean isEmptyBadRecord = Boolean.parseBoolean(this.configuration.getDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD").toString());
        for (int i = 0; i < this.fields.length; ++i) {
            FieldConverter fieldConverter = FieldEncoderFactory.getInstance().createFieldEncoder(this.fields[i], i, nullFormat, isEmptyBadRecord, this.isConvertToBinary, (String)this.configuration.getDataLoadProperty("carbon.binary.decoder"), this.configuration);
            if (this.fields[i].getColumn().isSpatialColumn()) {
                nonSchemaFieldConverterList.add(fieldConverter);
                continue;
            }
            fieldConverterList.add(fieldConverter);
        }
        fieldConverterList.addAll(nonSchemaFieldConverterList);
        converter.fieldConverters = fieldConverterList.toArray(new FieldConverter[0]);
        converter.logHolder = new BadRecordLogHolder();
        return converter;
    }

    @Override
    public FieldConverter[] getFieldConverters() {
        return this.fieldConverters;
    }
}

