/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.jsoninput;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class JsonStreamReader
extends BufferedReader {
    private StringBuilder bldr = new StringBuilder();
    private String identifier = null;
    private long bytesRead = 0L;

    public JsonStreamReader(String identifier, InputStream strm) {
        super(new InputStreamReader(strm, Charset.defaultCharset()));
        this.identifier = identifier;
    }

    public String getJsonRecord() throws IOException {
        this.bldr.delete(0, this.bldr.length());
        boolean foundRecord = false;
        int c = 0;
        int numBraces = 1;
        while ((c = super.read()) != -1) {
            ++this.bytesRead;
            if (!foundRecord) {
                this.bldr.append((char)c);
                if (!this.bldr.toString().contains(this.identifier)) continue;
                this.forwardToBrace();
                foundRecord = true;
                this.bldr.delete(0, this.bldr.length());
                this.bldr.append('{');
                continue;
            }
            this.bldr.append((char)c);
            if (c == 123) {
                ++numBraces;
            } else if (c == 125) {
                --numBraces;
            }
            if (numBraces != 0) continue;
        }
        if (foundRecord) {
            return this.bldr.toString();
        }
        return null;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    private void forwardToBrace() throws IOException {
        while (super.read() != 123) {
        }
    }
}

