/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.model;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.Maps;
import org.apache.carbondata.common.Strings;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.model.LoadOption;
import org.apache.carbondata.processing.util.CarbonBadRecordUtil;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.carbondata.processing.util.TableOptionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class CarbonLoadModelBuilder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLoadModelBuilder.class.getName());
    private CarbonTable table;

    public CarbonLoadModelBuilder(CarbonTable table) {
        this.table = table;
    }

    public CarbonLoadModel build(Map<String, String> options, long timestamp, String taskNo) throws InvalidLoadOptionException, IOException {
        String dateFormat;
        Map<String, String> optionsFinal = LoadOption.fillOptionWithDefaultValue(options);
        if (!options.containsKey("fileheader")) {
            List csvHeader = this.table.getCreateOrderColumn();
            String[] columns = new String[csvHeader.size()];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = ((CarbonColumn)csvHeader.get(i)).getColName();
            }
            optionsFinal.put("fileheader", Strings.mkString((String[])columns, (String)","));
        } else {
            optionsFinal.put("fileheader", options.get("fileheader"));
        }
        optionsFinal.put("bad_record_path", CarbonBadRecordUtil.getBadRecordsPath(options, this.table));
        optionsFinal.put("sort_scope", (String)Maps.getOrDefault(options, (Object)"sort_scope", (Object)"NO_SORT"));
        CarbonLoadModel model = new CarbonLoadModel();
        model.setCarbonTransactionalTable(this.table.isTransactionalTable());
        model.setFactTimeStamp(timestamp);
        model.setTaskNo(taskNo);
        this.build(options, optionsFinal, model, null);
        String timestampFormat = options.get("timestampformat");
        if (timestampFormat == null) {
            timestampFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        }
        if ((dateFormat = options.get("dateFormat")) == null) {
            dateFormat = CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd");
        }
        model.setDateFormat(dateFormat);
        model.setTimestampFormat(timestampFormat);
        this.validateAndSetColumnCompressor(model);
        this.validateAndSetBinaryDecoder(model);
        return model;
    }

    public void build(Map<String, String> options, Map<String, String> optionsFinal, CarbonLoadModel carbonLoadModel, Configuration hadoopConf) throws InvalidLoadOptionException, IOException {
        this.build(options, optionsFinal, carbonLoadModel, hadoopConf, new HashMap<String, String>(), false);
    }

    /*
     * WARNING - void declaration
     */
    public void build(Map<String, String> options, Map<String, String> optionsFinal, CarbonLoadModel carbonLoadModel, Configuration hadoopConf, Map<String, String> partitions, boolean isDataFrame) throws InvalidLoadOptionException, IOException {
        carbonLoadModel.setTableName(this.table.getTableName());
        carbonLoadModel.setDatabaseName(this.table.getDatabaseName());
        carbonLoadModel.setTablePath(this.table.getTablePath());
        carbonLoadModel.setTableName(this.table.getTableName());
        carbonLoadModel.setCarbonTransactionalTable(this.table.isTransactionalTable());
        CarbonDataLoadSchema dataLoadSchema = new CarbonDataLoadSchema(this.table);
        carbonLoadModel.setCarbonDataLoadSchema(dataLoadSchema);
        String sort_scope = optionsFinal.get("sort_scope");
        String bad_records_logger_enable = optionsFinal.get("bad_records_logger_enable");
        String bad_records_action = optionsFinal.get("bad_records_action");
        String bad_record_path = optionsFinal.get("bad_record_path");
        String global_sort_partitions = optionsFinal.get("global_sort_partitions");
        String timestampformat = optionsFinal.get("timestampformat");
        String dateFormat = optionsFinal.get("dateformat");
        String delimiter = optionsFinal.get("delimiter");
        String complex_delimiter_level1 = optionsFinal.get("complex_delimiter_level_1");
        String complex_delimiter_level2 = optionsFinal.get("complex_delimiter_level_2");
        String complex_delimiter_level3 = optionsFinal.get("complex_delimiter_level_3");
        String complex_delimiter_level4 = optionsFinal.get("complex_delimiter_level_4");
        this.validateDateTimeFormat(timestampformat, "TimestampFormat");
        this.validateDateTimeFormat(dateFormat, "DateFormat");
        if (Boolean.parseBoolean(bad_records_logger_enable) || LoggerAction.REDIRECT.name().equalsIgnoreCase(bad_records_action)) {
            if (!StringUtils.isEmpty((String)bad_record_path)) {
                bad_record_path = CarbonUtil.checkAndAppendHDFSUrl((String)bad_record_path);
            } else {
                throw new InvalidLoadOptionException("Cannot redirect bad records as bad record location is not provided.");
            }
        }
        carbonLoadModel.setBadRecordsLocation(bad_record_path);
        this.validateGlobalSortPartitions(global_sort_partitions);
        carbonLoadModel.setEscapeChar(this.checkDefaultValue(optionsFinal.get("escapechar"), "\\"));
        carbonLoadModel.setQuoteChar(this.checkDefaultValue(optionsFinal.get("quotechar"), "\""));
        carbonLoadModel.setCommentChar(this.checkDefaultValue(optionsFinal.get("commentchar"), "#"));
        String lineSeparator = CarbonUtil.unescapeChar((String)options.get("line_separator"));
        if (lineSeparator != null) {
            carbonLoadModel.setLineSeparator(lineSeparator);
        }
        String fileHeader = optionsFinal.get("fileheader");
        String headerOption = optionsFinal.get("header");
        if (StringUtils.isNotEmpty((String)headerOption)) {
            if (!headerOption.equalsIgnoreCase("true") && !headerOption.equalsIgnoreCase("false")) {
                throw new InvalidLoadOptionException("'header' option should be either 'true' or 'false'.");
            }
            if (Boolean.valueOf(headerOption).booleanValue()) {
                if (!StringUtils.isEmpty((String)fileHeader)) {
                    throw new InvalidLoadOptionException("When 'header' option is true, 'fileheader' option is not required.");
                }
            } else if (StringUtils.isEmpty((String)fileHeader)) {
                void var26_28;
                List columns = this.table.getCreateOrderColumn();
                ArrayList<String> columnNames = new ArrayList<String>();
                ArrayList partitionColumns = new ArrayList();
                boolean bl = false;
                while (var26_28 < columns.size()) {
                    columnNames.add(((CarbonColumn)columns.get((int)var26_28)).getColName());
                    ++var26_28;
                }
                columnNames.addAll(partitionColumns);
                fileHeader = Strings.mkString((String[])columnNames.toArray(new String[columnNames.size()]), (String)",");
            }
        }
        String binaryDecoder = options.get("binary_decoder");
        carbonLoadModel.setBinaryDecoder(binaryDecoder);
        carbonLoadModel.setTimestampFormat(timestampformat);
        carbonLoadModel.setDateFormat(dateFormat);
        carbonLoadModel.setDefaultTimestampFormat(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss"));
        carbonLoadModel.setDefaultDateFormat(CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd"));
        carbonLoadModel.setSerializationNullFormat(TableOptionConstant.SERIALIZATION_NULL_FORMAT.getName() + "," + optionsFinal.get("serialization_null_format"));
        carbonLoadModel.setBadRecordsLoggerEnable(TableOptionConstant.BAD_RECORDS_LOGGER_ENABLE.getName() + "," + bad_records_logger_enable);
        carbonLoadModel.setBadRecordsAction(TableOptionConstant.BAD_RECORDS_ACTION.getName() + "," + bad_records_action.toUpperCase());
        carbonLoadModel.setIsEmptyDataBadRecord("IS_EMPTY_DATA_BAD_RECORD," + optionsFinal.get("is_empty_data_bad_record"));
        carbonLoadModel.setSkipEmptyLine(optionsFinal.get("skip_empty_line"));
        carbonLoadModel.setSortScope(sort_scope);
        if (global_sort_partitions == null) {
            global_sort_partitions = this.table.getGlobalSortPartitions();
        }
        carbonLoadModel.setGlobalSortPartitions(global_sort_partitions);
        if (delimiter.equalsIgnoreCase(complex_delimiter_level1) || complex_delimiter_level1.equalsIgnoreCase(complex_delimiter_level2) || delimiter.equalsIgnoreCase(complex_delimiter_level2) || delimiter.equalsIgnoreCase(complex_delimiter_level3)) {
            throw new InvalidLoadOptionException("Field Delimiter and Complex types delimiter are same");
        }
        carbonLoadModel.setComplexDelimiter(complex_delimiter_level1);
        carbonLoadModel.setComplexDelimiter(complex_delimiter_level2);
        carbonLoadModel.setComplexDelimiter(complex_delimiter_level3);
        carbonLoadModel.setComplexDelimiter(complex_delimiter_level4);
        carbonLoadModel.setCsvDelimiter(CarbonUtil.unescapeChar((String)delimiter));
        carbonLoadModel.setCsvHeader(fileHeader);
        ArrayList<String> ignoreColumns = new ArrayList<String>();
        if (!isDataFrame) {
            for (Map.Entry entry : partitions.entrySet()) {
                if (entry.getValue() == null) continue;
                ignoreColumns.add((String)entry.getKey());
            }
        }
        carbonLoadModel.setCsvHeaderColumns(LoadOption.getCsvHeaderColumns(carbonLoadModel, hadoopConf, ignoreColumns));
        int validatedMaxColumns = this.validateMaxColumns(carbonLoadModel.getCsvHeaderColumns(), optionsFinal.get("maxcolumns"));
        carbonLoadModel.setMaxColumns(String.valueOf(validatedMaxColumns));
        if (carbonLoadModel.isCarbonTransactionalTable()) {
            carbonLoadModel.readAndSetLoadMetadataDetails();
        }
        carbonLoadModel.setSortColumnsBoundsStr(optionsFinal.get("sort_column_bounds"));
        carbonLoadModel.setLoadMinSize(optionsFinal.get("load_min_size_inmb"));
        this.validateAndSetLoadMinSize(carbonLoadModel);
        this.validateAndSetColumnCompressor(carbonLoadModel);
        this.validateAndSetBinaryDecoder(carbonLoadModel);
        this.validateRangeColumn(optionsFinal, carbonLoadModel);
        carbonLoadModel.setMetrics(new DataLoadMetrics());
    }

    private void validateRangeColumn(Map<String, String> optionsFinal, CarbonLoadModel carbonLoadModel) throws InvalidLoadOptionException {
        String scaleFactor = optionsFinal.get("scale_factor");
        if (scaleFactor != null) {
            try {
                int scale = Integer.parseInt(scaleFactor);
                if (scale < 1 || scale > 300) {
                    throw new InvalidLoadOptionException("Invalid scale_factor option, the range of scale_factor should be [1, 300]");
                }
                carbonLoadModel.setScaleFactor(scale);
            }
            catch (NumberFormatException ex) {
                throw new InvalidLoadOptionException("Invalid scale_factor option, scale_factor should be a integer");
            }
        }
    }

    private int validateMaxColumns(String[] csvHeaders, String maxColumns) throws InvalidLoadOptionException {
        int columnCountInSchema = csvHeaders.length;
        int maxNumberOfColumnsForParsing = 0;
        Integer maxColumnsInt = this.getMaxColumnValue(maxColumns);
        if (maxColumnsInt != null) {
            if (columnCountInSchema >= maxColumnsInt) {
                throw new InvalidLoadOptionException("csv headers should be less than the max columns " + maxColumnsInt);
            }
            if (maxColumnsInt > 20000) {
                throw new InvalidLoadOptionException("max columns cannot be greater than the threshold value: 20000");
            }
            maxNumberOfColumnsForParsing = maxColumnsInt;
        } else {
            if (columnCountInSchema >= 20000) {
                throw new InvalidLoadOptionException("csv header columns should be less than max threashold: 20000");
            }
            maxNumberOfColumnsForParsing = columnCountInSchema >= 2000 ? columnCountInSchema + 1 : 2000;
        }
        return maxNumberOfColumnsForParsing;
    }

    private Integer getMaxColumnValue(String maxColumn) {
        return maxColumn == null ? null : Integer.valueOf(Integer.parseInt(maxColumn));
    }

    private void validateDateTimeFormat(String dateTimeLoadFormat, String dateTimeLoadOption) throws InvalidLoadOptionException {
        if (dateTimeLoadFormat != null && !dateTimeLoadFormat.trim().equalsIgnoreCase("")) {
            try {
                new SimpleDateFormat(dateTimeLoadFormat);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidLoadOptionException("Error: Wrong option: " + dateTimeLoadFormat + " is provided for option " + dateTimeLoadOption);
            }
        }
    }

    private void validateGlobalSortPartitions(String globalSortPartitions) throws InvalidLoadOptionException {
        if (globalSortPartitions != null) {
            try {
                int num = Integer.parseInt(globalSortPartitions);
                if (num <= 0) {
                    throw new InvalidLoadOptionException("'GLOBAL_SORT_PARTITIONS' should be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidLoadOptionException(e.getMessage());
            }
        }
    }

    private void validateAndSetColumnCompressor(CarbonLoadModel carbonLoadModel) throws InvalidLoadOptionException {
        try {
            String columnCompressor = carbonLoadModel.getColumnCompressor();
            if (StringUtils.isBlank((String)columnCompressor)) {
                columnCompressor = CarbonProperties.getInstance().getProperty("carbon.column.compressor", "snappy");
            }
            CompressorFactory.getInstance().getCompressor(columnCompressor);
            carbonLoadModel.setColumnCompressor(columnCompressor);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new InvalidLoadOptionException("Failed to load the compressor");
        }
    }

    private void validateAndSetBinaryDecoder(CarbonLoadModel carbonLoadModel) {
        String binaryDecoder = carbonLoadModel.getBinaryDecoder();
        if (!CarbonLoaderUtil.isValidBinaryDecoder(binaryDecoder)) {
            throw new CarbonDataLoadingException("Binary decoder only support Base64, Hex or no decode for string, don't support " + binaryDecoder);
        }
        if (StringUtils.isBlank((String)binaryDecoder)) {
            binaryDecoder = CarbonProperties.getInstance().getProperty("carbon.binary.decoder", "");
        }
        carbonLoadModel.setBinaryDecoder(binaryDecoder);
    }

    private String checkDefaultValue(String value, String defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private void validateAndSetLoadMinSize(CarbonLoadModel carbonLoadModel) {
        int size = 0;
        String loadMinSize = carbonLoadModel.getLoadMinSize();
        try {
            size = Integer.parseInt(loadMinSize);
        }
        catch (Exception e) {
            size = 0;
        }
        if (size > 0) {
            carbonLoadModel.setLoadMinSize(loadMinSize);
        } else {
            carbonLoadModel.setLoadMinSize("0");
        }
    }
}

