/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.complexobjects.StructObject;
import org.apache.carbondata.processing.loading.parser.RowParser;
import org.apache.htrace.fasterxml.jackson.core.type.TypeReference;
import org.apache.htrace.fasterxml.jackson.databind.ObjectMapper;

public class JsonRowParser
implements RowParser {
    private DataField[] dataFields;

    public JsonRowParser(DataField[] dataFields) {
        this.dataFields = dataFields;
    }

    @Override
    public Object[] parseRow(Object[] row) {
        try {
            return this.convertJsonToNoDictionaryToBytes((String)row[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] convertJsonToNoDictionaryToBytes(String jsonString) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map jsonNodeMap = (Map)objectMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (jsonNodeMap == null) {
                return null;
            }
            TreeMap<String, Object> jsonNodeMapCaseInsensitive = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            jsonNodeMapCaseInsensitive.putAll(jsonNodeMap);
            return this.jsonToCarbonRecord(jsonNodeMapCaseInsensitive, this.dataFields);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse Json String: " + e.getMessage(), e);
        }
    }

    private Object[] jsonToCarbonRecord(Map<String, Object> jsonNodeMap, DataField[] dataFields) {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (DataField dataField : dataFields) {
            Object field = this.jsonToCarbonObject(jsonNodeMap, dataField.getColumn());
            fields.add(field);
        }
        return fields.toArray();
    }

    private Object jsonToCarbonObject(Map<String, Object> jsonNodeMap, CarbonColumn column) {
        DataType type = column.getDataType();
        if (DataTypes.isArrayType((DataType)type)) {
            CarbonDimension carbonDimension = (CarbonDimension)column;
            ArrayList array = (ArrayList)jsonNodeMap.get(JsonRowParser.extractChildColumnName(column));
            if (array == null || array.size() == 0) {
                return null;
            }
            Object[] arrayChildObjects = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                CarbonDimension childCol = (CarbonDimension)carbonDimension.getListOfChildDimensions().get(0);
                arrayChildObjects[i] = this.jsonChildElementToCarbonChildElement(array.get(i), childCol);
            }
            return new ArrayObject(arrayChildObjects);
        }
        if (DataTypes.isStructType((DataType)type)) {
            CarbonDimension carbonDimension = (CarbonDimension)column;
            int size = carbonDimension.getNumberOfChild();
            Map jsonMap = (Map)jsonNodeMap.get(JsonRowParser.extractChildColumnName(column));
            if (jsonMap == null) {
                return null;
            }
            Object[] structChildObjects = new Object[size];
            for (int i = 0; i < size; ++i) {
                Object childObject;
                CarbonDimension childCol = (CarbonDimension)carbonDimension.getListOfChildDimensions().get(i);
                structChildObjects[i] = childObject = this.jsonChildElementToCarbonChildElement(jsonMap.get(JsonRowParser.extractChildColumnName((CarbonColumn)childCol)), childCol);
            }
            return new StructObject(structChildObjects);
        }
        if (jsonNodeMap.get(JsonRowParser.extractChildColumnName(column)) == null) {
            return null;
        }
        return jsonNodeMap.get(JsonRowParser.extractChildColumnName(column)).toString();
    }

    private Object jsonChildElementToCarbonChildElement(Object childObject, CarbonDimension column) {
        if (childObject == null) {
            return null;
        }
        DataType type = column.getDataType();
        if (DataTypes.isArrayType((DataType)type)) {
            ArrayList array = (ArrayList)childObject;
            if (array.size() == 0) {
                return null;
            }
            Object[] arrayChildObjects = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                CarbonDimension childCol = (CarbonDimension)column.getListOfChildDimensions().get(0);
                arrayChildObjects[i] = this.jsonChildElementToCarbonChildElement(array.get(i), childCol);
            }
            return new ArrayObject(arrayChildObjects);
        }
        if (DataTypes.isStructType((DataType)type)) {
            Map childFieldsMap = (Map)childObject;
            int size = column.getNumberOfChild();
            Object[] structChildObjects = new Object[size];
            for (int i = 0; i < size; ++i) {
                Object child;
                CarbonDimension childCol = (CarbonDimension)column.getListOfChildDimensions().get(i);
                structChildObjects[i] = child = this.jsonChildElementToCarbonChildElement(childFieldsMap.get(JsonRowParser.extractChildColumnName((CarbonColumn)childCol)), childCol);
            }
            return new StructObject(structChildObjects);
        }
        return childObject.toString();
    }

    private static String extractChildColumnName(CarbonColumn column) {
        String columnName = column.getColName();
        if (column.getColumnSchema().isComplexColumn()) {
            String[] splits = columnName.split("\\.");
            columnName = splits[splits.length - 1];
        }
        return columnName;
    }
}

