/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.partition.impl;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.processing.loading.partition.Partitioner;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class RangePartitionerImpl
implements Partitioner<CarbonRow> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)RangePartitionerImpl.class.getName());
    private CarbonRow[] rangeBounds;
    private Comparator<CarbonRow> comparator;

    public RangePartitionerImpl(CarbonRow[] rangeBounds, Comparator<CarbonRow> comparator) {
        this.rangeBounds = rangeBounds;
        LOGGER.info((Object)("Use range partitioner to distribute data to " + (rangeBounds.length + 1) + " ranges."));
        this.comparator = comparator;
    }

    @Override
    public int getPartition(CarbonRow key) {
        int partition;
        if (this.rangeBounds.length <= 128) {
            for (partition = 0; partition < this.rangeBounds.length && this.comparator.compare(key, this.rangeBounds[partition]) > 0; ++partition) {
            }
        } else {
            partition = Arrays.binarySearch(this.rangeBounds, 0, this.rangeBounds.length, key, this.comparator);
            if (partition < 0) {
                partition = -partition - 1;
            }
            if (partition > this.rangeBounds.length) {
                partition = this.rangeBounds.length;
            }
        }
        return partition;
    }
}

