/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.row;

import java.util.NoSuchElementException;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.commons.lang.ArrayUtils;

public class CarbonRowBatch
extends CarbonIterator<CarbonRow> {
    private CarbonRow[] rowBatch;
    private int size = 0;
    private int index = 0;

    public CarbonRowBatch(int batchSize) {
        this.rowBatch = new CarbonRow[batchSize];
    }

    public void addRow(CarbonRow carbonRow) {
        this.rowBatch[this.size++] = carbonRow;
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    public CarbonRow next() throws NoSuchElementException {
        if (this.hasNext()) {
            return this.rowBatch[this.index++];
        }
        throw new NoSuchElementException("no more elements to iterate");
    }

    public void remove() {
        this.rowBatch = (CarbonRow[])ArrayUtils.remove((Object[])this.rowBatch, (int)(this.index - 1));
        --this.size;
        --this.index;
    }

    public void setPreviousRow(CarbonRow row) {
        if (this.index == 0) {
            throw new RuntimeException("Unable to set a row in RowBatch before index 0");
        }
        this.rowBatch[this.index - 1] = row;
    }

    public void rewind() {
        this.index = 0;
    }
}

