/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.schema.ColumnRangeInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.loading.sort.AbstractMergeSorter;
import org.apache.carbondata.processing.loading.sort.impl.ThreadStatusObserver;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SingleThreadFinalSortFilesMerger;
import org.apache.carbondata.processing.sort.sortdata.SortDataRows;
import org.apache.carbondata.processing.sort.sortdata.SortIntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.log4j.Logger;

public class ParallelReadMergeSorterWithColumnRangeImpl
extends AbstractMergeSorter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ParallelReadMergeSorterWithColumnRangeImpl.class.getName());
    private SortParameters originSortParameters;
    private SortIntermediateFileMerger[] intermediateFileMergers;
    private ColumnRangeInfo columnRangeInfo;
    private int sortBufferSize;
    private AtomicLong rowCounter;
    private List<AtomicLong> insideRowCounterList;

    public ParallelReadMergeSorterWithColumnRangeImpl(AtomicLong rowCounter, ColumnRangeInfo columnRangeInfo) {
        this.rowCounter = rowCounter;
        this.columnRangeInfo = columnRangeInfo;
    }

    @Override
    public void initialize(SortParameters sortParameters) {
        this.originSortParameters = sortParameters;
        int buffer = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.sort.size", "100000"));
        this.sortBufferSize = buffer / this.columnRangeInfo.getNumOfRanges();
        if (this.sortBufferSize < 100) {
            this.sortBufferSize = 100;
        }
        this.insideRowCounterList = new ArrayList<AtomicLong>(this.columnRangeInfo.getNumOfRanges());
        for (int i = 0; i < this.columnRangeInfo.getNumOfRanges(); ++i) {
            this.insideRowCounterList.add(new AtomicLong(0L));
        }
        CarbonDataProcessorUtil.deleteSortLocationIfExists(sortParameters.getTempFileLocation());
        CarbonDataProcessorUtil.createLocations(sortParameters.getTempFileLocation());
    }

    @Override
    public Iterator<CarbonRowBatch>[] sort(Iterator<CarbonRowBatch>[] iterators) throws CarbonDataLoadingException {
        int i;
        SortDataRows[] sortDataRows = new SortDataRows[this.columnRangeInfo.getNumOfRanges()];
        this.intermediateFileMergers = new SortIntermediateFileMerger[this.columnRangeInfo.getNumOfRanges()];
        SortParameters[] sortParameterArray = new SortParameters[this.columnRangeInfo.getNumOfRanges()];
        for (int i2 = 0; i2 < this.columnRangeInfo.getNumOfRanges(); ++i2) {
            SortParameters parameters = this.originSortParameters.getCopy();
            parameters.setPartitionID(i2 + "");
            parameters.setRangeId(i2);
            sortParameterArray[i2] = parameters;
            this.setTempLocation(parameters);
            parameters.setBufferSize(this.sortBufferSize);
            this.intermediateFileMergers[i2] = new SortIntermediateFileMerger(parameters);
            sortDataRows[i2] = new SortDataRows(parameters, this.intermediateFileMergers[i2]);
            sortDataRows[i2].initialize();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(iterators.length);
        this.threadStatusObserver = new ThreadStatusObserver(executorService);
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        try {
            for (i = 0; i < iterators.length; ++i) {
                executorService.execute(new SortIteratorThread(iterators[i], sortDataRows, this.rowCounter, this.insideRowCounterList, this.threadStatusObserver));
            }
            executorService.shutdown();
            executorService.awaitTermination(2L, TimeUnit.DAYS);
            this.processRowToNextStep(sortDataRows, this.originSortParameters);
        }
        catch (Exception e) {
            this.checkError();
            throw new CarbonDataLoadingException("Problem while shutdown the server ", e);
        }
        this.checkError();
        try {
            for (i = 0; i < this.intermediateFileMergers.length; ++i) {
                this.intermediateFileMergers[i].finish();
            }
        }
        catch (CarbonDataWriterException | CarbonSortKeyAndGroupByException e) {
            throw new CarbonDataLoadingException(e);
        }
        Iterator[] batchIterator = new Iterator[this.columnRangeInfo.getNumOfRanges()];
        for (int i3 = 0; i3 < this.columnRangeInfo.getNumOfRanges(); ++i3) {
            batchIterator[i3] = new MergedDataIterator(sortParameterArray[i3], batchSize);
        }
        return batchIterator;
    }

    private SingleThreadFinalSortFilesMerger getFinalMerger(SortParameters sortParameters) {
        String[] storeLocation = CarbonDataProcessorUtil.getLocalDataFolderLocation(sortParameters.getCarbonTable(), String.valueOf(sortParameters.getTaskNo()), sortParameters.getSegmentId() + "", false, false);
        String[] dataFolderLocation = CarbonDataProcessorUtil.arrayAppend(storeLocation, File.separator, "sortrowtmp");
        return new SingleThreadFinalSortFilesMerger(dataFolderLocation, sortParameters.getTableName(), sortParameters);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.intermediateFileMergers.length; ++i) {
            this.intermediateFileMergers[i].close();
        }
    }

    private boolean processRowToNextStep(SortDataRows[] sortDataRows, SortParameters parameters) throws CarbonDataLoadingException {
        try {
            for (int i = 0; i < sortDataRows.length; ++i) {
                sortDataRows[i].startSorting();
            }
            LOGGER.info((Object)("Record Processed For table: " + parameters.getTableName()));
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordSortRowsStepTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValuesTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
            return false;
        }
        catch (CarbonSortKeyAndGroupByException e) {
            throw new CarbonDataLoadingException(e);
        }
    }

    private void setTempLocation(SortParameters parameters) {
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(parameters.getCarbonTable(), parameters.getTaskNo(), parameters.getSegmentId(), false, false);
        String[] tmpLocs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        parameters.setTempFileLocation(tmpLocs);
    }

    private class MergedDataIterator
    extends CarbonIterator<CarbonRowBatch> {
        private SortParameters sortParameters;
        private int batchSize;
        private boolean firstRow = true;
        private SingleThreadFinalSortFilesMerger finalMerger;

        public MergedDataIterator(SortParameters sortParameters, int batchSize) {
            this.sortParameters = sortParameters;
            this.batchSize = batchSize;
        }

        public boolean hasNext() {
            if (this.firstRow) {
                this.firstRow = false;
                this.finalMerger = ParallelReadMergeSorterWithColumnRangeImpl.this.getFinalMerger(this.sortParameters);
                this.finalMerger.startFinalMerge();
            }
            return this.finalMerger.hasNext();
        }

        public CarbonRowBatch next() {
            CarbonRowBatch rowBatch = new CarbonRowBatch(this.batchSize);
            for (int counter = 0; this.finalMerger.hasNext() && counter < this.batchSize; ++counter) {
                rowBatch.addRow(new CarbonRow(this.finalMerger.next()));
            }
            return rowBatch;
        }
    }

    private static class SortIteratorThread
    implements Runnable {
        private Iterator<CarbonRowBatch> iterator;
        private SortDataRows[] sortDataRows;
        private AtomicLong rowCounter;
        private List<AtomicLong> insideCounterList;
        private ThreadStatusObserver threadStatusObserver;

        public SortIteratorThread(Iterator<CarbonRowBatch> iterator, SortDataRows[] sortDataRows, AtomicLong rowCounter, List<AtomicLong> insideCounterList, ThreadStatusObserver observer) {
            this.iterator = iterator;
            this.sortDataRows = sortDataRows;
            this.rowCounter = rowCounter;
            this.insideCounterList = insideCounterList;
            this.threadStatusObserver = observer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.iterator.hasNext()) {
                    CarbonRowBatch batch = this.iterator.next();
                    while (batch.hasNext()) {
                        SortDataRows sortDataRow;
                        CarbonRow row = batch.next();
                        if (row == null) continue;
                        SortDataRows sortDataRows = sortDataRow = this.sortDataRows[row.getRangeId()];
                        synchronized (sortDataRows) {
                            sortDataRow.addRow(row.getData());
                            this.insideCounterList.get(row.getRangeId()).getAndIncrement();
                            this.rowCounter.getAndAdd(1L);
                        }
                    }
                }
                LOGGER.info((Object)("Rows processed by each range: " + this.insideCounterList));
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.threadStatusObserver.notifyFailed(e);
            }
        }
    }
}

