/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.holder;

import java.util.Comparator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.SortTempChunkHolder;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeInMemoryIntermediateDataMerger;
import org.apache.carbondata.processing.sort.sortdata.FileMergeSortComparator;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;
import org.apache.log4j.Logger;

public class UnsafeFinalMergePageHolder
implements SortTempChunkHolder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeFinalMergePageHolder.class.getName());
    private int counter;
    private int actualSize;
    private long[] mergedAddresses;
    private byte[] rowPageIndexes;
    private UnsafeCarbonRowPage[] rowPages;
    private Comparator<IntermediateSortTempRow> comparator;
    private IntermediateSortTempRow currentRow;
    private DataType[] noDictDataType;

    public UnsafeFinalMergePageHolder(UnsafeInMemoryIntermediateDataMerger merger, TableFieldStat tableFieldStat) {
        this.actualSize = merger.getEntryCount();
        this.mergedAddresses = merger.getMergedAddresses();
        this.rowPageIndexes = merger.getRowPageIndexes();
        for (UnsafeCarbonRowPage rowPage : this.rowPages = merger.getUnsafeCarbonRowPages()) {
            rowPage.setReadConvertedNoSortField();
        }
        this.noDictDataType = this.rowPages[0].getTableFieldStat().getNoDictDataType();
        LOGGER.info((Object)("Processing unsafe inmemory rows page with size : " + this.actualSize));
        this.comparator = new FileMergeSortComparator(tableFieldStat.getIsSortColNoDictFlags(), tableFieldStat.getNoDictDataType(), tableFieldStat.getNoDictSortColumnSchemaOrderMapping());
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.actualSize;
    }

    @Override
    public void readRow() {
        this.currentRow = this.rowPages[this.rowPageIndexes[this.counter]].getRow(this.mergedAddresses[this.counter]);
        ++this.counter;
    }

    @Override
    public IntermediateSortTempRow getRow() {
        return this.currentRow;
    }

    @Override
    public int compareTo(SortTempChunkHolder o) {
        return this.comparator.compare(this.currentRow, o.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnsafeFinalMergePageHolder)) {
            return false;
        }
        UnsafeFinalMergePageHolder o = (UnsafeFinalMergePageHolder)obj;
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int numberOfRows() {
        return this.actualSize;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.rowPages.length; ++i) {
            this.rowPages[i].freeMemory();
        }
    }
}

