/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.holder;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.comparator.UnsafeRowComparator;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRowForMerge;
import org.apache.log4j.Logger;

public class UnsafeInmemoryMergeHolder
implements Comparable<UnsafeInmemoryMergeHolder> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeInmemoryMergeHolder.class.getName());
    private int counter;
    private int actualSize;
    private UnsafeCarbonRowPage rowPage;
    private UnsafeCarbonRowForMerge currentRow;
    private long address;
    private UnsafeRowComparator comparator;
    private Object baseObject;
    private byte index;

    public UnsafeInmemoryMergeHolder(UnsafeCarbonRowPage rowPage, byte index) {
        this.actualSize = rowPage.getBuffer().getActualSize();
        this.rowPage = rowPage;
        LOGGER.info((Object)("Processing unsafe inmemory rows page with size : " + this.actualSize));
        this.comparator = new UnsafeRowComparator(rowPage);
        this.baseObject = rowPage.getDataBlock().getBaseObject();
        this.currentRow = new UnsafeCarbonRowForMerge();
        this.index = index;
    }

    public boolean hasNext() {
        return this.counter < this.actualSize;
    }

    public void readRow() {
        this.address = this.rowPage.getBuffer().get(this.counter);
        this.currentRow = new UnsafeCarbonRowForMerge();
        this.currentRow.address = this.address + this.rowPage.getDataBlock().getBaseOffset();
        this.currentRow.index = this.index;
        ++this.counter;
    }

    public UnsafeCarbonRowForMerge getRow() {
        return this.currentRow;
    }

    @Override
    public int compareTo(UnsafeInmemoryMergeHolder o) {
        return this.comparator.compare(this.currentRow, this.baseObject, o.getRow(), o.getBaseObject());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnsafeInmemoryMergeHolder)) {
            return false;
        }
        UnsafeInmemoryMergeHolder o = (UnsafeInmemoryMergeHolder)obj;
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public void close() {
        this.rowPage.freeMemory();
    }
}

