/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.SortColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.BadRecordsLoggerProvider;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.RowConverter;
import org.apache.carbondata.processing.loading.converter.impl.RowConverterImpl;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.partition.Partitioner;
import org.apache.carbondata.processing.loading.partition.impl.HashPartitionerImpl;
import org.apache.carbondata.processing.loading.partition.impl.RangePartitionerImpl;
import org.apache.carbondata.processing.loading.partition.impl.RawRowComparator;
import org.apache.carbondata.processing.loading.partition.impl.SparkHashExpressionPartitionerImpl;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.util.CarbonBadRecordUtil;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;

public class DataConverterProcessorStepImpl
extends AbstractDataLoadProcessorStep {
    private List<RowConverter> converters;
    private Partitioner<CarbonRow> partitioner;
    private BadRecordsLogger badRecordLogger;
    private boolean isSortColumnRangeEnabled = false;
    private boolean isBucketColumnEnabled = false;

    public DataConverterProcessorStepImpl(CarbonDataLoadConfiguration configuration, AbstractDataLoadProcessorStep child) {
        super(configuration, child);
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.child.initialize();
        this.converters = new ArrayList<RowConverter>();
        this.badRecordLogger = BadRecordsLoggerProvider.createBadRecordLogger(this.configuration);
        RowConverterImpl converter = new RowConverterImpl(this.child.getOutput(), this.configuration, this.badRecordLogger);
        this.converters.add(converter);
        converter.initialize();
        if (null != this.configuration.getBucketingInfo()) {
            this.isBucketColumnEnabled = true;
            this.initializeBucketColumnPartitioner();
        } else if (null != this.configuration.getSortColumnRangeInfo()) {
            this.isSortColumnRangeEnabled = true;
            this.initializeSortColumnRangesPartitioner();
        }
    }

    private void initializeBucketColumnPartitioner() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        DataField[] inputDataFields = this.getOutput();
        BucketingInfo bucketingInfo = this.configuration.getBucketingInfo();
        block0: for (int i = 0; i < inputDataFields.length; ++i) {
            for (int j = 0; j < bucketingInfo.getListOfColumns().size(); ++j) {
                if (!inputDataFields[i].getColumn().getColName().equals(((ColumnSchema)bucketingInfo.getListOfColumns().get(j)).getColumnName())) continue;
                indexes.add(i);
                columnSchemas.add(inputDataFields[i].getColumn().getColumnSchema());
                continue block0;
            }
        }
        this.partitioner = "spark_hash_expression".equals(this.configuration.getBucketHashMethod()) ? new SparkHashExpressionPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()) : ("native".equals(this.configuration.getBucketHashMethod()) ? new HashPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()) : new SparkHashExpressionPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()));
    }

    private void initializeSortColumnRangesPartitioner() {
        SortColumnRangeInfo sortColumnRangeInfo = this.configuration.getSortColumnRangeInfo();
        int rangeValueCnt = sortColumnRangeInfo.getUserSpecifiedRanges().length;
        CarbonRow[] convertedSortColumnRanges = new CarbonRow[rangeValueCnt];
        for (int i = 0; i < rangeValueCnt; ++i) {
            Object[] fakeOriginRow = new Object[this.configuration.getDataFields().length];
            String[] oneBound = StringUtils.splitPreserveAllTokens((String)sortColumnRangeInfo.getUserSpecifiedRanges()[i], (String)sortColumnRangeInfo.getSeparator(), (int)-1);
            int j = 0;
            for (int colIdx : sortColumnRangeInfo.getSortColumnIndex()) {
                fakeOriginRow[colIdx] = oneBound[j++];
            }
            CarbonRow fakeCarbonRow = new CarbonRow(fakeOriginRow);
            this.convertFakeRow(fakeCarbonRow, sortColumnRangeInfo);
            convertedSortColumnRanges[i] = fakeCarbonRow;
        }
        Arrays.sort(convertedSortColumnRanges, new RawRowComparator(sortColumnRangeInfo.getSortColumnIndex(), sortColumnRangeInfo.getIsSortColumnNoDict(), CarbonDataProcessorUtil.getNoDictDataTypes(this.configuration.getTableSpec().getCarbonTable())));
        this.partitioner = new RangePartitionerImpl(convertedSortColumnRanges, new RawRowComparator(sortColumnRangeInfo.getSortColumnIndex(), sortColumnRangeInfo.getIsSortColumnNoDict(), CarbonDataProcessorUtil.getNoDictDataTypes(this.configuration.getTableSpec().getCarbonTable())));
    }

    private void convertFakeRow(CarbonRow fakeRow, SortColumnRangeInfo sortColumnRangeInfo) {
        FieldConverter[] fieldConverters = this.converters.get(0).getFieldConverters();
        BadRecordLogHolder logHolder = new BadRecordLogHolder();
        logHolder.setLogged(false);
        for (int colIdx : sortColumnRangeInfo.getSortColumnIndex()) {
            fieldConverters[colIdx].convert(fakeRow, logHolder);
        }
    }

    @Override
    public Iterator<CarbonRowBatch>[] execute() throws CarbonDataLoadingException {
        Iterator<CarbonRowBatch>[] childIters = this.child.execute();
        Iterator[] iterators = new Iterator[childIters.length];
        for (int i = 0; i < childIters.length; ++i) {
            iterators[i] = this.getIterator(childIters[i]);
        }
        return iterators;
    }

    private Iterator<CarbonRowBatch> getIterator(final Iterator<CarbonRowBatch> childIter) {
        return new CarbonIterator<CarbonRowBatch>(){
            private boolean first = true;
            private RowConverter localConverter;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.first) {
                    this.first = false;
                    this.localConverter = ((RowConverter)DataConverterProcessorStepImpl.this.converters.get(0)).createCopyForNewThread();
                    List list = DataConverterProcessorStepImpl.this.converters;
                    synchronized (list) {
                        DataConverterProcessorStepImpl.this.converters.add(this.localConverter);
                    }
                }
                return childIter.hasNext();
            }

            public CarbonRowBatch next() {
                return DataConverterProcessorStepImpl.this.processRowBatch((CarbonRowBatch)((Object)childIter.next()), this.localConverter);
            }
        };
    }

    protected CarbonRowBatch processRowBatch(CarbonRowBatch rowBatch, RowConverter localConverter) {
        while (rowBatch.hasNext()) {
            CarbonRow convertRow = localConverter.convert(rowBatch.next());
            if (convertRow == null) {
                rowBatch.remove();
                continue;
            }
            if (this.isSortColumnRangeEnabled || this.isBucketColumnEnabled) {
                short rangeNumber = (short)this.partitioner.getPartition(convertRow);
                convertRow.setRangeId(rangeNumber);
            }
            rowBatch.setPreviousRow(convertRow);
        }
        this.rowCounter.getAndAdd(rowBatch.getSize());
        rowBatch.rewind();
        return rowBatch;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (null != this.badRecordLogger) {
                this.badRecordLogger.closeStreams();
                CarbonBadRecordUtil.renameBadRecord(this.configuration);
            }
            super.close();
            if (this.converters != null) {
                for (RowConverter converter : this.converters) {
                    if (null == converter) continue;
                    converter.finish();
                }
            }
        }
    }

    @Override
    protected String getStepName() {
        if (this.isBucketColumnEnabled) {
            return "Data Converter with Bucketing";
        }
        if (this.isSortColumnRangeEnabled) {
            return "Data Converter with sort column range";
        }
        return "Data Converter";
    }
}

