/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.RowConverter;
import org.apache.carbondata.processing.loading.converter.impl.FieldEncoderFactory;
import org.apache.carbondata.processing.loading.converter.impl.RowConverterImpl;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.partition.Partitioner;
import org.apache.carbondata.processing.loading.partition.impl.HashPartitionerImpl;
import org.apache.carbondata.processing.loading.partition.impl.SparkHashExpressionPartitionerImpl;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class InputProcessorStepWithNoConverterImpl
extends AbstractDataLoadProcessorStep {
    private CarbonIterator<Object[]>[] inputIterators;
    private boolean[] noDictionaryMapping;
    private DataType[] dataTypes;
    private int[] orderOfData;
    private Map<Integer, GenericDataType> dataFieldsWithComplexDataType;
    private RowConverterImpl rowConverter;
    private short sdkWriterCores;
    private boolean withoutReArrange;
    private boolean isBucketColumnEnabled = false;
    private Partitioner<CarbonRow> partitioner;

    public InputProcessorStepWithNoConverterImpl(CarbonDataLoadConfiguration configuration, CarbonIterator<Object[]>[] inputIterators, boolean withoutReArrange) {
        super(configuration, null);
        this.inputIterators = inputIterators;
        this.sdkWriterCores = configuration.getWritingCoresCount();
        this.withoutReArrange = withoutReArrange;
    }

    @Override
    public DataField[] getOutput() {
        return this.configuration.getDataFields();
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.rowConverter = new RowConverterImpl(this.configuration.getDataFields(), this.configuration, null);
        this.rowConverter.initialize();
        if (!this.withoutReArrange) {
            this.noDictionaryMapping = CarbonDataProcessorUtil.getNoDictionaryMapping(this.configuration.getDataFields());
        }
        this.dataFieldsWithComplexDataType = new HashMap<Integer, GenericDataType>();
        this.convertComplexDataType(this.dataFieldsWithComplexDataType);
        this.dataTypes = new DataType[this.configuration.getDataFields().length];
        for (int i = 0; i < this.dataTypes.length; ++i) {
            this.dataTypes[i] = this.configuration.getDataFields()[i].getColumn().getDataType() == DataTypes.DATE ? DataTypes.INT : this.configuration.getDataFields()[i].getColumn().getDataType();
        }
        if (!this.withoutReArrange) {
            this.orderOfData = this.arrangeData(this.configuration.getDataFields(), this.configuration.getHeader());
        }
        if (null != this.configuration.getBucketingInfo()) {
            this.isBucketColumnEnabled = true;
            this.initializeBucketColumnPartitioner();
        }
    }

    private void initializeBucketColumnPartitioner() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        DataField[] inputDataFields = this.getOutput();
        BucketingInfo bucketingInfo = this.configuration.getBucketingInfo();
        block0: for (int i = 0; i < inputDataFields.length; ++i) {
            for (int j = 0; j < bucketingInfo.getListOfColumns().size(); ++j) {
                if (!inputDataFields[i].getColumn().getColName().equals(((ColumnSchema)bucketingInfo.getListOfColumns().get(j)).getColumnName())) continue;
                indexes.add(i);
                columnSchemas.add(inputDataFields[i].getColumn().getColumnSchema());
                continue block0;
            }
        }
        this.partitioner = "spark_hash_expression".equals(this.configuration.getBucketHashMethod()) ? new SparkHashExpressionPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()) : ("native".equals(this.configuration.getBucketHashMethod()) ? new HashPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()) : new SparkHashExpressionPartitionerImpl(indexes, columnSchemas, bucketingInfo.getNumOfRanges()));
    }

    private void convertComplexDataType(Map<Integer, GenericDataType> dataFieldsWithComplexDataType) {
        DataField[] srcDataField = this.configuration.getDataFields();
        String nullFormat = this.configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        for (int i = 0; i < srcDataField.length; ++i) {
            if (!srcDataField[i].getColumn().isComplex().booleanValue()) continue;
            dataFieldsWithComplexDataType.put(srcDataField[i].getColumn().getOrdinal(), FieldEncoderFactory.createComplexDataType(srcDataField[i], nullFormat, null));
        }
    }

    private int[] arrangeData(DataField[] dataFields, String[] header) {
        int[] data = new int[dataFields.length];
        block0: for (int i = 0; i < dataFields.length; ++i) {
            for (int j = 0; j < header.length; ++j) {
                if (!dataFields[i].getColumn().getColName().equalsIgnoreCase(header[j])) continue;
                data[i] = j;
                continue block0;
            }
        }
        return data;
    }

    @Override
    public Iterator<CarbonRowBatch>[] execute() {
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        List<CarbonIterator<Object[]>>[] readerIterators = CarbonDataProcessorUtil.partitionInputReaderIterators(this.inputIterators, this.sdkWriterCores);
        Iterator[] outIterators = new Iterator[readerIterators.length];
        for (int i = 0; i < outIterators.length; ++i) {
            outIterators[i] = new InputProcessorIterator(readerIterators[i], batchSize, this.rowCounter, this.orderOfData, this.noDictionaryMapping, this.dataTypes, this.configuration, this.dataFieldsWithComplexDataType, this.rowConverter, this.withoutReArrange, this.isBucketColumnEnabled, this.partitioner);
        }
        return outIterators;
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            for (CarbonIterator<Object[]> inputIterator : this.inputIterators) {
                inputIterator.close();
            }
        }
    }

    @Override
    protected String getStepName() {
        return "Input Processor";
    }

    private static class InputProcessorIterator
    extends CarbonIterator<CarbonRowBatch> {
        private List<CarbonIterator<Object[]>> inputIterators;
        private CarbonIterator<Object[]> currentIterator;
        private int counter;
        private int batchSize;
        private boolean nextBatch;
        private boolean firstTime;
        private AtomicLong rowCounter;
        private boolean[] noDictionaryMapping;
        private DataType[] dataTypes;
        private DataField[] dataFields;
        private int[] orderOfData;
        private Map<Integer, GenericDataType> dataFieldsWithComplexDataType;
        private DirectDictionaryGenerator dateDictionaryGenerator;
        private DirectDictionaryGenerator timestampDictionaryGenerator;
        private BadRecordLogHolder logHolder = new BadRecordLogHolder();
        private boolean isHivePartitionTable = false;
        RowConverter converter;
        CarbonDataLoadConfiguration configuration;
        private boolean isBucketColumnEnabled = false;
        private Partitioner<CarbonRow> partitioner;
        private boolean withoutReArrange;

        public InputProcessorIterator(List<CarbonIterator<Object[]>> inputIterators, int batchSize, AtomicLong rowCounter, int[] orderOfData, boolean[] noDictionaryMapping, DataType[] dataTypes, CarbonDataLoadConfiguration configuration, Map<Integer, GenericDataType> dataFieldsWithComplexDataType, RowConverter converter, boolean withoutReArrange, boolean bucketColumnEnabled, Partitioner<CarbonRow> partitioner) {
            this.inputIterators = inputIterators;
            this.batchSize = batchSize;
            this.counter = 0;
            this.currentIterator = inputIterators.get(this.counter++);
            this.rowCounter = rowCounter;
            this.nextBatch = false;
            this.firstTime = true;
            this.noDictionaryMapping = noDictionaryMapping;
            this.dataTypes = dataTypes;
            this.dataFields = configuration.getDataFields();
            this.orderOfData = orderOfData;
            this.dataFieldsWithComplexDataType = dataFieldsWithComplexDataType;
            this.isHivePartitionTable = configuration.getTableSpec().getCarbonTable().isHivePartitionTable();
            this.configuration = configuration;
            this.converter = converter;
            this.withoutReArrange = withoutReArrange;
            this.isBucketColumnEnabled = bucketColumnEnabled;
            this.partitioner = partitioner;
        }

        public boolean hasNext() {
            return this.nextBatch || this.internalHasNext();
        }

        private boolean internalHasNext() {
            boolean hasNext;
            if (this.firstTime) {
                this.firstTime = false;
                this.currentIterator.initialize();
            }
            if (!(hasNext = this.currentIterator.hasNext())) {
                this.currentIterator.close();
                if (this.counter < this.inputIterators.size()) {
                    this.currentIterator = this.inputIterators.get(this.counter++);
                    this.currentIterator.initialize();
                    hasNext = this.internalHasNext();
                }
            }
            return hasNext;
        }

        public CarbonRowBatch next() {
            return this.getBatch();
        }

        private CarbonRowBatch getBatch() {
            int count;
            CarbonRowBatch carbonRowBatch = new CarbonRowBatch(this.batchSize);
            if (!this.withoutReArrange) {
                for (count = 0; this.internalHasNext() && count < this.batchSize; ++count) {
                    CarbonRow carbonRow = new CarbonRow(this.convertToNoDictionaryToBytes((Object[])this.currentIterator.next(), this.dataFields));
                    if (this.configuration.isNonSchemaColumnsPresent()) {
                        carbonRow = this.converter.convert(carbonRow);
                    }
                    if (this.isBucketColumnEnabled) {
                        short rangeNumber = (short)this.partitioner.getPartition(carbonRow);
                        carbonRow.setRangeId(rangeNumber);
                    }
                    carbonRowBatch.addRow(carbonRow);
                }
            } else {
                while (this.internalHasNext() && count < this.batchSize) {
                    CarbonRow carbonRow = new CarbonRow(this.convertToNoDictionaryToBytesWithoutReArrange((Object[])this.currentIterator.next(), this.dataFields));
                    if (this.configuration.isNonSchemaColumnsPresent()) {
                        carbonRow = this.converter.convert(carbonRow);
                    }
                    if (this.isBucketColumnEnabled) {
                        short rangeNumber = (short)this.partitioner.getPartition(carbonRow);
                        carbonRow.setRangeId(rangeNumber);
                    }
                    carbonRowBatch.addRow(carbonRow);
                    ++count;
                }
            }
            this.rowCounter.getAndAdd(carbonRowBatch.getSize());
            return carbonRowBatch;
        }

        private Object[] convertToNoDictionaryToBytes(Object[] data, DataField[] dataFields) {
            Object[] newData = new Object[dataFields.length];
            for (int i = 0; i < dataFields.length; ++i) {
                if (dataFields[i].getColumn().isSpatialColumn()) continue;
                if (i < this.noDictionaryMapping.length && this.noDictionaryMapping[i]) {
                    if (DataTypeUtil.isPrimitiveColumn((DataType)this.dataTypes[i])) {
                        newData[i] = data[this.orderOfData[i]];
                        continue;
                    }
                    newData[i] = DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn((Object)data[this.orderOfData[i]], (DataType)this.dataTypes[i]);
                    continue;
                }
                if (this.dataTypes[i].isComplexType() && this.isHivePartitionTable) {
                    newData[i] = data[this.orderOfData[i]];
                    continue;
                }
                if (this.dataTypes[i].isComplexType()) {
                    this.getComplexTypeByteArray(newData, i, data, dataFields[i], this.orderOfData[i], false);
                    continue;
                }
                DataType dataType = dataFields[i].getColumn().getDataType();
                if (dataType == DataTypes.DATE && data[this.orderOfData[i]] instanceof Long) {
                    if (this.dateDictionaryGenerator == null) {
                        this.dateDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dataType, (String)dataFields[i].getDateFormat());
                    }
                    newData[i] = this.dateDictionaryGenerator.generateKey(((Long)data[this.orderOfData[i]]).longValue());
                    continue;
                }
                if (dataType == DataTypes.TIMESTAMP && data[this.orderOfData[i]] instanceof Long) {
                    if (this.timestampDictionaryGenerator == null) {
                        this.timestampDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dataType, (String)dataFields[i].getTimestampFormat());
                    }
                    newData[i] = this.timestampDictionaryGenerator.generateKey(((Long)data[this.orderOfData[i]]).longValue());
                    continue;
                }
                newData[i] = data[this.orderOfData[i]];
            }
            return newData;
        }

        private Object[] convertToNoDictionaryToBytesWithoutReArrange(Object[] data, DataField[] dataFields) {
            Object[] newData = new Object[dataFields.length];
            int index = 0;
            for (int i = 0; i < dataFields.length; ++i) {
                if (dataFields[i].getColumn().isSpatialColumn()) continue;
                if (DataTypeUtil.isPrimitiveColumn((DataType)this.dataTypes[i])) {
                    newData[i] = data[index];
                } else if (this.dataTypes[i].isComplexType()) {
                    this.getComplexTypeByteArray(newData, i, data, dataFields[i], index, true);
                } else if (this.dataTypes[i] == DataTypes.DATE && data[index] instanceof Long) {
                    if (this.dateDictionaryGenerator == null) {
                        this.dateDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)this.dataTypes[i], (String)dataFields[i].getDateFormat());
                    }
                    newData[i] = this.dateDictionaryGenerator.generateKey(((Long)data[index]).longValue());
                } else {
                    newData[i] = DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn((Object)data[index], (DataType)this.dataTypes[i]);
                }
                ++index;
            }
            return newData;
        }

        private void getComplexTypeByteArray(Object[] newData, int index, Object[] data, DataField dataField, int orderedIndex, boolean isWithoutConverter) {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArray);
            try {
                GenericDataType complextType = this.dataFieldsWithComplexDataType.get(dataField.getColumn().getOrdinal());
                complextType.writeByteArray(data[orderedIndex], dataOutputStream, this.logHolder, isWithoutConverter);
                dataOutputStream.close();
                newData[index] = byteArray.toByteArray();
            }
            catch (BadRecordFoundException e) {
                throw new CarbonDataLoadingException("Loading Exception: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new CarbonDataLoadingException("Loading Exception", e);
            }
        }
    }
}

