/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.processing.exception.SliceMergerException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.AbstractResultProcessor;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerColumnar;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.log4j.Logger;

public class RowResultMergerProcessor
extends AbstractResultProcessor {
    private CarbonFactHandler dataHandler;
    private SegmentProperties segprop;
    private CarbonLoadModel loadModel;
    private PartitionSpec partitionSpec;
    CarbonColumn[] noDicAndComplexColumns;
    private AbstractQueue<RawResultIterator> recordHolderHeap;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)RowResultMergerProcessor.class.getName());

    public RowResultMergerProcessor(String databaseName, String tableName, SegmentProperties segProp, String[] tempStoreLocation, CarbonLoadModel loadModel, CompactionType compactionType, PartitionSpec partitionSpec) throws IOException {
        this.segprop = segProp;
        this.partitionSpec = partitionSpec;
        this.loadModel = loadModel;
        CarbonDataProcessorUtil.createLocations(tempStoreLocation);
        String carbonStoreLocation = partitionSpec != null ? partitionSpec.getLocation().toString() + "/" + loadModel.getFactTimeStamp() + ".tmp" : CarbonDataProcessorUtil.createCarbonStoreLocation(loadModel.getCarbonDataLoadSchema().getCarbonTable(), loadModel.getSegmentId());
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = CarbonFactDataHandlerModel.getCarbonFactDataHandlerModel(loadModel, loadModel.getCarbonDataLoadSchema().getCarbonTable(), segProp, tableName, tempStoreLocation, carbonStoreLocation);
        this.setDataFileAttributesInModel(loadModel, compactionType, carbonFactDataHandlerModel);
        carbonFactDataHandlerModel.setCompactionFlow(true);
        carbonFactDataHandlerModel.setSegmentId(loadModel.getSegmentId());
        carbonFactDataHandlerModel.setBucketId(loadModel.getBucketId());
        this.noDicAndComplexColumns = carbonFactDataHandlerModel.getNoDictAndComplexColumns();
        this.dataHandler = new CarbonFactDataHandlerColumnar(carbonFactDataHandlerModel);
    }

    private void initRecordHolderHeap(List<RawResultIterator> rawResultIteratorList) {
        this.recordHolderHeap = new PriorityQueue<RawResultIterator>(rawResultIteratorList.size(), new CarbonMdkeyComparator());
    }

    @Override
    public boolean execute(List<RawResultIterator> unsortedResultIteratorList, List<RawResultIterator> sortedResultIteratorList) throws Exception {
        ArrayList<RawResultIterator> finalIteratorList = new ArrayList<RawResultIterator>(unsortedResultIteratorList);
        finalIteratorList.addAll(sortedResultIteratorList);
        this.initRecordHolderHeap(finalIteratorList);
        boolean mergeStatus = false;
        int index = 0;
        boolean isDataPresent = false;
        try {
            Object[] convertedRow;
            for (RawResultIterator leaftTupleIterator : finalIteratorList) {
                if (!leaftTupleIterator.hasNext()) continue;
                this.recordHolderHeap.add(leaftTupleIterator);
                ++index;
            }
            RawResultIterator iterator = null;
            while (index > 1) {
                iterator = (RawResultIterator)this.recordHolderHeap.poll();
                convertedRow = iterator.next();
                if (null == convertedRow) {
                    --index;
                    iterator.close();
                    continue;
                }
                if (!isDataPresent) {
                    this.dataHandler.initialise();
                    isDataPresent = true;
                }
                this.addRow(convertedRow);
                if (!iterator.hasNext()) {
                    --index;
                    iterator.close();
                    continue;
                }
                this.recordHolderHeap.add(iterator);
            }
            iterator = (RawResultIterator)this.recordHolderHeap.poll();
            if (null != iterator) {
                do {
                    if (null == (convertedRow = iterator.next())) {
                        iterator.close();
                        break;
                    }
                    if (!isDataPresent) {
                        this.dataHandler.initialise();
                        isDataPresent = true;
                    }
                    this.addRow(convertedRow);
                } while (iterator.hasNext());
            }
            if (isDataPresent) {
                this.dataHandler.finish();
            }
            mergeStatus = true;
        }
        catch (Exception e) {
            mergeStatus = false;
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (isDataPresent) {
                    this.dataHandler.closeHandler();
                }
                if (this.partitionSpec != null) {
                    SegmentFileStore.writeSegmentFile((String)this.loadModel.getTablePath(), (String)this.loadModel.getTaskNo(), (String)this.partitionSpec.getLocation().toString(), (String)(this.loadModel.getFactTimeStamp() + ""), (List)this.partitionSpec.getPartitions());
                }
            }
            catch (IOException | CarbonDataWriterException e) {
                mergeStatus = false;
                throw e;
            }
        }
        return mergeStatus;
    }

    @Override
    public void close() {
        if (null != this.dataHandler) {
            this.dataHandler.closeHandler();
        }
    }

    private void addRow(Object[] carbonTuple) throws SliceMergerException {
        CarbonRow row = WriteStepRowUtil.fromMergerRow((Object[])carbonTuple, (SegmentProperties)this.segprop, (CarbonColumn[])this.noDicAndComplexColumns);
        try {
            this.dataHandler.addDataToStore(row);
        }
        catch (CarbonDataWriterException e) {
            throw new SliceMergerException("Problem in merging the slice", e);
        }
    }

    private class CarbonMdkeyComparator
    implements Comparator<RawResultIterator> {
        int[] columnValueSizes;

        public CarbonMdkeyComparator() {
            this.columnValueSizes = RowResultMergerProcessor.this.segprop.createDimColumnValueLength();
            this.initSortColumns();
        }

        private void initSortColumns() {
            int numberOfSortColumns = RowResultMergerProcessor.this.segprop.getNumberOfSortColumns();
            if (numberOfSortColumns != this.columnValueSizes.length) {
                int[] sortColumnValueSizes = new int[numberOfSortColumns];
                System.arraycopy(this.columnValueSizes, 0, sortColumnValueSizes, 0, numberOfSortColumns);
                this.columnValueSizes = sortColumnValueSizes;
            }
        }

        @Override
        public int compare(RawResultIterator o1, RawResultIterator o2) {
            Object[] row1 = o1.fetchConverted();
            Object[] row2 = o2.fetchConverted();
            if (null == row1 || null == row2) {
                return 0;
            }
            ByteArrayWrapper key1 = (ByteArrayWrapper)row1[0];
            ByteArrayWrapper key2 = (ByteArrayWrapper)row2[0];
            int compareResult = 0;
            int dictionaryKeyOffset = 0;
            byte[] dimCols1 = key1.getDictionaryKey();
            byte[] dimCols2 = key2.getDictionaryKey();
            int noDicIndex = 0;
            for (int eachColumnValueSize : this.columnValueSizes) {
                if (eachColumnValueSize > 0) {
                    compareResult = ByteUtil.UnsafeComparer.INSTANCE.compareTo(dimCols1, dictionaryKeyOffset, eachColumnValueSize, dimCols2, dictionaryKeyOffset, eachColumnValueSize);
                    dictionaryKeyOffset += eachColumnValueSize;
                } else {
                    byte[] noDictionaryDim1 = key1.getNoDictionaryKeyByIndex(noDicIndex);
                    byte[] noDictionaryDim2 = key2.getNoDictionaryKeyByIndex(noDicIndex);
                    compareResult = ByteUtil.UnsafeComparer.INSTANCE.compareTo(noDictionaryDim1, noDictionaryDim2);
                    ++noDicIndex;
                }
                if (0 == compareResult) continue;
                return compareResult;
            }
            return 0;
        }
    }
}

