/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.SortTempFileChunkHolder;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;
import org.apache.log4j.Logger;

public class IntermediateFileMerger
implements Callable<Void> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)IntermediateFileMerger.class.getName());
    private AbstractQueue<SortTempFileChunkHolder> recordHolderHeap;
    private int fileCounter;
    private DataOutputStream stream;
    private int totalNumberOfRecords;
    private SortParameters mergerParameters;
    private File[] intermediateFiles;
    private File outPutFile;
    private int writeBufferSize;
    private String compressorName;
    private Throwable throwable;
    private TableFieldStat tableFieldStat;
    private SortStepRowHandler sortStepRowHandler;

    public IntermediateFileMerger(SortParameters mergerParameters, File[] intermediateFiles, File outPutFile) {
        this.mergerParameters = mergerParameters;
        this.fileCounter = intermediateFiles.length;
        this.intermediateFiles = intermediateFiles;
        this.outPutFile = outPutFile;
        this.writeBufferSize = mergerParameters.getBufferSize();
        this.compressorName = mergerParameters.getSortTempCompressorName();
        this.tableFieldStat = new TableFieldStat(mergerParameters);
        this.sortStepRowHandler = new SortStepRowHandler(this.tableFieldStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Void call() throws Exception {
        intermediateMergeStartTime = System.currentTimeMillis();
        fileConterConst = this.fileCounter;
        try {
            this.startSorting();
            this.initialize();
            while (this.hasNext()) {
                this.writeDataToFile(this.next());
            }
            intermediateMergeCostTime = (double)(System.currentTimeMillis() - intermediateMergeStartTime) / 1000.0;
            IntermediateFileMerger.LOGGER.info((Object)("============================== Intermediate Merge of " + fileConterConst + " Sort Temp Files Cost Time: " + intermediateMergeCostTime + "(s)"));
        }
        catch (Exception e) {
            try {
                IntermediateFileMerger.LOGGER.error((Object)"Problem while intermediate merging", (Throwable)e);
                this.clear();
                this.throwable = e;
            }
            catch (Throwable var6_7) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.stream});
                if (null == this.throwable) {
                    try {
                        this.finish();
                    }
                    catch (CarbonSortKeyAndGroupByException e) {
                        IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file", (Throwable)e);
                        this.throwable = e;
                    }
                } else if (!this.outPutFile.delete()) {
                    IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file");
                }
                throw var6_7;
            }
            CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.stream});
            if (null == this.throwable) {
                try {
                    this.finish();
                }
                catch (CarbonSortKeyAndGroupByException e) {
                    IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file", (Throwable)e);
                    this.throwable = e;
                }
            } else if (!this.outPutFile.delete()) {
                IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file");
            } else {
                ** GOTO lbl53
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.stream});
        if (null == this.throwable) {
            try {
                this.finish();
            }
            catch (CarbonSortKeyAndGroupByException e) {
                IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file", (Throwable)e);
                this.throwable = e;
            }
        } else if (!this.outPutFile.delete()) {
            IntermediateFileMerger.LOGGER.error((Object)"Problem while deleting the merge file");
        }
        if (null != this.throwable) {
            throw new CarbonSortKeyAndGroupByException(this.throwable);
        }
        return null;
    }

    private void initialize() throws CarbonSortKeyAndGroupByException {
        try {
            this.stream = FileFactory.getDataOutputStream((String)this.outPutFile.getPath(), (int)this.writeBufferSize, (String)this.compressorName);
            this.stream.writeInt(this.totalNumberOfRecords);
        }
        catch (FileNotFoundException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while getting the file", e);
        }
        catch (IOException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while writing the data to file", e);
        }
    }

    private IntermediateSortTempRow getSortedRecordFromFile() throws CarbonSortKeyAndGroupByException {
        IntermediateSortTempRow row = null;
        SortTempFileChunkHolder poll = (SortTempFileChunkHolder)this.recordHolderHeap.poll();
        row = poll.getRow();
        if (!poll.hasNext()) {
            poll.closeStream();
            --this.fileCounter;
            return row;
        }
        poll.readRow();
        this.recordHolderHeap.add(poll);
        return row;
    }

    private void startSorting() throws CarbonSortKeyAndGroupByException {
        LOGGER.info((Object)("Number of temp file: " + this.fileCounter));
        this.createRecordHolderQueue(this.intermediateFiles);
        LOGGER.info((Object)"Started adding first record from each file");
        SortTempFileChunkHolder sortTempFileChunkHolder = null;
        for (File tempFile : this.intermediateFiles) {
            sortTempFileChunkHolder = new SortTempFileChunkHolder(tempFile, this.mergerParameters, this.mergerParameters.getTableName(), false);
            sortTempFileChunkHolder.initialize();
            sortTempFileChunkHolder.readRow();
            this.totalNumberOfRecords += sortTempFileChunkHolder.getEntryCount();
            this.recordHolderHeap.add(sortTempFileChunkHolder);
        }
        LOGGER.info((Object)("Heap Size: " + this.recordHolderHeap.size()));
    }

    private void createRecordHolderQueue(File[] listFiles) {
        this.recordHolderHeap = new PriorityQueue<SortTempFileChunkHolder>(listFiles.length);
    }

    private IntermediateSortTempRow next() throws CarbonSortKeyAndGroupByException {
        if (this.hasNext()) {
            return this.getSortedRecordFromFile();
        }
        throw new NoSuchElementException("No more elements to return");
    }

    private boolean hasNext() {
        return this.fileCounter > 0;
    }

    private void writeDataToFile(IntermediateSortTempRow row) throws IOException {
        this.sortStepRowHandler.writeIntermediateSortTempRowToOutputStream(row, this.stream);
    }

    private void finish() throws CarbonSortKeyAndGroupByException {
        this.clear();
        try {
            CarbonUtil.deleteFiles((File[])this.intermediateFiles);
        }
        catch (IOException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while deleting the intermediate files");
        }
    }

    private void clear() {
        if (this.recordHolderHeap != null) {
            while (!this.recordHolderHeap.isEmpty()) {
                SortTempFileChunkHolder sortTempFileChunkHolder = (SortTempFileChunkHolder)this.recordHolderHeap.poll();
                if (null == sortTempFileChunkHolder) continue;
                sortTempFileChunkHolder.closeStream();
            }
        }
        this.recordHolderHeap = null;
    }
}

