/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;

public class IntermediateSortTempRowComparator
implements java.util.Comparator<IntermediateSortTempRow> {
    private boolean[] isSortColumnNoDictionary;
    private DataType[] noDicSortDataTypes;

    public IntermediateSortTempRowComparator(boolean[] isSortColumnNoDictionary, DataType[] noDicSortDataTypes) {
        this.isSortColumnNoDictionary = isSortColumnNoDictionary;
        this.noDicSortDataTypes = noDicSortDataTypes;
    }

    @Override
    public int compare(IntermediateSortTempRow rowA, IntermediateSortTempRow rowB) {
        int diff = 0;
        int dictIndex = 0;
        int nonDictIndex = 0;
        int noDicTypeIdx = 0;
        for (boolean isNoDictionary : this.isSortColumnNoDictionary) {
            if (isNoDictionary) {
                if (DataTypeUtil.isPrimitiveColumn((DataType)this.noDicSortDataTypes[noDicTypeIdx])) {
                    SerializableComparator comparator = Comparator.getComparator((DataType)this.noDicSortDataTypes[noDicTypeIdx]);
                    int difference = comparator.compare(rowA.getNoDictSortDims()[nonDictIndex], rowB.getNoDictSortDims()[nonDictIndex]);
                    if (difference != 0) {
                        return difference;
                    }
                } else {
                    byte[] byteArr2;
                    byte[] byteArr1 = (byte[])rowA.getNoDictSortDims()[nonDictIndex];
                    int difference = ByteUtil.UnsafeComparer.INSTANCE.compareTo(byteArr1, byteArr2 = (byte[])rowB.getNoDictSortDims()[nonDictIndex]);
                    if (difference != 0) {
                        return difference;
                    }
                }
                ++nonDictIndex;
                ++noDicTypeIdx;
                continue;
            }
            int dimFieldA = rowA.getDictSortDims()[dictIndex];
            int dimFieldB = rowB.getDictSortDims()[dictIndex];
            ++dictIndex;
            diff = dimFieldA - dimFieldB;
            if (diff == 0) continue;
            return diff;
        }
        return diff;
    }
}

