/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.store.CarbonDataWriterFactory;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.TablePage;
import org.apache.carbondata.processing.store.writer.CarbonFactDataWriter;
import org.apache.log4j.Logger;

public class CarbonFactDataHandlerColumnar
implements CarbonFactHandler {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonFactDataHandlerColumnar.class.getName());
    private CarbonFactDataHandlerModel model;
    private CarbonFactDataWriter dataWriter;
    private int entryCount;
    private int pageSize;
    private long processedDataCount;
    private ExecutorService producerExecutorService;
    private List<Future<Void>> producerExecutorServiceTaskList;
    private ExecutorService consumerExecutorService;
    private List<Future<Void>> consumerExecutorServiceTaskList;
    private List<CarbonRow> dataRows;
    private int[] noDictColumnPageSize;
    private Semaphore semaphore;
    private int writerTaskSequenceCounter;
    private TablePageList tablePageList;
    private int numberOfCores;
    private AtomicInteger blockletProcessingCount;
    private boolean processingComplete;
    private ColumnarFormatVersion version;
    private Map<Integer, GenericDataType> complexIndexMapCopy = null;
    private int configuredPageSizeInBytes = 0;

    public CarbonFactDataHandlerColumnar(CarbonFactDataHandlerModel model) {
        this.model = model;
        this.initParameters(model);
        this.version = CarbonProperties.getInstance().getFormatVersion();
        StringBuffer noInvertedIdxCol = new StringBuffer();
        for (CarbonDimension carbonDimension : model.getSegmentProperties().getDimensions()) {
            if (carbonDimension.isUseInvertedIndex().booleanValue()) continue;
            noInvertedIdxCol.append(carbonDimension.getColName()).append(",");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Columns considered as NoInverted Index are " + noInvertedIdxCol.toString()));
        }
        this.complexIndexMapCopy = new HashMap<Integer, GenericDataType>();
        for (Map.Entry entry : model.getComplexIndexMap().entrySet()) {
            this.complexIndexMapCopy.put((Integer)entry.getKey(), ((GenericDataType)entry.getValue()).deepCopy());
        }
        String pageSizeStrInBytes = (String)model.getTableSpec().getCarbonTable().getTableInfo().getFactTable().getTableProperties().get("table_page_size_inmb");
        if (pageSizeStrInBytes != null) {
            this.configuredPageSizeInBytes = Integer.parseInt(pageSizeStrInBytes) * 1024 * 1024;
        }
    }

    private void initParameters(CarbonFactDataHandlerModel model) {
        this.numberOfCores = model.getNumberOfCores();
        this.blockletProcessingCount = new AtomicInteger(0);
        this.producerExecutorService = Executors.newFixedThreadPool(model.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory(String.format("ProducerPool:%s, range: %d", model.getTableName(), model.getBucketId()), true));
        this.producerExecutorServiceTaskList = new ArrayList<Future<Void>>(16);
        LOGGER.debug((Object)"Initializing writer executors");
        this.consumerExecutorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory(String.format("ConsumerPool:%s, range: %d", model.getTableName(), model.getBucketId()), true));
        this.consumerExecutorServiceTaskList = new ArrayList<Future<Void>>(1);
        this.semaphore = new Semaphore(this.numberOfCores);
        this.tablePageList = new TablePageList();
        Consumer consumer = new Consumer(this.tablePageList);
        this.consumerExecutorServiceTaskList.add(this.consumerExecutorService.submit(consumer));
    }

    private void setComplexMapSurrogateIndex(int dimensionCount) {
        int surrIndex = 0;
        for (int i = 0; i < dimensionCount; ++i) {
            GenericDataType complexDataType = this.model.getComplexIndexMap().get(i);
            if (complexDataType != null) {
                ArrayList<GenericDataType> primitiveTypes = new ArrayList<GenericDataType>();
                complexDataType.getAllPrimitiveChildren(primitiveTypes);
                for (GenericDataType eachPrimitive : primitiveTypes) {
                    if (!eachPrimitive.getIsColumnDictionary()) continue;
                    eachPrimitive.setSurrogateIndex(surrIndex++);
                }
                continue;
            }
            ++surrIndex;
        }
    }

    @Override
    public void initialise() throws CarbonDataWriterException {
        this.setWritingConfiguration();
    }

    @Override
    public void addDataToStore(CarbonRow row) throws CarbonDataWriterException {
        int totalComplexColumnDepth = this.setFlatCarbonRowForComplex(row);
        if (this.noDictColumnPageSize == null) {
            this.model.setNoDictAllComplexColumnDepth(totalComplexColumnDepth);
            if (this.model.getNoDictDataTypesList().size() + this.model.getNoDictAllComplexColumnDepth() > 0) {
                this.noDictColumnPageSize = new int[this.model.getNoDictDataTypesList().size() + this.model.getNoDictAllComplexColumnDepth()];
            }
        }
        this.dataRows.add(row);
        ++this.entryCount;
        if (this.entryCount == this.pageSize || this.needToCutThePage(row)) {
            try {
                this.semaphore.acquire();
                this.producerExecutorServiceTaskList.add(this.producerExecutorService.submit(new Producer(this.tablePageList, this.dataRows, ++this.writerTaskSequenceCounter, false)));
                this.blockletProcessingCount.incrementAndGet();
                this.processedDataCount += (long)this.entryCount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Total Number Of records added to store: " + this.processedDataCount));
                }
                this.dataRows = new ArrayList<CarbonRow>(this.pageSize);
                this.entryCount = 0;
                this.complexIndexMapCopy = new HashMap<Integer, GenericDataType>();
                for (Map.Entry<Integer, GenericDataType> entry : this.model.getComplexIndexMap().entrySet()) {
                    this.complexIndexMapCopy.put(entry.getKey(), entry.getValue().deepCopy());
                }
                this.noDictColumnPageSize = new int[this.model.getNoDictDataTypesList().size() + this.model.getNoDictAllComplexColumnDepth()];
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new CarbonDataWriterException((Throwable)e);
            }
        }
    }

    private boolean needToCutThePage(CarbonRow row) {
        List<DataType> noDictDataTypesList = this.model.getNoDictDataTypesList();
        int totalNoDictPageCount = noDictDataTypesList.size() + this.model.getNoDictAllComplexColumnDepth();
        if (totalNoDictPageCount > 0) {
            int bucketCounter = 0;
            if (this.configuredPageSizeInBytes == 0) {
                return false;
            }
            Object[] nonDictArray = WriteStepRowUtil.getNoDictAndComplexDimension((CarbonRow)row);
            for (int i = 0; i < noDictDataTypesList.size(); ++i) {
                DataType columnType = noDictDataTypesList.get(i);
                if (columnType == DataTypes.STRING || columnType == DataTypes.VARCHAR || columnType == DataTypes.BINARY) {
                    int currentElementLength = ((byte[])nonDictArray[i]).length;
                    int n = bucketCounter;
                    this.noDictColumnPageSize[n] = this.noDictColumnPageSize[n] + currentElementLength;
                    this.canSnappyHandleThisRow(this.noDictColumnPageSize[bucketCounter]);
                    if (this.noDictColumnPageSize[bucketCounter] + this.dataRows.size() * 4 >= this.configuredPageSizeInBytes) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("cutting the page. Rows count in this page: " + this.dataRows.size()));
                        }
                        this.noDictColumnPageSize = new int[totalNoDictPageCount];
                        return true;
                    }
                    ++bucketCounter;
                    continue;
                }
                if (!columnType.isComplexType()) continue;
                GenericDataType genericDataType = this.complexIndexMapCopy.get(i - this.model.getNoDictionaryCount() + this.model.getSegmentProperties().getNumberOfPrimitiveDimensions());
                int depth = genericDataType.getDepth();
                List flatComplexColumnList = (List)nonDictArray[i];
                for (int k = 0; k < depth; ++k) {
                    ArrayList children = (ArrayList)flatComplexColumnList.get(k);
                    int complexElementSize = 0;
                    for (byte[] child : children) {
                        complexElementSize += child.length;
                    }
                    int n = bucketCounter;
                    this.noDictColumnPageSize[n] = this.noDictColumnPageSize[n] + complexElementSize;
                    this.canSnappyHandleThisRow(this.noDictColumnPageSize[bucketCounter]);
                    if (this.noDictColumnPageSize[bucketCounter] + this.dataRows.size() * 4 >= this.configuredPageSizeInBytes) {
                        LOGGER.info((Object)("cutting the page. Rows count: " + this.dataRows.size()));
                        this.noDictColumnPageSize = new int[totalNoDictPageCount];
                        return true;
                    }
                    ++bucketCounter;
                }
            }
        }
        return false;
    }

    private int setFlatCarbonRowForComplex(CarbonRow row) {
        int noDictTotalComplexChildDepth = 0;
        Object[] noDictAndComplexDimension = WriteStepRowUtil.getNoDictAndComplexDimension((CarbonRow)row);
        for (int i = 0; i < noDictAndComplexDimension.length; ++i) {
            if (i < this.model.getNoDictionaryCount() || !((TableSpec.DimensionSpec)this.model.getTableSpec().getNoDictionaryDimensionSpec().get(i)).getSchemaDataType().isComplexType()) continue;
            GenericDataType genericDataType = this.complexIndexMapCopy.get(i - this.model.getNoDictionaryCount() + this.model.getSegmentProperties().getNumberOfPrimitiveDimensions());
            int depth = genericDataType.getDepth();
            ArrayList<ArrayList<byte[]>> flatComplexColumnList = new ArrayList<ArrayList<byte[]>>(depth);
            for (int k = 0; k < depth; ++k) {
                flatComplexColumnList.add(new ArrayList());
            }
            try {
                ByteBuffer byteArrayInput = ByteBuffer.wrap((byte[])noDictAndComplexDimension[i]);
                ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutput);
                genericDataType.parseComplexValue(byteArrayInput, dataOutputStream);
                genericDataType.getColumnarDataForComplexType(flatComplexColumnList, ByteBuffer.wrap(byteArrayOutput.toByteArray()));
                byteArrayOutput.close();
            }
            catch (IOException | KeyGenException e) {
                throw new CarbonDataWriterException("Problem in splitting and writing complex data", e);
            }
            noDictTotalComplexChildDepth += flatComplexColumnList.size();
            noDictAndComplexDimension[i] = flatComplexColumnList;
        }
        return noDictTotalComplexChildDepth;
    }

    private void canSnappyHandleThisRow(int currentRowSize) {
        if (currentRowSize > 1840700241) {
            throw new RuntimeException(" page size: " + currentRowSize + " exceed snappy size: " + 1840700241 + " Bytes. Snappy cannot compress it ");
        }
    }

    private TablePage processDataRows(List<CarbonRow> dataRows) throws CarbonDataWriterException, IOException {
        if (dataRows.size() == 0) {
            return new TablePage(this.model, 0);
        }
        TablePage tablePage = new TablePage(this.model, dataRows.size());
        int rowId = 0;
        for (CarbonRow row : dataRows) {
            tablePage.addRow(rowId++, row);
        }
        tablePage.encode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number Of records processed: " + dataRows.size()));
        }
        return tablePage;
    }

    @Override
    public void finish() throws CarbonDataWriterException {
        if (null == this.dataWriter) {
            return;
        }
        if (this.producerExecutorService.isShutdown()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Started Finish Operation");
        }
        try {
            this.semaphore.acquire();
            this.producerExecutorServiceTaskList.add(this.producerExecutorService.submit(new Producer(this.tablePageList, this.dataRows, ++this.writerTaskSequenceCounter, true)));
            this.blockletProcessingCount.incrementAndGet();
            this.processedDataCount += (long)this.entryCount;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Total Number Of records added to store: " + this.processedDataCount));
            }
            this.closeWriterExecutionService(this.producerExecutorService);
            this.processWriteTaskSubmitList(this.producerExecutorServiceTaskList);
            this.processingComplete = true;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonDataWriterException((Throwable)e);
        }
    }

    private void closeWriterExecutionService(ExecutorService service) throws CarbonDataWriterException {
        try {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonDataWriterException((Throwable)e);
        }
    }

    private void processWriteTaskSubmitList(List<Future<Void>> taskList) throws CarbonDataWriterException {
        for (int i = 0; i < taskList.size(); ++i) {
            try {
                taskList.get(i).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new CarbonDataWriterException((Throwable)e);
            }
        }
    }

    @Override
    public void closeHandler() throws CarbonDataWriterException {
        if (null != this.dataWriter) {
            while (this.blockletProcessingCount.get() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new CarbonDataWriterException((Throwable)e);
                }
            }
            this.consumerExecutorService.shutdownNow();
            this.processWriteTaskSubmitList(this.consumerExecutorServiceTaskList);
            this.dataWriter.writeFooter();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"All blocklets have been finished writing");
            }
            this.dataWriter.closeWriter();
        }
        this.dataWriter = null;
    }

    private void setWritingConfiguration() throws CarbonDataWriterException {
        this.pageSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.blocklet.size", "120000"));
        if (this.version == ColumnarFormatVersion.V3) {
            int n = this.pageSize = this.pageSize < 32000 ? this.pageSize : 32000;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of rows per column page is configured as pageSize = " + this.pageSize));
        }
        this.dataRows = new ArrayList<CarbonRow>(this.pageSize);
        this.setComplexMapSurrogateIndex(this.model.getDictDimensionCount());
        this.dataWriter = this.getFactDataWriter();
        this.dataWriter.initializeWriter();
    }

    private CarbonFactDataWriter getFactDataWriter() {
        return CarbonDataWriterFactory.getInstance().getFactDataWriter(this.version, this.model);
    }

    private void resetBlockletProcessingCount() {
        this.blockletProcessingCount.set(0);
    }

    private final class Consumer
    implements Callable<Void> {
        private TablePageList tablePageList;

        private Consumer(TablePageList tablePageList) {
            this.tablePageList = tablePageList;
        }

        @Override
        public Void call() {
            while (!CarbonFactDataHandlerColumnar.this.processingComplete || CarbonFactDataHandlerColumnar.this.blockletProcessingCount.get() > 0) {
                TablePage tablePage = null;
                try {
                    tablePage = this.tablePageList.get();
                    if (null != tablePage) {
                        CarbonFactDataHandlerColumnar.this.dataWriter.writeTablePage(tablePage);
                        tablePage.freeMemory();
                    }
                    CarbonFactDataHandlerColumnar.this.blockletProcessingCount.decrementAndGet();
                }
                catch (Throwable throwable) {
                    if (CarbonFactDataHandlerColumnar.this.processingComplete && CarbonFactDataHandlerColumnar.this.blockletProcessingCount.get() <= 0) continue;
                    CarbonFactDataHandlerColumnar.this.producerExecutorService.shutdownNow();
                    CarbonFactDataHandlerColumnar.this.resetBlockletProcessingCount();
                    LOGGER.error((Object)"Problem while writing the carbon data file", throwable);
                    throw new CarbonDataWriterException(throwable);
                }
                finally {
                    CarbonFactDataHandlerColumnar.this.semaphore.release();
                }
            }
            return null;
        }
    }

    private final class Producer
    implements Callable<Void> {
        private TablePageList tablePageList;
        private List<CarbonRow> dataRows;
        private int pageId;
        private boolean isLastPage;

        private Producer(TablePageList tablePageList, List<CarbonRow> dataRows, int pageId, boolean isLastPage) {
            this.tablePageList = tablePageList;
            this.dataRows = dataRows;
            this.pageId = pageId;
            this.isLastPage = isLastPage;
        }

        @Override
        public Void call() {
            try {
                TablePage tablePage = CarbonFactDataHandlerColumnar.this.processDataRows(this.dataRows);
                this.dataRows = null;
                tablePage.setIsLastPage(this.isLastPage);
                int indexInNodeHolderArray = (this.pageId - 1) % CarbonFactDataHandlerColumnar.this.numberOfCores;
                this.tablePageList.put(tablePage, indexInNodeHolderArray);
                return null;
            }
            catch (Throwable throwable) {
                LOGGER.error((Object)"Error in producer", throwable);
                CarbonFactDataHandlerColumnar.this.consumerExecutorService.shutdownNow();
                CarbonFactDataHandlerColumnar.this.resetBlockletProcessingCount();
                throw new CarbonDataWriterException(throwable.getMessage(), throwable);
            }
        }
    }

    private final class TablePageList {
        private TablePage[] tablePages;
        private AtomicBoolean available;
        private int currentIndex;

        private TablePageList() {
            this.tablePages = new TablePage[CarbonFactDataHandlerColumnar.this.numberOfCores];
            this.available = new AtomicBoolean(false);
        }

        public synchronized TablePage get() throws InterruptedException {
            TablePage tablePage = this.tablePages[this.currentIndex];
            if (null == tablePage && !CarbonFactDataHandlerColumnar.this.processingComplete) {
                this.available.set(false);
            }
            while (!this.available.get()) {
                this.wait();
            }
            tablePage = this.tablePages[this.currentIndex];
            this.tablePages[this.currentIndex] = null;
            ++this.currentIndex;
            if (this.currentIndex >= this.tablePages.length) {
                this.currentIndex = 0;
            }
            return tablePage;
        }

        public synchronized void put(TablePage tablePage, int index) {
            this.tablePages[index] = tablePage;
            if (index == this.currentIndex) {
                this.available.set(true);
                this.notifyAll();
            }
        }
    }
}

