/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.impl.AuditLevel;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@InterfaceAudience.Internal
public class Auditor {
    private static final Logger LOGGER = Logger.getLogger((String)"carbon.audit");
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static String username;

    public static void logOperationStart(String opName, String opId) {
        if (CarbonProperties.isAuditEnabled()) {
            Objects.requireNonNull(opName);
            Objects.requireNonNull(opId);
            OpStartMessage message = new OpStartMessage(opName, opId);
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String json = gson.toJson((Object)message);
            LOGGER.log((Priority)AuditLevel.AUDIT, (Object)json);
        }
    }

    public static void logOperationEnd(String opName, String opId, boolean success, String table, String opTime, Map<String, String> extraInfo) {
        if (CarbonProperties.isAuditEnabled()) {
            Objects.requireNonNull(opName);
            Objects.requireNonNull(opId);
            Objects.requireNonNull(opTime);
            OpEndMessage message = new OpEndMessage(opName, opId, table, opTime, success ? OpStatus.SUCCESS : OpStatus.FAILED, extraInfo != null ? extraInfo : new HashMap());
            String json = gson.toJson((Object)message);
            LOGGER.log((Priority)AuditLevel.AUDIT, (Object)json);
        }
    }

    static {
        try {
            username = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            username = "unknown";
        }
    }

    private static class OpEndMessage {
        private String time;
        private String username;
        private String opName;
        private String opId;
        private OpStatus opStatus;
        private String opTime;
        private String table;
        private Map<String, String> extraInfo;

        OpEndMessage(String opName, String opId, String table, String opTime, OpStatus opStatus, Map<String, String> extraInfo) {
            FastDateFormat format = FastDateFormat.getDateTimeInstance((int)1, (int)1);
            this.time = format.format(new Date());
            this.username = username;
            this.opName = opName;
            this.table = table != null ? table : "NA";
            this.opTime = opTime;
            this.opId = opId;
            this.opStatus = opStatus;
            this.extraInfo = extraInfo;
        }

        public String getTime() {
            return this.time;
        }

        public String getUsername() {
            return this.username;
        }

        public String getOpName() {
            return this.opName;
        }

        public String getOpId() {
            return this.opId;
        }

        public OpStatus getOpStatus() {
            return this.opStatus;
        }

        public String getTable() {
            return this.table;
        }

        public String getOpTime() {
            return this.opTime;
        }

        public Map<String, String> getExtraInfo() {
            return this.extraInfo;
        }
    }

    private static class OpStartMessage {
        private String time;
        private String username;
        private String opName;
        private String opId;
        private OpStatus opStatus;

        OpStartMessage(String opName, String opId) {
            FastDateFormat format = FastDateFormat.getDateTimeInstance((int)1, (int)1);
            this.time = format.format(new Date());
            this.username = username;
            this.opName = opName;
            this.opId = opId;
            this.opStatus = OpStatus.START;
        }

        public String getTime() {
            return this.time;
        }

        public String getUsername() {
            return this.username;
        }

        public String getOpName() {
            return this.opName;
        }

        public String getOpId() {
            return this.opId;
        }

        public OpStatus getOpStatus() {
            return this.opStatus;
        }
    }

    private static enum OpStatus {
        START,
        SUCCESS,
        FAILED;

    }
}

