/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.index.IndexChooser;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputFormat;
import org.apache.carbondata.core.index.IndexJob;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.IndexUtil;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexWrapperSimpleInfo;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.profiler.ExplainCollector;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.log4j.Logger;

public abstract class CarbonInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonInputFormat.class.getName());
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    private static final String VALIDATE_INPUT_SEGMENT_IDs = "mapreduce.input.carboninputformat.validsegments";
    private static final String FILTER_PREDICATE = "mapreduce.input.carboninputformat.filter.predicate";
    private static final String COLUMN_PROJECTION = "mapreduce.input.carboninputformat.projection";
    private static final String TABLE_INFO = "mapreduce.input.carboninputformat.tableinfo";
    private static final String CARBON_TRANSACTIONAL_TABLE = "mapreduce.input.carboninputformat.transactional";
    private static final String CARBON_READ_SUPPORT = "mapreduce.input.carboninputformat.readsupport";
    private static final String CARBON_CONVERTER = "mapreduce.input.carboninputformat.converter";
    public static final String DATABASE_NAME = "mapreduce.input.carboninputformat.databaseName";
    public static final String TABLE_NAME = "mapreduce.input.carboninputformat.tableName";
    private static final String PARTITIONS_TO_PRUNE = "mapreduce.input.carboninputformat.partitions.to.prune";
    private static final String FG_INDEX_PRUNING = "mapreduce.input.carboninputformat.fgindex";
    private static final String READ_COMMITTED_SCOPE = "mapreduce.input.carboninputformat.read.committed.scope";
    private static final String READ_ONLY_DELTA = "readDeltaOnly";
    protected int numSegments = 0;
    protected int numStreamSegments = 0;
    protected int numStreamFiles = 0;
    protected int hitedStreamFiles = 0;
    protected int numBlocks = 0;
    protected List fileLists = null;
    private CarbonTable carbonTable;

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getNumStreamSegments() {
        return this.numStreamSegments;
    }

    public int getNumStreamFiles() {
        return this.numStreamFiles;
    }

    public int getHitedStreamFiles() {
        return this.hitedStreamFiles;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public void setFileLists(List fileLists) {
        this.fileLists = fileLists;
    }

    public static void setTableInfo(Configuration configuration, TableInfo tableInfo) throws IOException {
        if (null != tableInfo) {
            configuration.set(TABLE_INFO, CarbonUtil.encodeToString((byte[])tableInfo.serialize()));
        }
    }

    protected static TableInfo getTableInfo(Configuration configuration) throws IOException {
        String tableInfoStr = configuration.get(TABLE_INFO);
        if (tableInfoStr == null) {
            return null;
        }
        TableInfo output = new TableInfo();
        output.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(CarbonUtil.decodeStringToBytes((String)tableInfoStr))));
        return output;
    }

    public CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            TableInfo tableInfo = CarbonInputFormat.getTableInfo(configuration);
            CarbonTable carbonTable = tableInfo != null ? CarbonTable.buildFromTableInfo((TableInfo)tableInfo) : SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration));
            this.carbonTable = carbonTable;
            return carbonTable;
        }
        return this.carbonTable;
    }

    public static void setTablePath(Configuration configuration, String tablePath) {
        configuration.set("mapreduce.input.fileinputformat.inputdir", tablePath);
    }

    public static void setTransactionalTable(Configuration configuration, boolean isTransactionalTable) {
        configuration.set(CARBON_TRANSACTIONAL_TABLE, String.valueOf(isTransactionalTable));
    }

    public static void setFilterPredicates(Configuration configuration, IndexFilter filterExpression) {
        if (filterExpression == null || filterExpression.getExpression() == null) {
            return;
        }
        try {
            String filterString = ObjectSerializationUtil.convertObjectToString((Object)filterExpression);
            configuration.set(FILTER_PREDICATE, filterString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting filter expression to Job", e);
        }
    }

    public static void setColumnProjection(Configuration configuration, String[] projectionColumns) {
        Objects.requireNonNull(projectionColumns);
        if (projectionColumns.length < 1) {
            throw new RuntimeException("Projection can't be empty");
        }
        StringBuilder builder = new StringBuilder();
        for (String column : projectionColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static void setColumnProjection(Configuration configuration, CarbonProjection projection) {
        if (projection == null || projection.isEmpty()) {
            return;
        }
        String[] allColumns = projection.getAllColumns();
        StringBuilder builder = new StringBuilder();
        for (String column : allColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static String getColumnProjection(Configuration configuration) {
        return configuration.get(COLUMN_PROJECTION);
    }

    public static void setFgIndexPruning(Configuration configuration, boolean enable) {
        configuration.set(FG_INDEX_PRUNING, String.valueOf(enable));
    }

    public static boolean isFgIndexPruningEnable(Configuration configuration) {
        String enable = configuration.get(FG_INDEX_PRUNING);
        return enable == null || enable.equalsIgnoreCase("true");
    }

    public static void setSegmentsToAccess(Configuration configuration, List<Segment> validSegments) {
        configuration.set(INPUT_SEGMENT_NUMBERS, CarbonUtil.convertToString(validSegments));
    }

    public static void setQuerySegment(Configuration conf, AbsoluteTableIdentifier identifier) {
        String dbName = identifier.getCarbonTableIdentifier().getDatabaseName().toLowerCase();
        String tbName = identifier.getCarbonTableIdentifier().getTableName().toLowerCase();
        CarbonInputFormat.setQuerySegmentToAccess(conf, dbName, tbName);
    }

    public static void setQuerySegment(Configuration conf, String segmentList) {
        if (!segmentList.trim().equals("*")) {
            CarbonInputFormat.setSegmentsToAccess(conf, Segment.toSegmentList((String[])segmentList.split(","), null));
        }
    }

    public static void setPartitionsToPrune(Configuration configuration, List<PartitionSpec> partitions) {
        if (partitions == null) {
            return;
        }
        try {
            String partitionString = ObjectSerializationUtil.convertObjectToString(new ArrayList<PartitionSpec>(partitions));
            configuration.set(PARTITIONS_TO_PRUNE, partitionString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting partition information to Job" + partitions, e);
        }
    }

    public static List<PartitionSpec> getPartitionsToPrune(Configuration configuration) throws IOException {
        String partitionString = configuration.get(PARTITIONS_TO_PRUNE);
        if (partitionString != null) {
            return (List)ObjectSerializationUtil.convertStringToObject((String)partitionString);
        }
        return null;
    }

    public static void setValidateSegmentsToAccess(Configuration configuration, Boolean validate) {
        configuration.set(VALIDATE_INPUT_SEGMENT_IDs, validate.toString());
    }

    public static boolean getValidateSegmentsToAccess(Configuration configuration) {
        return configuration.get(VALIDATE_INPUT_SEGMENT_IDs, "true").equalsIgnoreCase("true");
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier(Configuration configuration) throws IOException {
        String tablePath = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
        try {
            return AbsoluteTableIdentifier.from((String)tablePath, (String)CarbonInputFormat.getDatabaseName(configuration), (String)CarbonInputFormat.getTableName(configuration));
        }
        catch (InvalidConfigurationException e) {
            throw new IOException(e);
        }
    }

    public static void setReadCommittedScope(Configuration configuration, ReadCommittedScope committedScope) {
        if (committedScope == null) {
            return;
        }
        try {
            String subFoldersString = ObjectSerializationUtil.convertObjectToString((Object)committedScope);
            configuration.set(READ_COMMITTED_SCOPE, subFoldersString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting committedScope information to Job" + committedScope, e);
        }
    }

    public static ReadCommittedScope getReadCommittedScope(Configuration configuration) throws IOException {
        String subFoldersString = configuration.get(READ_COMMITTED_SCOPE);
        if (subFoldersString != null) {
            return (ReadCommittedScope)ObjectSerializationUtil.convertStringToObject((String)subFoldersString);
        }
        return null;
    }

    public abstract List<InputSplit> getSplits(JobContext var1) throws IOException;

    Long getDistributedCount(CarbonTable table, List<PartitionSpec> partitionNames, List<Segment> validSegments) {
        IndexInputFormat indexInputFormat = new IndexInputFormat(table, null, validSegments, new ArrayList(), partitionNames, false, null, false, false);
        indexInputFormat.setIsWriteToFile(false);
        try {
            IndexJob indexJob = (IndexJob)IndexUtil.createIndexJob((String)"org.apache.carbondata.indexserver.DistributedIndexJob");
            if (indexJob == null) {
                throw new ExceptionInInitializerError("Unable to create index job");
            }
            return indexJob.executeCountJob(indexInputFormat);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get count from index server. Initializing fallback", (Throwable)e);
            IndexJob indexJob = IndexUtil.getEmbeddedJob();
            return indexJob.executeCountJob(indexInputFormat);
        }
    }

    List<ExtendedBlocklet> getDistributedBlockRowCount(CarbonTable table, List<PartitionSpec> partitionNames, List<Segment> validSegments, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) {
        return this.getDistributedSplit(table, null, partitionNames, validSegments, invalidSegments, segmentsToBeRefreshed, true);
    }

    private List<ExtendedBlocklet> getDistributedSplit(CarbonTable table, FilterResolverIntf filterResolverIntf, List<PartitionSpec> partitionNames, List<Segment> validSegments, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed, boolean isCountJob) {
        try {
            IndexJob indexJob = (IndexJob)IndexUtil.createIndexJob((String)"org.apache.carbondata.indexserver.DistributedIndexJob");
            if (indexJob == null) {
                throw new ExceptionInInitializerError("Unable to create index job");
            }
            return IndexUtil.executeIndexJob((CarbonTable)table, (FilterResolverIntf)filterResolverIntf, (IndexJob)indexJob, partitionNames, validSegments, invalidSegments, null, (Boolean)false, segmentsToBeRefreshed, (boolean)isCountJob);
        }
        catch (Exception e) {
            if (CarbonProperties.getInstance().isFallBackDisabled()) {
                throw e;
            }
            LOG.error((Object)"Exception occurred while getting splits using index server. Initiating Fall back to embedded mode", (Throwable)e);
            return IndexUtil.executeIndexJob((CarbonTable)table, (FilterResolverIntf)filterResolverIntf, (IndexJob)IndexUtil.getEmbeddedJob(), partitionNames, validSegments, invalidSegments, null, (Boolean)true, segmentsToBeRefreshed, (boolean)isCountJob);
        }
    }

    public IndexFilter getFilterPredicates(Configuration configuration) {
        try {
            String filterExprString = configuration.get(FILTER_PREDICATE);
            if (filterExprString == null) {
                return null;
            }
            IndexFilter filter = (IndexFilter)ObjectSerializationUtil.convertStringToObject((String)filterExprString);
            if (filter != null) {
                CarbonTable carbonTable = this.getOrCreateCarbonTable(configuration);
                filter.setTable(carbonTable);
            }
            return filter;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
    }

    protected List<CarbonInputSplit> getDataBlocksOfSegment(JobContext job, CarbonTable carbonTable, IndexFilter expression, List<Segment> segmentIds, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) throws IOException {
        QueryStatisticsRecorder recorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        QueryStatistic statistic = new QueryStatistic();
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{new Path(carbonTable.getTablePath())}, (Configuration)job.getConfiguration());
        List<ExtendedBlocklet> prunedBlocklets = this.getPrunedBlocklets(job, carbonTable, expression, segmentIds, invalidSegments, segmentsToBeRefreshed);
        ArrayList<CarbonInputSplit> resultFilteredBlocks = new ArrayList<CarbonInputSplit>();
        for (ExtendedBlocklet blocklet : prunedBlocklets) {
            resultFilteredBlocks.add(blocklet.getInputSplit());
        }
        statistic.addStatistics("Time taken to load the Block(s) In Driver Side with Block count ", System.currentTimeMillis());
        recorder.recordStatisticsForDriver(statistic, job.getConfiguration().get("query.id"));
        return resultFilteredBlocks;
    }

    private int getBlockCount(List<ExtendedBlocklet> blocklets) {
        HashSet<String> filepaths = new HashSet<String>();
        for (ExtendedBlocklet blocklet : blocklets) {
            filepaths.add(blocklet.getPath());
        }
        return filepaths.size();
    }

    private List<ExtendedBlocklet> getPrunedBlocklets(JobContext job, CarbonTable carbonTable, IndexFilter filter, List<Segment> segmentIds, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) throws IOException {
        ExplainCollector.addPruningInfo((String)carbonTable.getTableName());
        filter = filter == null ? new IndexFilter(carbonTable, null) : filter;
        ExplainCollector.setFilterStatement((String)(filter.getExpression() == null ? "none" : filter.getExpression().getStatement()));
        boolean distributedCG = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.enable.distributed.index", "false"));
        IndexJob indexJob = IndexUtil.getIndexJob((Configuration)job.getConfiguration());
        List<PartitionSpec> partitionsToPrune = CarbonInputFormat.getPartitionsToPrune(job.getConfiguration());
        TableIndex defaultIndex = IndexStoreManager.getInstance().getDefaultIndex(carbonTable);
        List<ExtendedBlocklet> prunedBlocklets = null;
        LOG.info((Object)"Started block pruning ...");
        boolean isDistributedPruningEnabled = CarbonProperties.getInstance().isDistributedPruningEnabled(carbonTable.getDatabaseName(), carbonTable.getTableName());
        if (isDistributedPruningEnabled) {
            try {
                prunedBlocklets = this.getDistributedSplit(carbonTable, filter.getResolver(), partitionsToPrune, segmentIds, invalidSegments, segmentsToBeRefreshed, false);
            }
            catch (Exception e) {
                if (CarbonProperties.getInstance().isFallBackDisabled()) {
                    throw e;
                }
                prunedBlocklets = defaultIndex.prune(segmentIds, filter, partitionsToPrune);
            }
        } else {
            IndexExprWrapper fgIndexExprWrapper;
            if (carbonTable.isTransactionalTable()) {
                IndexExprWrapper indexExprWrapper = IndexChooser.getDefaultIndex((CarbonTable)this.getOrCreateCarbonTable(job.getConfiguration()), null);
                IndexUtil.loadIndexes((CarbonTable)carbonTable, (IndexExprWrapper)indexExprWrapper, segmentIds);
            }
            prunedBlocklets = defaultIndex.prune(segmentIds, filter, partitionsToPrune);
            if (ExplainCollector.enabled()) {
                ExplainCollector.setDefaultIndexPruningBlockHit((int)this.getBlockCount(prunedBlocklets));
            }
            if (prunedBlocklets.size() == 0) {
                return prunedBlocklets;
            }
            IndexChooser chooser = new IndexChooser(this.getOrCreateCarbonTable(job.getConfiguration()));
            IndexExprWrapper cgIndexExprWrapper = chooser.chooseCGIndex(filter.getResolver());
            if (cgIndexExprWrapper != null) {
                IndexUtil.pruneSegments(segmentIds, (List)prunedBlocklets);
                List cgPrunedBlocklets = new ArrayList();
                boolean isCGPruneFallback = false;
                try {
                    cgPrunedBlocklets = distributedCG && indexJob != null ? IndexUtil.executeIndexJob((CarbonTable)carbonTable, (FilterResolverIntf)filter.getResolver(), (IndexJob)indexJob, partitionsToPrune, segmentIds, invalidSegments, (IndexLevel)IndexLevel.CG, new ArrayList()) : cgIndexExprWrapper.prune(segmentIds, partitionsToPrune);
                }
                catch (Exception e) {
                    isCGPruneFallback = true;
                    LOG.error((Object)"CG index pruning failed.", (Throwable)e);
                }
                if (!isCGPruneFallback) {
                    prunedBlocklets = this.intersectFilteredBlocklets(carbonTable, prunedBlocklets, cgPrunedBlocklets);
                }
                if (ExplainCollector.enabled()) {
                    ExplainCollector.recordCGIndexPruning((IndexWrapperSimpleInfo)IndexWrapperSimpleInfo.fromIndexWrapper((IndexExprWrapper)cgIndexExprWrapper), (int)prunedBlocklets.size(), (int)this.getBlockCount(prunedBlocklets));
                }
            }
            if (prunedBlocklets.size() == 0) {
                return prunedBlocklets;
            }
            if (CarbonInputFormat.isFgIndexPruningEnable(job.getConfiguration()) && indexJob != null && (fgIndexExprWrapper = chooser.chooseFGIndex(filter.getResolver())) != null) {
                IndexUtil.pruneSegments(segmentIds, (List)prunedBlocklets);
                List fgPrunedBlocklets = IndexUtil.executeIndexJob((CarbonTable)carbonTable, (FilterResolverIntf)filter.getResolver(), (IndexJob)indexJob, partitionsToPrune, segmentIds, invalidSegments, (IndexLevel)fgIndexExprWrapper.getIndexLevel(), new ArrayList());
                prunedBlocklets = this.intersectFilteredBlocklets(carbonTable, prunedBlocklets, fgPrunedBlocklets);
                ExplainCollector.recordFGIndexPruning((IndexWrapperSimpleInfo)IndexWrapperSimpleInfo.fromIndexWrapper((IndexExprWrapper)fgIndexExprWrapper), (int)prunedBlocklets.size(), (int)this.getBlockCount(prunedBlocklets));
            }
        }
        LOG.info((Object)"Finished block pruning ...");
        return prunedBlocklets;
    }

    private List<ExtendedBlocklet> intersectFilteredBlocklets(CarbonTable carbonTable, List<ExtendedBlocklet> previousIndexPrunedBlocklets, List<ExtendedBlocklet> otherIndexPrunedBlocklets) {
        ArrayList<ExtendedBlocklet> prunedBlocklets = null;
        if (BlockletIndexUtil.isCacheLevelBlock((CarbonTable)carbonTable)) {
            prunedBlocklets = new ArrayList();
            for (ExtendedBlocklet otherBlocklet : otherIndexPrunedBlocklets) {
                if (!previousIndexPrunedBlocklets.contains(otherBlocklet)) continue;
                prunedBlocklets.add(otherBlocklet);
            }
        } else {
            prunedBlocklets = (List)CollectionUtils.intersection(otherIndexPrunedBlocklets, previousIndexPrunedBlocklets);
        }
        return prunedBlocklets;
    }

    static List<InputSplit> convertToCarbonInputSplit(List<ExtendedBlocklet> extendedBlocklets) {
        ArrayList<InputSplit> resultFilteredBlocks = new ArrayList<InputSplit>();
        for (ExtendedBlocklet blocklet : extendedBlocklets) {
            if (blocklet == null) continue;
            resultFilteredBlocks.add((InputSplit)blocklet.getInputSplit());
        }
        return resultFilteredBlocks;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        QueryModel queryModel = this.createQueryModel(inputSplit, taskAttemptContext, this.getFilterPredicates(taskAttemptContext.getConfiguration()));
        CarbonReadSupport<T> readSupport = this.getReadSupportClass(configuration);
        return new CarbonRecordReader<T>(queryModel, readSupport, taskAttemptContext.getConfiguration());
    }

    public QueryModel createQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        return this.createQueryModel(inputSplit, taskAttemptContext, this.getFilterPredicates(taskAttemptContext.getConfiguration()));
    }

    public QueryModel createQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext, IndexFilter indexFilter) throws IOException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        CarbonTable carbonTable = this.getOrCreateCarbonTable(configuration);
        String projectionString = CarbonInputFormat.getColumnProjection(configuration);
        String[] projectColumns = projectionString != null ? projectionString.split(",") : new String[]{};
        if (indexFilter != null) {
            this.checkAndAddImplicitExpression(indexFilter.getExpression(), inputSplit);
        }
        QueryModel queryModel = new QueryModelBuilder(carbonTable).projectColumns(projectColumns).filterExpression(indexFilter).dataConverter(CarbonInputFormat.getDataTypeConverter(configuration)).build();
        String readDeltaOnly = configuration.get(READ_ONLY_DELTA);
        if (readDeltaOnly != null && Boolean.parseBoolean(readDeltaOnly)) {
            queryModel.setReadOnlyDelta(true);
        }
        return queryModel;
    }

    private void checkAndAddImplicitExpression(Expression expression, InputSplit inputSplit) {
        if (inputSplit instanceof CarbonMultiBlockSplit) {
            CarbonMultiBlockSplit split = (CarbonMultiBlockSplit)inputSplit;
            List<CarbonInputSplit> splits = split.getAllSplits();
            HashMap<String, Set> blockIdToBlockletIdMapping = new HashMap<String, Set>();
            for (CarbonInputSplit carbonInputSplit : splits) {
                Set validBlockletIds = carbonInputSplit.getValidBlockletIds();
                if (null == validBlockletIds || validBlockletIds.isEmpty()) continue;
                String uniqueBlockPath = carbonInputSplit.getFilePath();
                String shortBlockPath = CarbonTablePath.getShortBlockId((String)uniqueBlockPath.substring(uniqueBlockPath.lastIndexOf("/Part") + 1));
                blockIdToBlockletIdMapping.put(shortBlockPath, validBlockletIds);
            }
            if (!blockIdToBlockletIdMapping.isEmpty()) {
                FilterUtil.createImplicitExpressionAndSetAsRightChild((Expression)expression, blockIdToBlockletIdMapping);
            }
        }
    }

    public CarbonReadSupport<T> getReadSupportClass(Configuration configuration) {
        String readSupportClass = configuration.get(CARBON_READ_SUPPORT);
        CarbonReadSupport readSupport = null;
        if (readSupportClass != null) {
            try {
                Class<?> myClass = Class.forName(readSupportClass);
                Constructor<?> constructor = myClass.getConstructors()[0];
                Object object = constructor.newInstance(new Object[0]);
                if (object instanceof CarbonReadSupport) {
                    readSupport = (CarbonReadSupport)object;
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Class " + readSupportClass + "not found"), (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while creating " + readSupportClass), (Throwable)ex);
            }
        } else {
            readSupport = new CarbonReadSupport<T>(){

                @Override
                public T readRow(Object[] data) {
                    return data;
                }
            };
        }
        return readSupport;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        try {
            FileSystem fileSystem = filename.getFileSystem(context.getConfiguration());
            if (fileSystem instanceof LocalFileSystem) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void setCarbonReadSupport(Configuration configuration, Class<? extends CarbonReadSupport> readSupportClass) {
        if (readSupportClass != null) {
            configuration.set(CARBON_READ_SUPPORT, readSupportClass.getName());
        }
    }

    public static void setDataTypeConverter(Configuration configuration, Class<? extends DataTypeConverter> converterClass) {
        if (null != converterClass) {
            configuration.set(CARBON_CONVERTER, converterClass.getCanonicalName());
        }
    }

    public static DataTypeConverter getDataTypeConverter(Configuration configuration) throws IOException {
        String converterClass = configuration.get(CARBON_CONVERTER);
        if (converterClass == null) {
            return new DataTypeConverterImpl();
        }
        try {
            return (DataTypeConverter)Class.forName(converterClass).newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void setDatabaseName(Configuration configuration, String databaseName) {
        if (null != databaseName) {
            configuration.set(DATABASE_NAME, databaseName);
        }
    }

    public static String getDatabaseName(Configuration configuration) throws InvalidConfigurationException {
        String databseName = configuration.get(DATABASE_NAME);
        if (null == databseName) {
            throw new InvalidConfigurationException("Database name is not set.");
        }
        return databseName;
    }

    public static void setTableName(Configuration configuration, String tableName) {
        if (null != tableName) {
            configuration.set(TABLE_NAME, tableName);
        }
    }

    public static String getTableName(Configuration configuration) throws InvalidConfigurationException {
        String tableName = configuration.get(TABLE_NAME);
        if (tableName == null) {
            throw new InvalidConfigurationException("Table name is not set");
        }
        return tableName;
    }

    public String[] projectAllColumns(CarbonTable carbonTable) {
        List colList = carbonTable.getTableInfo().getFactTable().getListOfColumns();
        ArrayList<String> projectColumns = new ArrayList<String>();
        for (ColumnSchema col : colList) {
            if (col.isComplexColumn()) continue;
            projectColumns.add(col.getColumnName());
        }
        return projectColumns.toArray(new String[projectColumns.size()]);
    }

    private static void setQuerySegmentToAccess(Configuration conf, String dbName, String tableName) {
        String segmentNumbersFromProperty = CarbonProperties.getInstance().getProperty("carbon.input.segments." + dbName + "." + tableName, "*");
        if (!segmentNumbersFromProperty.trim().equals("*")) {
            CarbonInputFormat.setSegmentsToAccess(conf, Segment.toSegmentList((String[])segmentNumbersFromProperty.split(","), null));
        }
    }

    public static void setQuerySegment(Configuration conf, CarbonTable carbonTable) {
        String tableName = carbonTable.getTableName();
        String parentTableName = carbonTable.getParentTableName();
        if (!parentTableName.isEmpty()) {
            tableName = parentTableName;
        }
        CarbonInputFormat.setQuerySegmentToAccess(conf, carbonTable.getDatabaseName(), tableName);
    }
}

