/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.readsupport.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;

public class CarbonRowReadSupport
implements CarbonReadSupport<CarbonRow> {
    private CarbonColumn[] carbonColumns;

    @Override
    public void initialize(CarbonColumn[] carbonColumns, CarbonTable carbonTable) {
        this.carbonColumns = carbonColumns;
    }

    @Override
    public CarbonRow readRow(Object[] data) {
        for (int i = 0; i < this.carbonColumns.length; ++i) {
            if (this.carbonColumns[i].getDataType() == DataTypes.DATE) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(0L));
                c.add(6, (Integer)data[i]);
                c.add(5, 1);
                data[i] = new Date(c.getTime().getTime());
                continue;
            }
            if (this.carbonColumns[i].getDataType() != DataTypes.TIMESTAMP) continue;
            data[i] = new Timestamp((Long)data[i] / 1000L);
        }
        return new CarbonRow(data);
    }
}

