/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.stream;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.BlockletHeader;

public class StreamBlockletReader {
    private byte[] buffer;
    private int offset;
    private final byte[] syncMarker;
    private final byte[] syncBuffer;
    private final int syncLen;
    private long pos = 0L;
    private final InputStream in;
    private final long limitStart;
    private final long limitEnd;
    private boolean isAlreadySync = false;
    private Compressor compressor;
    private int rowNums = 0;
    private int rowIndex = 0;
    private boolean isHeaderPresent;

    public StreamBlockletReader(byte[] syncMarker, InputStream in, long limit, boolean isHeaderPresent, String compressorName) {
        this.syncMarker = syncMarker;
        this.syncLen = syncMarker.length;
        this.syncBuffer = new byte[this.syncLen];
        this.in = in;
        this.limitStart = limit;
        this.limitEnd = this.limitStart + (long)this.syncLen;
        this.isHeaderPresent = isHeaderPresent;
        this.compressor = CompressorFactory.getInstance().getCompressor(compressorName);
    }

    private void ensureCapacity(int capacity) {
        if (this.buffer == null || capacity > this.buffer.length) {
            this.buffer = new byte[capacity];
        }
    }

    private boolean sync() throws IOException {
        if (!this.readBytesFromStream(this.syncBuffer, 0, this.syncLen)) {
            return false;
        }
        boolean skipHeader = false;
        int i = 0;
        while ((long)i < this.limitStart) {
            int value;
            int j;
            for (j = 0; j < this.syncLen && this.syncMarker[j] == this.syncBuffer[(i + j) % this.syncLen]; ++j) {
            }
            if (this.syncLen == j) {
                if (this.isHeaderPresent) {
                    if (skipHeader) {
                        return true;
                    }
                    skipHeader = true;
                } else {
                    return true;
                }
            }
            if (-1 == (value = this.in.read())) {
                return false;
            }
            this.syncBuffer[i % this.syncLen] = (byte)value;
            ++this.pos;
            ++i;
        }
        return false;
    }

    public BlockletHeader readBlockletHeader() throws IOException {
        int len = this.readIntFromStream();
        byte[] b = new byte[len];
        if (!this.readBytesFromStream(b, 0, len)) {
            throw new EOFException("Failed to read blocklet header");
        }
        BlockletHeader header = CarbonUtil.readBlockletHeader((byte[])b);
        this.rowNums = header.getBlocklet_info().getNum_rows();
        this.rowIndex = 0;
        return header;
    }

    public void readBlockletData(BlockletHeader header) throws IOException {
        this.ensureCapacity(header.getBlocklet_length());
        this.offset = 0;
        int len = this.readIntFromStream();
        byte[] b = new byte[len];
        if (!this.readBytesFromStream(b, 0, len)) {
            throw new EOFException("Failed to read blocklet data");
        }
        this.compressor.rawUncompress(b, this.buffer);
    }

    public void skipBlockletData(boolean reset) throws IOException {
        int len = this.readIntFromStream();
        this.skip(len);
        this.pos += (long)len;
        if (reset) {
            this.rowNums = 0;
            this.rowIndex = 0;
        }
    }

    private void skip(int len) throws IOException {
        long skipLen;
        long remaining = len;
        while ((remaining -= (skipLen = this.in.skip(remaining))) > 0L) {
        }
    }

    public boolean nextBlocklet() throws IOException {
        if (this.pos >= this.limitStart) {
            return false;
        }
        if (this.isAlreadySync) {
            if (!this.readBytesFromStream(this.syncBuffer, 0, this.syncLen)) {
                return false;
            }
        } else {
            this.isAlreadySync = true;
            if (!this.sync()) {
                return false;
            }
        }
        return this.pos < this.limitEnd;
    }

    public boolean hasNext() {
        return this.rowIndex < this.rowNums;
    }

    public void nextRow() {
        ++this.rowIndex;
    }

    public int readIntFromStream() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.pos += 4L;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public boolean readBytesFromStream(byte[] b, int offset, int len) throws IOException {
        int readLen = this.in.read(b, offset, len);
        if (readLen < 0) {
            return false;
        }
        this.pos += (long)readLen;
        if (readLen < len) {
            return this.readBytesFromStream(b, offset + readLen, len - readLen);
        }
        return true;
    }

    public boolean readBoolean() {
        return this.buffer[this.offset++] != 0;
    }

    public short readShort() {
        short v = (short)((this.buffer[this.offset + 1] & 0xFF) + (this.buffer[this.offset] << 8));
        this.offset += 2;
        return v;
    }

    public byte[] copy(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, this.offset, b, 0, len);
        return b;
    }

    public int readInt() {
        int v = (this.buffer[this.offset + 3] & 0xFF) + ((this.buffer[this.offset + 2] & 0xFF) << 8) + ((this.buffer[this.offset + 1] & 0xFF) << 16) + (this.buffer[this.offset] << 24);
        this.offset += 4;
        return v;
    }

    public long readLong() {
        long v = (long)(this.buffer[this.offset + 7] & 0xFF) + ((long)(this.buffer[this.offset + 6] & 0xFF) << 8) + ((long)(this.buffer[this.offset + 5] & 0xFF) << 16) + ((long)(this.buffer[this.offset + 4] & 0xFF) << 24) + ((long)(this.buffer[this.offset + 3] & 0xFF) << 32) + ((long)(this.buffer[this.offset + 2] & 0xFF) << 40) + ((long)(this.buffer[this.offset + 1] & 0xFF) << 48) + ((long)this.buffer[this.offset] << 56);
        this.offset += 8;
        return v;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte[] readBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, this.offset, b, 0, len);
        this.offset += len;
        return b;
    }

    public void skipBytes(int len) {
        this.offset += len;
    }

    public int getRowNums() {
        return this.rowNums;
    }

    public void close() {
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.in});
    }
}

