/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import io.prestosql.hive.$internal.org.apache.commons.codec.binary.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.DelegatingInputFormat;
import org.apache.avro.mapred.DelegatingMapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class AvroMultipleInputs {
    private static String schemaKey = "avro.mapreduce.input.multipleinputs.dir.schemas";
    private static String mappersKey = "avro.mapreduce.input.multipleinputs.dir.mappers";

    private static void addInputPath(JobConf conf, Path path, Schema inputSchema) {
        String schemaMapping = path.toString() + ";" + AvroMultipleInputs.toBase64(inputSchema.toString());
        String schemas = conf.get(schemaKey);
        conf.set(schemaKey, schemas == null ? schemaMapping : schemas + "," + schemaMapping);
        conf.setInputFormat(DelegatingInputFormat.class);
    }

    public static void addInputPath(JobConf conf, Path path, Class<? extends AvroMapper> mapperClass, Schema inputSchema) {
        AvroMultipleInputs.addInputPath(conf, path, inputSchema);
        String mapperMapping = path.toString() + ";" + mapperClass.getName();
        System.out.println(mapperMapping);
        String mappers = conf.get(mappersKey);
        conf.set(mappersKey, mappers == null ? mapperMapping : mappers + "," + mapperMapping);
        conf.setMapperClass(DelegatingMapper.class);
    }

    static Map<Path, Class<? extends AvroMapper>> getMapperTypeMap(JobConf conf) {
        String[] pathMappings;
        if (conf.get(mappersKey) == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Class<? extends AvroMapper>> m = new HashMap<Path, Class<? extends AvroMapper>>();
        for (String pathMapping : pathMappings = conf.get(mappersKey).split(",")) {
            Class mapClass;
            String[] split = pathMapping.split(";");
            try {
                mapClass = conf.getClassByName(split[1]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), mapClass);
        }
        return m;
    }

    static Map<Path, Schema> getInputSchemaMap(JobConf conf) {
        if (conf.get(schemaKey) == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Schema> m = new HashMap<Path, Schema>();
        String[] schemaMappings = conf.get(schemaKey).split(",");
        Schema.Parser schemaParser = new Schema.Parser();
        for (String schemaMapping : schemaMappings) {
            Schema inputSchema;
            String[] split = schemaMapping.split(";");
            String schemaString = AvroMultipleInputs.fromBase64(split[1]);
            try {
                inputSchema = schemaParser.parse(schemaString);
            }
            catch (SchemaParseException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), inputSchema);
        }
        return m;
    }

    private static String toBase64(String rawString) {
        Base64 base64decoder = new Base64();
        return new String(base64decoder.encode(rawString.getBytes()));
    }

    private static String fromBase64(String base64String) {
        Base64 base64decoder = new Base64();
        return new String(base64decoder.decode(base64String.getBytes()));
    }
}

