/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.nio.ByteBuffer;
import org.apache.avro.mapred.tether.OutputProtocol;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.avro.mapred.tether.TetherPartitioner;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

class TetherOutputService
implements OutputProtocol {
    private Reporter reporter;
    private OutputCollector<TetherData, NullWritable> collector;
    private int inputPort;
    private boolean complete;
    private String error;
    private static final Logger LOG = LoggerFactory.getLogger(TetherOutputService.class);
    public static final long TIMEOUT = 10000L;

    public TetherOutputService(OutputCollector<TetherData, NullWritable> collector, Reporter reporter) {
        this.reporter = reporter;
        this.collector = collector;
    }

    @Override
    public synchronized void configure(int inputPort) {
        LOG.info("got input port from child: inputport=" + inputPort);
        this.inputPort = inputPort;
        this.notify();
    }

    public synchronized int inputPort() throws Exception {
        if (this.inputPort == 0) {
            LOG.info("waiting for input port from child");
            this.wait(10000L);
        }
        if (this.inputPort == 0) {
            LOG.error("Parent process timed out waiting for subprocess to send input port. Check the job log files for more info.");
            throw new Exception("Parent process timed out waiting for subprocess to send input port");
        }
        return this.inputPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(ByteBuffer datum) {
        try {
            this.collector.collect((Object)new TetherData(datum), (Object)NullWritable.get());
        }
        catch (Throwable e) {
            LOG.warn("Error: " + e, e);
            TetherOutputService tetherOutputService = this;
            synchronized (tetherOutputService) {
                this.error = e.toString();
            }
        }
    }

    @Override
    public void outputPartitioned(int partition, ByteBuffer datum) {
        TetherPartitioner.setNextPartition(partition);
        this.output(datum);
    }

    @Override
    public void status(String message) {
        this.reporter.setStatus(message.toString());
    }

    @Override
    public void count(String group, String name, long amount) {
        this.reporter.getCounter(group.toString(), name.toString()).increment(amount);
    }

    @Override
    public synchronized void fail(String message) {
        LOG.warn("Failing: " + message);
        this.error = message.toString();
        this.notify();
    }

    @Override
    public synchronized void complete() {
        LOG.info("got task complete");
        this.complete = true;
        this.notify();
    }

    public synchronized boolean isFinished() {
        return this.complete || this.error != null;
    }

    public String error() {
        return this.error;
    }

    public synchronized boolean waitForFinish() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
        return this.error != null;
    }
}

