/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class MapOperator
extends AbstractMapOperator {
    private static final long serialVersionUID = 1L;
    protected transient long cntr = 1L;
    protected transient long logEveryNRows = 0L;
    private final Map<String, Map<Operator<?>, MapOpCtx>> opCtxMap = new HashMap();
    private final Map<Operator<?>, StructObjectInspector> childrenOpToOI = new HashMap();
    protected transient MapOpCtx[] currentCtxs;

    @VisibleForTesting
    void initializeAsRoot(JobConf hconf, MapWork mapWork) throws Exception {
        this.setConf(mapWork);
        this.setChildren((Configuration)hconf);
        this.passExecContext(new ExecMapperContext(hconf));
        this.initializeMapOperator((Configuration)hconf);
    }

    private MapOpCtx initObjectInspector(Configuration hconf, MapOpCtx opCtx, StructObjectInspector tableRowOI) throws Exception {
        TableScanOperator tsOp;
        TableScanDesc tsDesc;
        PartitionDesc pd = opCtx.partDesc;
        TableDesc td = pd.getTableDesc();
        Properties overlayedProps = SerDeUtils.createOverlayedProperties(td.getProperties(), pd.getProperties());
        LinkedHashMap<String, String> partSpec = pd.getPartSpec();
        opCtx.tableName = String.valueOf(overlayedProps.getProperty("name"));
        opCtx.partName = String.valueOf(partSpec);
        opCtx.deserializer = pd.getDeserializer(hconf);
        boolean isAcid = AcidUtils.isTablePropertyTransactional(td.getProperties());
        StructObjectInspector partRawRowObjectInspector = Utilities.isSchemaEvolutionEnabled(hconf, isAcid) && Utilities.isInputFileFormatSelfDescribing(pd) ? tableRowOI : (StructObjectInspector)opCtx.deserializer.getObjectInspector();
        opCtx.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter(partRawRowObjectInspector, tableRowOI);
        String pcols = overlayedProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String pcolTypes;
            String[] partKeyTypes;
            String[] partKeys = pcols.trim().split("/");
            if (partKeys.length > (partKeyTypes = (pcolTypes = overlayedProps.getProperty("partition_columns.types")).trim().split(":")).length) {
                throw new HiveException("Internal error : partKeys length, " + partKeys.length + " greater than partKeyTypes length, " + partKeyTypes.length);
            }
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.getPrimitiveTypeInfo(partKeyTypes[i]));
                partValues[i] = partSpec == null ? null : ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi).convert(partSpec.get(key));
                partObjectInspectors.add(oi);
            }
            opCtx.rowWithPart = new Object[]{null, partValues};
            opCtx.partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        }
        if (opCtx.op instanceof TableScanOperator && (tsDesc = (TableScanDesc)(tsOp = (TableScanOperator)opCtx.op).getConf()) != null && tsDesc.hasVirtualCols()) {
            opCtx.vcs = tsDesc.getVirtualCols();
            opCtx.vcValues = new Object[opCtx.vcs.size()];
            opCtx.vcsObjectInspector = VirtualColumn.getVCSObjectInspector(opCtx.vcs);
            opCtx.rowWithPartAndVC = opCtx.isPartitioned() ? Arrays.copyOfRange(opCtx.rowWithPart, 0, 3) : new Object[2];
        }
        if (!opCtx.hasVC() && !opCtx.isPartitioned()) {
            opCtx.rowObjectInspector = tableRowOI;
            return opCtx;
        }
        ArrayList<StructObjectInspector> inspectors = new ArrayList<StructObjectInspector>();
        inspectors.add(tableRowOI);
        if (opCtx.isPartitioned()) {
            inspectors.add(opCtx.partObjectInspector);
        }
        if (opCtx.hasVC()) {
            inspectors.add(opCtx.vcsObjectInspector);
        }
        opCtx.rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(inspectors);
        return opCtx;
    }

    private Map<TableDesc, StructObjectInspector> getConvertedOI(Map<String, Configuration> tableToConf) throws HiveException {
        HashMap<TableDesc, StructObjectInspector> tableDescOI = new HashMap<TableDesc, StructObjectInspector>();
        HashSet<TableDesc> identityConverterTableDesc = new HashSet<TableDesc>();
        try {
            HashMap<ObjectInspector, Boolean> oiSettableProperties = new HashMap<ObjectInspector, Boolean>();
            for (Path onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
                StructObjectInspector tblRawRowObjectInspector;
                StructObjectInspector partRawRowObjectInspector;
                PartitionDesc pd = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
                TableDesc tableDesc = pd.getTableDesc();
                Configuration hconf = tableToConf.get(tableDesc.getTableName());
                Deserializer partDeserializer = pd.getDeserializer(hconf);
                boolean isAcid = AcidUtils.isTablePropertyTransactional(tableDesc.getProperties());
                if (Utilities.isSchemaEvolutionEnabled(hconf, isAcid) && Utilities.isInputFileFormatSelfDescribing(pd)) {
                    Deserializer tblDeserializer = tableDesc.getDeserializer(hconf);
                    partRawRowObjectInspector = (StructObjectInspector)tblDeserializer.getObjectInspector();
                } else {
                    partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
                }
                if ((tblRawRowObjectInspector = (StructObjectInspector)tableDescOI.get(tableDesc)) != null && !identityConverterTableDesc.contains(tableDesc)) continue;
                Deserializer tblDeserializer = tableDesc.getDeserializer(hconf);
                tblRawRowObjectInspector = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI(partRawRowObjectInspector, tblDeserializer.getObjectInspector(), oiSettableProperties);
                if (identityConverterTableDesc.contains(tableDesc)) {
                    if (!partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                        identityConverterTableDesc.remove(tableDesc);
                    }
                } else if (partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                    identityConverterTableDesc.add(tableDesc);
                }
                tableDescOI.put(tableDesc, tblRawRowObjectInspector);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return tableDescOI;
    }

    private Map<String, Configuration> cloneConfsForNestedColPruning(Configuration hconf) {
        HashMap<String, Configuration> tableNameToConf = new HashMap<String, Configuration>();
        for (Map.Entry<Path, ArrayList<String>> e : ((MapWork)this.conf).getPathToAliases().entrySet()) {
            String tableName;
            List aliases = e.getValue();
            if (aliases == null || aliases.isEmpty() || tableNameToConf.containsKey(tableName = ((MapWork)this.conf).getPathToPartitionInfo().get(e.getKey()).getTableName())) continue;
            for (String alias : aliases) {
                TableScanDesc tableScanDesc;
                List<String> nestedColumnPaths;
                Operator<? extends OperatorDesc> rootOp = ((MapWork)this.conf).getAliasToWork().get(alias);
                if (!(rootOp instanceof TableScanOperator) || (nestedColumnPaths = (tableScanDesc = (TableScanDesc)((TableScanOperator)rootOp).getConf()).getNeededNestedColumnPaths()) == null || nestedColumnPaths.isEmpty()) continue;
                if (!tableNameToConf.containsKey(tableName)) {
                    Configuration clonedConf = new Configuration(hconf);
                    clonedConf.unset("hive.io.file.readNestedColumn.paths");
                    tableNameToConf.put(tableName, clonedConf);
                }
                Configuration newConf = (Configuration)tableNameToConf.get(tableName);
                ColumnProjectionUtils.appendNestedColumnPaths(newConf, nestedColumnPaths);
            }
        }
        for (PartitionDesc pd : ((MapWork)this.conf).getPathToPartitionInfo().values()) {
            if (tableNameToConf.containsKey(pd.getTableName())) continue;
            tableNameToConf.put(pd.getTableName(), hconf);
        }
        for (PartitionDesc pd : ((MapWork)this.conf).getAliasToPartnInfo().values()) {
            if (tableNameToConf.containsKey(pd.getTableName())) continue;
            tableNameToConf.put(pd.getTableName(), hconf);
        }
        return tableNameToConf;
    }

    @Override
    public void initEmptyInputChildren(List<Operator<?>> children, Configuration hconf) throws SerDeException, Exception {
        this.setChildOperators(children);
        Map<String, Configuration> tableNameToConf = this.cloneConfsForNestedColPruning(hconf);
        for (Operator<? extends OperatorDesc> child : children) {
            TableScanOperator tsOp = (TableScanOperator)child;
            StructObjectInspector soi = null;
            PartitionDesc partDesc = ((MapWork)this.conf).getAliasToPartnInfo().get(((TableScanDesc)tsOp.getConf()).getAlias());
            Configuration newConf = tableNameToConf.get(partDesc.getTableDesc().getTableName());
            Deserializer serde = partDesc.getTableDesc().getDeserializer();
            partDesc.setProperties(partDesc.getProperties());
            MapOpCtx opCtx = new MapOpCtx(((TableScanDesc)tsOp.getConf()).getAlias(), child, partDesc);
            StructObjectInspector tableRowOI = (StructObjectInspector)serde.getObjectInspector();
            this.initObjectInspector(newConf, opCtx, tableRowOI);
            soi = opCtx.rowObjectInspector;
            child.getParentOperators().add(this);
            this.childrenOpToOI.put(child, soi);
        }
    }

    @Override
    public void setChildren(Configuration hconf) throws Exception {
        ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
        Map<String, Configuration> tableNameToConf = this.cloneConfsForNestedColPruning(hconf);
        Map<TableDesc, StructObjectInspector> convertedOI = this.getConvertedOI(tableNameToConf);
        for (Map.Entry<Path, ArrayList<String>> entry : ((MapWork)this.conf).getPathToAliases().entrySet()) {
            Path onefile = entry.getKey();
            List aliases = entry.getValue();
            PartitionDesc partDesc = ((MapWork)this.conf).getPathToPartitionInfo().get(onefile);
            TableDesc tableDesc = partDesc.getTableDesc();
            Configuration newConf = tableNameToConf.get(tableDesc.getTableName());
            for (String alias : aliases) {
                Map<Operator<?>, MapOpCtx> contexts;
                Operator<? extends OperatorDesc> op = ((MapWork)this.conf).getAliasToWork().get(alias);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Adding alias " + alias + " to work list for file " + onefile);
                }
                if ((contexts = this.opCtxMap.get(onefile.toString())) == null) {
                    contexts = new LinkedHashMap();
                    this.opCtxMap.put(onefile.toString(), contexts);
                }
                if (contexts.containsKey(op)) continue;
                MapOpCtx context = new MapOpCtx(alias, op, partDesc);
                StructObjectInspector tableRowOI = convertedOI.get(partDesc.getTableDesc());
                contexts.put(op, this.initObjectInspector(newConf, context, tableRowOI));
                if (children.contains(op)) continue;
                op.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>(1));
                op.getParentOperators().add(this);
                children.add(op);
            }
        }
        this.initOperatorContext(children);
        this.setChildOperators(children);
    }

    private void initOperatorContext(List<Operator<? extends OperatorDesc>> children) throws HiveException {
        for (Map<Operator<?>, MapOpCtx> contexts : this.opCtxMap.values()) {
            for (MapOpCtx context : contexts.values()) {
                if (!children.contains(context.op)) continue;
                StructObjectInspector prev = this.childrenOpToOI.put(context.op, context.rowObjectInspector);
                if (prev != null && !prev.equals(context.rowObjectInspector)) {
                    throw new HiveException("Conflict on row inspector for " + context.alias);
                }
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("dump " + context.op + " " + context.rowObjectInspector.getTypeName());
            }
        }
    }

    protected MapOperator() {
    }

    public MapOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
    }

    @Override
    public void initializeMapOperator(Configuration hconf) throws HiveException {
        super.initializeMapOperator(hconf);
        this.cntr = 1L;
        this.logEveryNRows = HiveConf.getLongVar(hconf, HiveConf.ConfVars.HIVE_LOG_N_RECORDS);
        for (Map.Entry<Operator<?>, StructObjectInspector> entry : this.childrenOpToOI.entrySet()) {
            Operator<?> child = entry.getKey();
            child.initialize(hconf, new ObjectInspector[]{entry.getValue()});
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        super.cleanUpInputFileChangedOp();
        Path fpath = this.getExecContext().getCurrentInputPath();
        String nominalPath = this.getNominalPath(fpath);
        Map<Operator<?>, MapOpCtx> contexts = this.opCtxMap.get(nominalPath);
        if (this.LOG.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            for (MapOpCtx context : contexts.values()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(context.alias);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Processing alias(es) " + builder.toString() + " for file " + fpath);
            }
        }
        for (Map.Entry<Operator<?>, MapOpCtx> entry : contexts.entrySet()) {
            Operator<?> operator = entry.getKey();
            MapOpCtx context = entry.getValue();
            operator.setInputContext(context.tableName, context.partName);
        }
        this.currentCtxs = contexts.values().toArray(new MapOpCtx[contexts.size()]);
    }

    @Override
    public void process(Writable value) throws HiveException {
        ExecMapperContext context = this.getExecContext();
        if (context != null && context.inputFileChanged()) {
            this.cleanUpInputFileChanged();
        }
        int childrenDone = 0;
        for (MapOpCtx current : this.currentCtxs) {
            Object row = null;
            try {
                row = current.readRow(value, context);
                if (current.forward(row)) continue;
                ++childrenDone;
            }
            catch (Exception e) {
                String message = null;
                try {
                    message = this.toErrorMessage(value, row, current.rowObjectInspector);
                }
                catch (Throwable t) {
                    message = "[" + row + ", " + value + "]: cannot get error message " + t.getMessage();
                }
                if (row == null) {
                    this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
                    throw new HiveException("Hive Runtime Error while processing writable " + message, e);
                }
                throw new HiveException("Hive Runtime Error while processing row " + message, e);
            }
        }
        this.rowsForwarded(childrenDone, 1);
    }

    protected final void rowsForwarded(int childrenDone, int rows) {
        this.numRows += (long)rows;
        if (this.LOG.isInfoEnabled()) {
            while (this.numRows >= this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 1L;
                    this.numRows = 0L;
                }
                this.LOG.info(this.toString() + ": records read - " + this.numRows);
            }
        }
        if (childrenDone == this.currentCtxs.length) {
            this.setDone(true);
        }
    }

    private String toErrorMessage(Writable value, Object row, ObjectInspector inspector) {
        try {
            if (row != null) {
                return SerDeUtils.getJSONString(row, inspector);
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            return "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e) + " ]";
        }
    }

    public static Object[] populateVirtualColumnValues(ExecMapperContext ctx, List<VirtualColumn> vcs, Object[] vcValues, Deserializer deserializer) {
        if (vcs == null) {
            return vcValues;
        }
        if (vcValues == null) {
            vcValues = new Object[vcs.size()];
        }
        block7: for (int i = 0; i < vcs.size(); ++i) {
            switch (vcs.get(i)) {
                case FILENAME: {
                    if (!ctx.inputFileChanged()) continue block7;
                    vcValues[i] = new Text(ctx.getCurrentInputPath().toString());
                    continue block7;
                }
                case BLOCKOFFSET: {
                    long current = ctx.getIoCxt().getCurrentBlockStart();
                    LongWritable old = (LongWritable)vcValues[i];
                    if (old == null) {
                        old = new LongWritable(current);
                        vcValues[i] = old;
                        continue block7;
                    }
                    if (current == old.get()) continue block7;
                    old.set(current);
                    continue block7;
                }
                case ROWOFFSET: {
                    long current = ctx.getIoCxt().getCurrentRow();
                    LongWritable old = (LongWritable)vcValues[i];
                    if (old == null) {
                        old = new LongWritable(current);
                        vcValues[i] = old;
                        continue block7;
                    }
                    if (current == old.get()) continue block7;
                    old.set(current);
                    continue block7;
                }
                case RAWDATASIZE: {
                    LongWritable old;
                    long current = 0L;
                    SerDeStats stats = deserializer.getSerDeStats();
                    if (stats != null) {
                        current = stats.getRawDataSize();
                    }
                    if ((old = (LongWritable)vcValues[i]) == null) {
                        old = new LongWritable(current);
                        vcValues[i] = old;
                        continue block7;
                    }
                    if (current == old.get()) continue block7;
                    old.set(current);
                    continue block7;
                }
                case ROWID: {
                    if (ctx.getIoCxt().getRecordIdentifier() == null) {
                        vcValues[i] = null;
                        continue block7;
                    }
                    if (vcValues[i] == null) {
                        vcValues[i] = new Object[RecordIdentifier.Field.values().length];
                    }
                    RecordIdentifier.StructInfo.toArray(ctx.getIoCxt().getRecordIdentifier(), (Object[])vcValues[i]);
                    ctx.getIoCxt().setRecordIdentifier(null);
                }
            }
        }
        return vcValues;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return MapOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    @Override
    public void initializeContexts() {
        Path fpath = this.getExecContext().getCurrentInputPath();
        String nominalPath = this.getNominalPath(fpath);
        Map<Operator<?>, MapOpCtx> contexts = this.opCtxMap.get(nominalPath);
        this.currentCtxs = contexts.values().toArray(new MapOpCtx[contexts.size()]);
    }

    @Override
    public Deserializer getCurrentDeserializer() {
        return this.currentCtxs[0].deserializer;
    }

    protected static class MapOpCtx {
        final String alias;
        final Operator<?> op;
        final PartitionDesc partDesc;
        StructObjectInspector partObjectInspector;
        StructObjectInspector vcsObjectInspector;
        StructObjectInspector rowObjectInspector;
        ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
        Object[] rowWithPart;
        Object[] rowWithPartAndVC;
        Deserializer deserializer;
        String tableName;
        String partName;
        List<VirtualColumn> vcs;
        Object[] vcValues;

        public String toString() {
            return "[alias=" + this.alias + ", op=" + this.op + "]";
        }

        public MapOpCtx(String alias, Operator<?> op, PartitionDesc partDesc) {
            this.alias = alias;
            this.op = op;
            this.partDesc = partDesc;
        }

        private boolean isPartitioned() {
            return this.partObjectInspector != null;
        }

        private boolean hasVC() {
            return this.vcsObjectInspector != null;
        }

        private Object readRow(Writable value, ExecMapperContext context) throws SerDeException {
            Object deserialized = this.deserializer.deserialize(value);
            Object row = this.partTblObjectInspectorConverter.convert(deserialized);
            if (this.hasVC()) {
                this.rowWithPartAndVC[0] = row;
                if (context != null) {
                    MapOperator.populateVirtualColumnValues(context, this.vcs, this.vcValues, this.deserializer);
                }
                int vcPos = this.isPartitioned() ? 2 : 1;
                this.rowWithPartAndVC[vcPos] = this.vcValues;
                return this.rowWithPartAndVC;
            }
            if (this.isPartitioned()) {
                this.rowWithPart[0] = row;
                return this.rowWithPart;
            }
            return row;
        }

        public boolean forward(Object row) throws HiveException {
            if (this.op.getDone()) {
                return false;
            }
            this.op.process(row, 0);
            return true;
        }
    }
}

