/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;

public class MoveTask
extends Task<MoveWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MoveTask.class);

    private void moveFile(Path sourcePath, Path targetPath, boolean isDfsDir) throws HiveException {
        try {
            String mesg = "Moving data to " + (isDfsDir ? "" : "local ") + "directory " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
            if (isDfsDir) {
                this.moveFileInDfs(sourcePath, targetPath, this.conf);
            } else {
                LocalFileSystem dstFs = FileSystem.getLocal((Configuration)this.conf);
                this.moveFileFromDfsToLocal(sourcePath, targetPath, fs, (FileSystem)dstFs);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to move source " + sourcePath + " to destination " + targetPath, e);
        }
    }

    private void moveFileInDfs(Path sourcePath, Path targetPath, HiveConf conf) throws HiveException, IOException {
        FileSystem srcFs;
        FileSystem tgtFs;
        try {
            tgtFs = targetPath.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get dest fs", e);
            throw new HiveException(e.getMessage(), e);
        }
        try {
            srcFs = sourcePath.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get src fs", e);
            throw new HiveException(e.getMessage(), e);
        }
        if (srcFs.exists(sourcePath)) {
            Path deletePath = null;
            if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_INSERT_INTO_MULTILEVEL_DIRS)) {
                deletePath = this.createTargetPath(targetPath, tgtFs);
            }
            Hive.clearDestForSubDirSrc(conf, targetPath, sourcePath, false);
            if (!Hive.moveFile(conf, sourcePath, targetPath, true, false, false)) {
                try {
                    if (deletePath != null) {
                        tgtFs.delete(deletePath, true);
                    }
                }
                catch (IOException e) {
                    LOG.info("Unable to delete the path created for facilitating rename: {}", (Object)deletePath);
                }
                throw new HiveException("Unable to rename: " + sourcePath + " to: " + targetPath);
            }
        } else if (!tgtFs.mkdirs(targetPath)) {
            throw new HiveException("Unable to make directory: " + targetPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveFileFromDfsToLocal(Path sourcePath, Path targetPath, FileSystem fs, FileSystem dstFs) throws HiveException, IOException {
        if (dstFs.exists(targetPath)) {
            FileStatus[] destFiles;
            if (!dstFs.isDirectory(targetPath)) throw new HiveException("Target " + targetPath + " is not a local directory.");
            for (FileStatus destFile : destFiles = dstFs.listStatus(targetPath)) {
                if (dstFs.delete(destFile.getPath(), true)) continue;
                throw new IOException("Unable to clean the destination directory: " + targetPath);
            }
        } else if (!FileUtils.mkdir(dstFs, targetPath, this.conf)) {
            throw new HiveException("Failed to create local target directory " + targetPath);
        }
        if (!fs.exists(sourcePath)) return;
        FileStatus[] srcs = fs.listStatus(sourcePath, FileUtils.HIDDEN_FILES_PATH_FILTER);
        for (FileStatus status : srcs) {
            fs.copyToLocalFile(status.getPath(), targetPath);
        }
    }

    private Path createTargetPath(Path targetPath, FileSystem fs) throws IOException {
        Path deletePath = null;
        Path mkDirPath = targetPath.getParent();
        if (mkDirPath != null && !fs.exists(mkDirPath)) {
            for (Path actualPath = mkDirPath; actualPath != null && !fs.exists(actualPath); actualPath = actualPath.getParent()) {
                deletePath = actualPath;
            }
            fs.mkdirs(mkDirPath);
        }
        return deletePath;
    }

    private void releaseLocks(LoadTableDesc ltd) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            LOG.debug("No locks to release because Hive concurrency support is not enabled");
            return;
        }
        Context ctx = this.driverContext.getCtx();
        if (ctx.getHiveTxnManager().supportsAcid()) {
            return;
        }
        HiveLockManager lockMgr = ctx.getHiveTxnManager().getLockManager();
        WriteEntity output = ctx.getLoadTableOutputMap().get(ltd);
        List<HiveLockObj> lockObjects = ctx.getOutputLockObjects().get(output);
        if (.CollectionUtils.isEmpty(lockObjects)) {
            LOG.debug("No locks found to release");
            return;
        }
        LOG.info("Releasing {} locks", (Object)lockObjects.size());
        for (HiveLockObj lockObj : lockObjects) {
            List<HiveLock> locks = lockMgr.getLocks(lockObj.getObj(), false, true);
            for (HiveLock lock2 : locks) {
                if (lock2.getHiveLockMode() != lockObj.getMode() || !ctx.getHiveLocks().remove(lock2)) continue;
                try {
                    lockMgr.unlock(lock2);
                }
                catch (LockException le) {
                    LOG.warn("Could not release lock {}", (Object)lock2.getHiveLockObject().getName(), (Object)le);
                }
            }
        }
    }

    public boolean hasFollowingStatsTask() {
        if (this.getNumChild() == 1) {
            return this.getChildTasks().get(0) instanceof StatsTask;
        }
        return false;
    }

    @Override
    public int execute(DriverContext driverContext) {
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Executing MoveWork " + System.identityHashCode(this.work) + " with " + ((MoveWork)this.work).getLoadFileWork() + "; " + ((MoveWork)this.work).getLoadTableWork() + "; " + ((MoveWork)this.work).getLoadMultiFilesWork());
        }
        try {
            LoadTableDesc tbd;
            LoadMultiFilesDesc lmfd;
            if (driverContext.getCtx().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
                return 0;
            }
            Hive db = this.getHive();
            LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
            if (lfd != null) {
                Path sourcePath;
                Path targetPath = lfd.getTargetDir();
                if (targetPath.equals((Object)(sourcePath = lfd.getSourcePath()))) {
                    Utilities.FILE_OP_LOGGER.debug("MoveTask not moving " + sourcePath);
                } else {
                    Utilities.FILE_OP_LOGGER.debug("MoveTask moving " + sourcePath + " to " + targetPath);
                    if (lfd.getWriteType() == AcidUtils.Operation.INSERT) {
                        assert (lfd.getIsDfsDir());
                        FileSystem srcFs = sourcePath.getFileSystem((Configuration)this.conf);
                        FileStatus[] srcs = srcFs.globStatus(sourcePath);
                        if (srcs != null) {
                            ArrayList<Path> newFiles = new ArrayList<Path>();
                            Hive.moveAcidFiles(srcFs, srcs, targetPath, newFiles);
                        } else {
                            LOG.debug("No files found to move from " + sourcePath + " to " + targetPath);
                        }
                    } else {
                        this.moveFile(sourcePath, targetPath, lfd.getIsDfsDir());
                    }
                }
            }
            if ((lmfd = ((MoveWork)this.work).getLoadMultiFilesWork()) != null) {
                boolean isDfsDir = lmfd.getIsDfsDir();
                List<String> targetPrefixes = lmfd.getTargetPrefixes();
                for (int i = 0; i < lmfd.getSourceDirs().size(); ++i) {
                    FileSystem srcFs;
                    FileStatus[] children;
                    Path srcPath = lmfd.getSourceDirs().get(i);
                    Path destPath = lmfd.getTargetDirs().get(i);
                    String filePrefix = targetPrefixes == null ? null : targetPrefixes.get(i);
                    FileSystem destFs = destPath.getFileSystem((Configuration)this.conf);
                    if (filePrefix == null) {
                        if (!destFs.exists(destPath.getParent())) {
                            destFs.mkdirs(destPath.getParent());
                        }
                        Utilities.FILE_OP_LOGGER.debug("MoveTask moving (multi-file) " + srcPath + " to " + destPath);
                        this.moveFile(srcPath, destPath, isDfsDir);
                        continue;
                    }
                    if (!destFs.exists(destPath)) {
                        destFs.mkdirs(destPath);
                    }
                    if ((children = (srcFs = srcPath.getFileSystem((Configuration)this.conf)).listStatus(srcPath)) != null) {
                        for (FileStatus child : children) {
                            Path childSrc = child.getPath();
                            Path childDest = new Path(destPath, filePrefix + childSrc.getName());
                            Utilities.FILE_OP_LOGGER.debug("MoveTask moving (multi-file) " + childSrc + " to " + childDest);
                            this.moveFile(childSrc, childDest, isDfsDir);
                        }
                    } else {
                        Utilities.FILE_OP_LOGGER.debug("MoveTask skipping empty directory (multi-file) " + srcPath);
                    }
                    if (srcFs.delete(srcPath, false)) continue;
                    throw new IOException("Couldn't delete " + srcPath + " after moving all the files");
                }
            }
            if ((tbd = ((MoveWork)this.work).getLoadTableWork()) != null) {
                this.logMessage(tbd);
                Table table = db.getTable(tbd.getTable().getTableName());
                this.checkFileFormats(db, tbd, table);
                boolean isFullAcidOp = ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable();
                LineageInfo.DataContainer dc = null;
                if (tbd.getPartitionSpec().size() == 0) {
                    dc = new LineageInfo.DataContainer(table.getTTable());
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("loadTable called from " + tbd.getSourcePath() + " into " + tbd.getTable().getTableName());
                    }
                    db.loadTable(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getLoadFileType(), ((MoveWork)this.work).isSrcLocal(), this.isSkewedStoredAsDirs(tbd), isFullAcidOp, this.hasFollowingStatsTask(), tbd.getWriteId(), tbd.getStmtId(), tbd.isInsertOverwrite());
                    if (((MoveWork)this.work).getOutputs() != null) {
                        DDLTask.addIfAbsentByName(new WriteEntity(table, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType())), ((MoveWork)this.work).getOutputs());
                    }
                } else {
                    LOG.info("Partition is: {}", (Object)tbd.getPartitionSpec());
                    TaskInformation ti = new TaskInformation(this, tbd.getSourcePath().toUri().toString());
                    this.inferTaskInformation(ti);
                    DynamicPartitionCtx dpCtx = tbd.getDPCtx();
                    dc = dpCtx != null && dpCtx.getNumDPCols() > 0 ? this.handleDynParts(db, table, tbd, ti, dpCtx) : this.handleStaticParts(db, table, tbd, ti);
                }
                if (dc != null) {
                    List<FieldSchema> tableCols = null;
                    switch (((MoveWork)this.work).getLoadTableWork().getWriteType()) {
                        case DELETE: 
                        case UPDATE: {
                            tableCols = new ArrayList<FieldSchema>();
                            break;
                        }
                        default: {
                            tableCols = table.getCols();
                        }
                    }
                    this.queryState.getLineageState().setLineage(tbd.getSourcePath(), dc, tableCols);
                }
                this.releaseLocks(tbd);
            }
            return 0;
        }
        catch (HiveException he) {
            int errorCode = 1;
            if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
                errorCode = he.getCanonicalErrorMsg().getErrorCode();
                if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                    this.console.printError("Failed with exception " + he.getMessage(), "\n" + StringUtils.stringifyException((Throwable)he));
                } else {
                    this.console.printError("Failed with exception " + he.getMessage() + "\nRemote Exception: " + he.getRemoteErrorMsg());
                    this.console.printInfo("\n", StringUtils.stringifyException((Throwable)he), false);
                }
            }
            this.setException(he);
            return errorCode;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            this.setException(e);
            return 1;
        }
    }

    public void logMessage(LoadTableDesc tbd) {
        StringBuilder mesg = new StringBuilder("Loading data to table ").append(tbd.getTable().getTableName());
        if (tbd.getPartitionSpec().size() > 0) {
            mesg.append(" partition (");
            Map<String, String> partSpec = tbd.getPartitionSpec();
            for (String key : partSpec.keySet()) {
                mesg.append(key).append('=').append(partSpec.get(key)).append(", ");
            }
            mesg.setLength(mesg.length() - 2);
            mesg.append(')');
        }
        String mesg_detail = " from " + tbd.getSourcePath();
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace(mesg.toString() + " " + mesg_detail);
        }
        this.console.printInfo(mesg.toString(), mesg_detail);
    }

    private LineageInfo.DataContainer handleStaticParts(Hive db, Table table, LoadTableDesc tbd, TaskInformation ti) throws HiveException, IOException, InvalidOperationException {
        List<String> partVals = MetaStoreUtils.getPvals(table.getPartCols(), tbd.getPartitionSpec());
        db.validatePartitionNameCharacters(partVals);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("loadPartition called from " + tbd.getSourcePath() + " into " + tbd.getTable().getTableName());
        }
        db.loadPartition(tbd.getSourcePath(), db.getTable(tbd.getTable().getTableName()), tbd.getPartitionSpec(), tbd.getLoadFileType(), tbd.getInheritTableSpecs(), this.isSkewedStoredAsDirs(tbd), ((MoveWork)this.work).isSrcLocal(), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable(), this.hasFollowingStatsTask(), tbd.getWriteId(), tbd.getStmtId(), tbd.isInsertOverwrite());
        Partition partn = db.getPartition(table, tbd.getPartitionSpec(), false);
        if (!(tbd.isMmTable() || ti.bucketCols == null && ti.sortCols == null)) {
            this.updatePartitionBucketSortColumns(db, table, partn, ti.bucketCols, ti.numBuckets, ti.sortCols);
        }
        LineageInfo.DataContainer dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
        if (((MoveWork)this.work).getOutputs() != null) {
            DDLTask.addIfAbsentByName(new WriteEntity(partn, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType())), ((MoveWork)this.work).getOutputs());
        }
        return dc;
    }

    private LineageInfo.DataContainer handleDynParts(Hive db, Table table, LoadTableDesc tbd, TaskInformation ti, DynamicPartitionCtx dpCtx) throws HiveException, IOException, InvalidOperationException {
        LineageInfo.DataContainer dc;
        List<LinkedHashMap<String, String>> dps = Utilities.getFullDPSpecs(this.conf, dpCtx);
        this.console.printInfo(System.getProperty("line.separator"));
        long startTime = System.currentTimeMillis();
        Map<Map<String, String>, Partition> dp = db.loadDynamicPartitions(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getLoadFileType(), dpCtx.getNumDPCols(), tbd.getLbCtx() == null ? 0 : tbd.getLbCtx().calculateListBucketingLevel(), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable(), ((MoveWork)this.work).getLoadTableWork().getWriteId(), tbd.getStmtId(), this.hasFollowingStatsTask(), ((MoveWork)this.work).getLoadTableWork().getWriteType(), tbd.isInsertOverwrite());
        if (dps != null && dps.size() > 0) {
            this.pushFeed(Task.FeedType.DYNAMIC_PARTITIONS, dp.values());
        }
        String loadTime = "\t Time taken to load dynamic partitions: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds";
        this.console.printInfo(loadTime);
        LOG.info(loadTime);
        if (dp.size() == 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ERROR_ON_EMPTY_PARTITION)) {
            throw new HiveException("This query creates no partitions. To turn off this error, set hive.error.on.empty.partition=false.");
        }
        startTime = System.currentTimeMillis();
        for (Map.Entry<Map<String, String>, Partition> entry : dp.entrySet()) {
            Partition partn = entry.getValue();
            if (!(tbd.isMmTable() || ti.bucketCols == null && ti.sortCols == null)) {
                this.updatePartitionBucketSortColumns(db, table, partn, ti.bucketCols, ti.numBuckets, ti.sortCols);
            }
            WriteEntity enty = new WriteEntity(partn, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType()));
            if (((MoveWork)this.work).getOutputs() != null) {
                DDLTask.addIfAbsentByName(enty, ((MoveWork)this.work).getOutputs());
            }
            if (this.queryPlan.getOutputs() == null) {
                this.queryPlan.setOutputs(new LinkedHashSet<WriteEntity>());
            }
            this.queryPlan.getOutputs().add(enty);
            dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
            if (((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.DELETE && ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.UPDATE) {
                this.queryState.getLineageState().setLineage(tbd.getSourcePath(), dc, table.getCols());
            }
            LOG.info("Loading partition " + entry.getKey());
        }
        this.console.printInfo("\t Time taken for adding to write entity : " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        dc = null;
        return dc;
    }

    private void inferTaskInformation(TaskInformation ti) {
        while (ti.task.getParentTasks() != null && ti.task.getParentTasks().size() == 1) {
            MoveTask mt;
            ti.task = ti.task.getParentTasks().get(0);
            if (ti.task instanceof MergeFileTask || ti.task instanceof MapredLocalTask) break;
            if (ti.task instanceof MapRedTask) {
                MapredWork work = (MapredWork)ti.task.getWork();
                MapWork mapWork = work.getMapWork();
                ti.bucketCols = mapWork.getBucketedColsByDirectory().get(ti.path);
                ti.sortCols = mapWork.getSortedColsByDirectory().get(ti.path);
                if (work.getReduceWork() != null) {
                    ti.numBuckets = work.getReduceWork().getNumReduceTasks();
                }
                if (ti.bucketCols != null || ti.sortCols != null) assert (work.isFinalMapRed());
                break;
            }
            if (!(ti.task instanceof MoveTask) || ((MoveWork)(mt = (MoveTask)ti.task).getWork()).getLoadFileWork() == null) continue;
            ti.path = ((MoveWork)mt.getWork()).getLoadFileWork().getSourcePath().toUri().toString();
        }
    }

    private void checkFileFormats(Hive db, LoadTableDesc tbd, Table table) throws HiveException {
        if (((MoveWork)this.work).getCheckFileFormat()) {
            ArrayList<FileStatus> files;
            FileSystem srcFs;
            try {
                srcFs = tbd.getSourcePath().getFileSystem((Configuration)this.conf);
                FileStatus[] dirs = srcFs.globStatus(tbd.getSourcePath());
                files = new ArrayList<FileStatus>();
                for (int i = 0; dirs != null && i < dirs.length; ++i) {
                    files.addAll(Arrays.asList(srcFs.listStatus(dirs[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER)));
                    if (files.size() <= 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new HiveException("addFiles: filesystem error in check phase", e);
            }
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVECHECKFILEFORMAT)) {
                boolean flag = true;
                if (tbd.getDPCtx() == null) {
                    Partition oldPart;
                    flag = tbd.getPartitionSpec() == null || tbd.getPartitionSpec().isEmpty() ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : ((oldPart = db.getPartition(table, tbd.getPartitionSpec(), false)) == null ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, oldPart.getInputFormatClass(), files));
                    if (!flag) {
                        throw new HiveException(ErrorMsg.WRONG_FILE_FORMAT);
                    }
                } else {
                    LOG.warn("Skipping file format check as dpCtx is not null");
                }
            }
        }
    }

    WriteEntity.WriteType getWriteType(LoadTableDesc tbd, AcidUtils.Operation operation) {
        if (tbd.getLoadFileType() == LoadTableDesc.LoadFileType.REPLACE_ALL || tbd.isInsertOverwrite()) {
            return WriteEntity.WriteType.INSERT_OVERWRITE;
        }
        switch (operation) {
            case DELETE: {
                return WriteEntity.WriteType.DELETE;
            }
            case UPDATE: {
                return WriteEntity.WriteType.UPDATE;
            }
        }
        return WriteEntity.WriteType.INSERT;
    }

    private boolean isSkewedStoredAsDirs(LoadTableDesc tbd) {
        return tbd.getLbCtx() == null ? false : tbd.getLbCtx().isSkewedStoredAsDir();
    }

    private void updatePartitionBucketSortColumns(Hive db, Table table, Partition partn, List<BucketingSortingCtx.BucketCol> bucketCols, int numBuckets, List<BucketingSortingCtx.SortCol> sortCols) throws IOException, InvalidOperationException, HiveException {
        boolean updateBucketCols = false;
        if (bucketCols != null) {
            FileSystem fileSys = partn.getDataLocation().getFileSystem((Configuration)this.conf);
            List<FileStatus> fileStatus = HiveStatsUtils.getFileStatusRecurse(partn.getDataLocation(), 1, fileSys);
            if (fileStatus.size() == numBuckets) {
                ArrayList<String> newBucketCols = new ArrayList<String>();
                updateBucketCols = true;
                for (BucketingSortingCtx.BucketCol bucketCol : bucketCols) {
                    if (bucketCol.getIndexes().get(0) < partn.getCols().size()) {
                        newBucketCols.add(partn.getCols().get(bucketCol.getIndexes().get(0)).getName());
                        continue;
                    }
                    updateBucketCols = false;
                    break;
                }
                if (updateBucketCols) {
                    partn.getBucketCols().clear();
                    partn.getBucketCols().addAll(newBucketCols);
                    partn.getTPartition().getSd().setNumBuckets(numBuckets);
                }
            }
        }
        boolean updateSortCols = false;
        if (sortCols != null) {
            ArrayList<Order> newSortCols = new ArrayList<Order>();
            updateSortCols = true;
            for (BucketingSortingCtx.SortCol sortCol : sortCols) {
                if (sortCol.getIndexes().get(0) < partn.getCols().size()) {
                    newSortCols.add(new Order(partn.getCols().get(sortCol.getIndexes().get(0)).getName(), sortCol.getSortOrder() == '+' ? 1 : 0));
                    continue;
                }
                updateSortCols = false;
                break;
            }
            if (updateSortCols) {
                partn.getSortCols().clear();
                partn.getSortCols().addAll(newSortCols);
            }
        }
        if (updateBucketCols || updateSortCols) {
            db.alterPartition(table.getDbName(), table.getTableName(), partn, null);
        }
    }

    public boolean isLocal() {
        LoadTableDesc tbd = ((MoveWork)this.work).getLoadTableWork();
        if (tbd != null) {
            return false;
        }
        LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
        if (lfd != null) {
            return !lfd.getIsDfsDir();
        }
        return false;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    @Override
    public String getName() {
        return "MOVE";
    }

    private static final class TaskInformation {
        public List<BucketingSortingCtx.BucketCol> bucketCols = null;
        public List<BucketingSortingCtx.SortCol> sortCols = null;
        public int numBuckets = -1;
        public Task task;
        public String path;

        public TaskInformation(Task task, String path) {
            this.task = task;
            this.path = path;
        }
    }
}

