/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.datanucleus.util.StringUtils;

public class LoadPartitions {
    private static Logger LOG = LoggerFactory.getLogger(LoadPartitions.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TableEvent event;
    private final TaskTracker tracker;
    private final AddPartitionDesc lastReplicatedPartition;
    private final ImportTableDesc tableDesc;
    private Table table;

    public LoadPartitions(Context context, ReplLogger replLogger, TaskTracker tableTracker, TableEvent event, String dbNameToLoadIn, TableContext tableContext) throws HiveException, IOException {
        this(context, replLogger, tableContext, tableTracker, event, dbNameToLoadIn, null);
    }

    public LoadPartitions(Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter, TableEvent event, String dbNameToLoadIn, AddPartitionDesc lastReplicatedPartition) throws HiveException, IOException {
        this.tracker = new TaskTracker(limiter);
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.lastReplicatedPartition = lastReplicatedPartition;
        this.tableContext = tableContext;
        this.tableDesc = tableContext.overrideProperties(event.tableDesc(dbNameToLoadIn));
        this.table = ImportSemanticAnalyzer.tableIfExists(this.tableDesc, context.hiveDb);
    }

    private String location() throws MetaException, HiveException {
        Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
        if (!this.tableContext.waitOnPrecursor()) {
            return this.context.warehouse.getDefaultTablePath(parentDb, this.tableDesc.getTableName(), this.tableDesc.isExternal()).toString();
        }
        Path tablePath = this.context.warehouse.getDefaultTablePath(this.tableDesc.getDatabaseName(), this.tableDesc.getTableName(), this.tableDesc.isExternal());
        return this.context.warehouse.getDnsPath(tablePath).toString();
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            if (this.tableDesc.getLocation() == null) {
                this.tableDesc.setLocation(this.location());
            }
            if (this.table == null) {
                this.table = this.tableDesc.toTable(this.context.hiveConf);
                if (ImportSemanticAnalyzer.isPartitioned(this.tableDesc)) {
                    this.updateReplicationState(this.initialReplicationState());
                    if (!this.forNewTable().hasReplicationState()) {
                        Task<?> replLogTask = ReplUtils.getTableReplLogTask(this.tableDesc, this.replLogger, this.context.hiveConf);
                        this.tracker.addDependentTask(replLogTask);
                    }
                    return this.tracker;
                }
            } else if (this.table.isPartitioned()) {
                List<AddPartitionDesc> partitionDescs = this.event.partitionDescriptions(this.tableDesc);
                if (!this.event.replicationSpec().isMetadataOnly() && !partitionDescs.isEmpty()) {
                    this.updateReplicationState(this.initialReplicationState());
                    if (!this.forExistingTable(this.lastReplicatedPartition).hasReplicationState()) {
                        Task<?> replLogTask = ReplUtils.getTableReplLogTask(this.tableDesc, this.replLogger, this.context.hiveConf);
                        this.tracker.addDependentTask(replLogTask);
                    }
                    return this.tracker;
                }
            }
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void updateReplicationState(ReplicationState replicationState) throws SemanticException {
        if (!this.tracker.canAddMoreTasks()) {
            this.tracker.setReplicationState(replicationState);
        }
    }

    private ReplicationState initialReplicationState() throws SemanticException {
        return new ReplicationState(new ReplicationState.PartitionState(this.tableDesc.getTableName(), this.lastReplicatedPartition));
    }

    private TaskTracker forNewTable() throws Exception {
        Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
        if (parentDb != null && !this.event.replicationSpec().allowReplacementInto(parentDb.getParameters())) {
            return this.tracker;
        }
        Iterator<AddPartitionDesc> iterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        while (iterator.hasNext() && this.tracker.canAddMoreTasks()) {
            AddPartitionDesc currentPartitionDesc = iterator.next();
            this.addPartition(iterator.hasNext(), currentPartitionDesc, null);
        }
        return this.tracker;
    }

    private void addPartition(boolean hasMorePartitions, AddPartitionDesc addPartitionDesc, Task<?> ptnRootTask) throws Exception {
        this.tracker.addTask(this.tasksForAddPartition(this.table, addPartitionDesc, ptnRootTask));
        if (hasMorePartitions && !this.tracker.canAddMoreTasks()) {
            ReplicationState currentReplicationState = new ReplicationState(new ReplicationState.PartitionState(this.table.getTableName(), addPartitionDesc));
            this.updateReplicationState(currentReplicationState);
        }
    }

    private Task<?> tasksForAddPartition(Table table, AddPartitionDesc addPartitionDesc, Task<?> ptnRootTask) throws MetaException, IOException, HiveException {
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), addPartitionDesc), this.context.hiveConf);
        if (this.event.replicationSpec().isMetadataOnly()) {
            if (ptnRootTask == null) {
                ptnRootTask = addPartTask;
            } else {
                ptnRootTask.addDependentTask(addPartTask);
            }
            return ptnRootTask;
        }
        AddPartitionDesc.OnePartitionDesc partSpec = addPartitionDesc.getPartition(0);
        Path sourceWarehousePartitionLocation = new Path(partSpec.getLocation());
        Path replicaWarehousePartitionLocation = this.locationOnReplicaWarehouse(table, partSpec);
        partSpec.setLocation(replicaWarehousePartitionLocation.toString());
        LOG.debug("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + partSpec.getLocation());
        Path tmpPath = PathUtils.getExternalTmpPath(replicaWarehousePartitionLocation, this.context.pathInfo);
        Task<?> copyTask = ReplCopyTask.getLoadCopyTask(this.event.replicationSpec(), sourceWarehousePartitionLocation, tmpPath, this.context.hiveConf);
        Task<?> movePartitionTask = this.movePartitionTask(table, partSpec, tmpPath);
        Task<?> ckptTask = ReplUtils.getTableCheckpointTask(this.tableDesc, (HashMap)partSpec.getPartSpec(), this.context.dumpDirectory, this.context.hiveConf);
        if (ptnRootTask == null) {
            ptnRootTask = copyTask;
        } else {
            ptnRootTask.addDependentTask(copyTask);
        }
        copyTask.addDependentTask(addPartTask);
        addPartTask.addDependentTask(movePartitionTask);
        movePartitionTask.addDependentTask(ckptTask);
        return ptnRootTask;
    }

    private Task<?> movePartitionTask(Table table, AddPartitionDesc.OnePartitionDesc partSpec, Path tmpPath) {
        MoveWork moveWork = new MoveWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), null, null, false);
        if (AcidUtils.isTransactionalTable(table)) {
            LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(tmpPath), Collections.singletonList(new Path(partSpec.getLocation())), true, null, null);
            moveWork.setMultiFilesDesc(loadFilesWork);
        } else {
            LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), partSpec.getPartSpec(), this.event.replicationSpec().isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, (Long)0L);
            loadTableWork.setInheritTableSpecs(false);
            moveWork.setLoadTableWork(loadTableWork);
        }
        return TaskFactory.get(moveWork, this.context.hiveConf);
    }

    private Path locationOnReplicaWarehouse(Table table, AddPartitionDesc.OnePartitionDesc partSpec) throws MetaException, HiveException, IOException {
        String child = Warehouse.makePartPath(partSpec.getPartSpec());
        if (this.tableDesc.getLocation() == null) {
            if (table.getDataLocation() == null) {
                Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
                return new Path(this.context.warehouse.getDefaultTablePath(parentDb, this.tableDesc.getTableName(), this.tableDesc.isExternal()), child);
            }
            return new Path(table.getDataLocation().toString(), child);
        }
        return new Path(this.tableDesc.getLocation(), child);
    }

    private Task<?> dropPartitionTask(Table table, Map<String, String> partSpec) throws SemanticException {
        Task<DDLWork> dropPtnTask = null;
        Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecsExpr = ReplUtils.genPartSpecs(table, Collections.singletonList(partSpec));
        if (partSpecsExpr.size() > 0) {
            DropTableDesc dropPtnDesc = new DropTableDesc(table.getFullyQualifiedName(), partSpecsExpr, null, true, this.event.replicationSpec());
            dropPtnTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropPtnDesc), this.context.hiveConf);
        }
        return dropPtnTask;
    }

    private TaskTracker forExistingTable(AddPartitionDesc lastPartitionReplicated) throws Exception {
        AddPartitionDesc addPartitionDesc;
        boolean encounteredTheLastReplicatedPartition = lastPartitionReplicated == null;
        Map<String, String> lastReplicatedPartSpec = null;
        if (!encounteredTheLastReplicatedPartition) {
            lastReplicatedPartSpec = lastPartitionReplicated.getPartition(0).getPartSpec();
            LOG.info("Start processing from partition info spec : {}", (Object)StringUtils.mapToString(lastReplicatedPartSpec));
        }
        Iterator<AddPartitionDesc> partitionIterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        while (!encounteredTheLastReplicatedPartition && partitionIterator.hasNext()) {
            addPartitionDesc = partitionIterator.next();
            Map<String, String> currentSpec = addPartitionDesc.getPartition(0).getPartSpec();
            encounteredTheLastReplicatedPartition = lastReplicatedPartSpec.equals(currentSpec);
        }
        block6: while (partitionIterator.hasNext() && this.tracker.canAddMoreTasks()) {
            addPartitionDesc = partitionIterator.next();
            Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
            Task<?> ptnRootTask = null;
            ReplUtils.ReplLoadOpType loadPtnType = this.getLoadPartitionType(partSpec);
            switch (loadPtnType) {
                case LOAD_NEW: {
                    break;
                }
                case LOAD_REPLACE: {
                    ptnRootTask = this.dropPartitionTask(this.table, partSpec);
                    break;
                }
                case LOAD_SKIP: {
                    continue block6;
                }
            }
            this.addPartition(partitionIterator.hasNext(), addPartitionDesc, ptnRootTask);
        }
        return this.tracker;
    }

    private ReplUtils.ReplLoadOpType getLoadPartitionType(Map<String, String> partSpec) throws InvalidOperationException, HiveException {
        Partition ptn = this.context.hiveDb.getPartition(this.table, partSpec, false);
        if (ptn == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (ReplUtils.replCkptStatus(this.tableContext.dbNameToLoadIn, ptn.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
    }
}

