/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.wm.Action;
import org.apache.hadoop.hive.ql.wm.SessionTriggerProvider;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.apache.hadoop.hive.ql.wm.WmContext;

public class TriggerValidatorRunnable
implements Runnable {
    protected static transient Logger LOG = LoggerFactory.getLogger(TriggerValidatorRunnable.class);
    private final SessionTriggerProvider sessionTriggerProvider;
    private final TriggerActionHandler triggerActionHandler;

    TriggerValidatorRunnable(SessionTriggerProvider sessionTriggerProvider, TriggerActionHandler triggerActionHandler) {
        this.sessionTriggerProvider = sessionTriggerProvider;
        this.triggerActionHandler = triggerActionHandler;
    }

    @Override
    public void run() {
        try {
            HashMap<TezSessionState, Trigger> violatedSessions = new HashMap<TezSessionState, Trigger>();
            List<TezSessionState> sessions = this.sessionTriggerProvider.getSessions();
            List<Trigger> triggers = this.sessionTriggerProvider.getTriggers();
            for (TezSessionState sessionState : sessions) {
                WmContext wmContext = sessionState.getWmContext();
                if (wmContext == null || wmContext.isQueryCompleted() || wmContext.getSubscribedCounters().isEmpty()) continue;
                Map<String, Long> currentCounters = wmContext.getCurrentCounters();
                wmContext.updateElapsedTimeCounter();
                for (Trigger currentTrigger : triggers) {
                    long currentCounterValue;
                    String desiredCounter = currentTrigger.getExpression().getCounterLimit().getName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Validating trigger: {} against currentCounters: {}", (Object)currentTrigger, (Object)currentCounters);
                    }
                    if (!currentCounters.containsKey(desiredCounter) || !currentTrigger.apply(currentCounterValue = currentCounters.get(desiredCounter).longValue())) continue;
                    String queryId = sessionState.getWmContext().getQueryId();
                    if (violatedSessions.containsKey(sessionState)) {
                        Trigger existingTrigger = (Trigger)violatedSessions.get(sessionState);
                        if (existingTrigger.getAction().getType().equals((Object)Action.Type.MOVE_TO_POOL) && currentTrigger.getAction().getType().equals((Object)Action.Type.KILL_QUERY)) {
                            currentTrigger.setViolationMsg("Trigger " + currentTrigger + " violated. Current value: " + currentCounterValue);
                            violatedSessions.put(sessionState, currentTrigger);
                            LOG.info("KILL trigger replacing MOVE for query {}", (Object)queryId);
                            continue;
                        }
                        LOG.warn("Conflicting MOVE triggers ({} and {}). Choosing the first MOVE trigger: {}", existingTrigger, currentTrigger, existingTrigger.getName());
                        continue;
                    }
                    currentTrigger.setViolationMsg("Trigger " + currentTrigger + " violated. Current value: " + currentCounterValue);
                    violatedSessions.put(sessionState, currentTrigger);
                }
                Trigger chosenTrigger = (Trigger)violatedSessions.get(sessionState);
                if (chosenTrigger == null) continue;
                LOG.info("Query: {}. {}. Applying action.", (Object)sessionState.getWmContext().getQueryId(), (Object)chosenTrigger.getViolationMsg());
            }
            if (!violatedSessions.isEmpty()) {
                this.triggerActionHandler.applyAction(violatedSessions);
            }
        }
        catch (Throwable t) {
            LOG.warn(TriggerValidatorRunnable.class.getSimpleName() + " caught exception.", t);
        }
    }
}

