/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalLastValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDecimalLastValue.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable lastValue = new HiveDecimalWritable();

    public VectorPTFEvaluatorDecimalLastValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        if (!isLastGroupBatch) {
            return;
        }
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                this.lastValue.set(decimalColVector.vector[0]);
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        } else if (decimalColVector.noNulls) {
            this.lastValue.set(decimalColVector.vector[size - 1]);
            this.isGroupResultNull = false;
        } else {
            int lastBatchIndex = size - 1;
            if (!decimalColVector.isNull[lastBatchIndex]) {
                this.lastValue.set(decimalColVector.vector[lastBatchIndex]);
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public HiveDecimalWritable getDecimalGroupResult() {
        return this.lastValue;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.lastValue.set(HiveDecimal.ZERO);
    }
}

