/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public final class NanoTimeUtils {
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;

    private NanoTimeUtils() {
    }

    public static NanoTime getNanoTime(Timestamp timestamp, boolean ignored) {
        int epochDay = Math.toIntExact(TimeUnit.SECONDS.toDays(timestamp.toEpochSecond()));
        int julianDay = 2440588 + epochDay;
        long timeOfDaySeconds = timestamp.toEpochSecond() % 86400L;
        long timeOfDayNanos = TimeUnit.SECONDS.toNanos(timeOfDaySeconds) + (long)timestamp.getNanos();
        return new NanoTime(julianDay, timeOfDayNanos);
    }
}

