/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import io.prestosql.hive.$internal.com.google.common.collect.ImmutableList;
import io.prestosql.hive.$internal.com.google.common.collect.ImmutableMap;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;

public final class HiveMaterializedViewsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewsRegistry.class);
    private static final HiveMaterializedViewsRegistry SINGLETON = new HiveMaterializedViewsRegistry();
    private final ConcurrentMap<String, ConcurrentMap<String, RelOptMaterialization>> materializedViews = new ConcurrentHashMap<String, ConcurrentMap<String, RelOptMaterialization>>();
    private boolean dummy;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    private HiveMaterializedViewsRegistry() {
    }

    public static HiveMaterializedViewsRegistry get() {
        return SINGLETON;
    }

    public void init() {
        try {
            HiveConf conf = new HiveConf();
            conf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
            this.init(Hive.get(conf));
        }
        catch (HiveException e) {
            LOG.error("Problem connecting to the metastore when initializing the view registry", e);
        }
    }

    public void init(Hive db) {
        this.dummy = db.getConf().get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (this.dummy) {
            this.initialized.set(true);
            LOG.info("Using dummy materialized views registry");
        } else {
            ExecutorService pool = Executors.newCachedThreadPool();
            pool.submit(new Loader(db));
            pool.shutdown();
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public RelOptMaterialization createMaterializedView(HiveConf conf, Table materializedViewTable) {
        return this.addMaterializedView(conf, materializedViewTable, OpType.CREATE);
    }

    private RelOptMaterialization addMaterializedView(HiveConf conf, Table materializedViewTable, OpType opType) {
        ConcurrentMap prevCq;
        if (!materializedViewTable.isRewriteEnabled()) {
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " ignored; it is not rewrite enabled");
            return null;
        }
        ConcurrentMap<String, RelOptMaterialization> cq = new ConcurrentHashMap();
        if (!this.dummy && (prevCq = (ConcurrentMap)this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), cq)) != null) {
            cq = prevCq;
        }
        String viewQuery = materializedViewTable.getViewExpandedText();
        RelNode viewScan = HiveMaterializedViewsRegistry.createMaterializedViewScan(conf, materializedViewTable);
        if (viewScan == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error creating view replacement");
            return null;
        }
        RelNode queryRel = HiveMaterializedViewsRegistry.parseQuery(conf, viewQuery);
        if (queryRel == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error parsing original query");
            return null;
        }
        RelOptMaterialization materialization = new RelOptMaterialization(viewScan, queryRel, null, viewScan.getTable().getQualifiedName());
        if (opType == OpType.CREATE) {
            cq.put(materializedViewTable.getTableName(), materialization);
        } else {
            cq.putIfAbsent(materializedViewTable.getTableName(), materialization);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created materialized view for rewriting: " + viewScan.getTable().getQualifiedName());
        }
        return materialization;
    }

    public void dropMaterializedView(Table materializedViewTable) {
        this.dropMaterializedView(materializedViewTable.getDbName(), materializedViewTable.getTableName());
    }

    public void dropMaterializedView(String dbName, String tableName) {
        if (this.dummy) {
            return;
        }
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(dbName);
        if (dbMap != null) {
            dbMap.remove(tableName);
        }
    }

    RelOptMaterialization getRewritingMaterializedView(String dbName, String viewName) {
        if (this.materializedViews.get(dbName) != null) {
            return (RelOptMaterialization)((ConcurrentMap)this.materializedViews.get(dbName)).get(viewName);
        }
        return null;
    }

    private static RelNode createMaterializedViewScan(HiveConf conf, Table viewTable) {
        HiveTableScan tableRel;
        RelDataType rowType;
        ColumnInfo colInfo;
        String colName;
        StructObjectInspector rowObjectInspector;
        RelOptPlanner planner = CalcitePlanner.createPlanner(conf);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl()));
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        RowResolver rr = new RowResolver();
        try {
            rowObjectInspector = (StructObjectInspector)viewTable.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            return null;
        }
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (int i = 0; i < fields.size(); ++i) {
            colName = fields.get(i).getFieldName();
            colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), null, false);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
        }
        ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
        ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
        for (FieldSchema part_col : viewTable.getPartCols()) {
            colName = part_col.getName();
            colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), null, true);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
            partitionColumns.add(colInfo);
        }
        try {
            rowType = TypeConverter.getType(cluster, rr, null);
        }
        catch (CalciteSemanticException e) {
            return null;
        }
        String fullyQualifiedTabName = viewTable.getDbName();
        fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + viewTable.getTableName() : viewTable.getTableName();
        if (HiveMaterializedViewsRegistry.obtainTableType(viewTable) == TableType.DRUID) {
            String address = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
            String dataSource = viewTable.getParameters().get("druid.datasource");
            HashSet<String> metrics = new HashSet<String>();
            ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
            ArrayList<String> druidColNames = new ArrayList<String>();
            RelDataTypeFactory dtFactory = cluster.getRexBuilder().getTypeFactory();
            for (RelDataTypeField field : rowType.getFieldList()) {
                if ("__time".equals(field.getName())) {
                    druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                } else {
                    druidColTypes.add(field.getType());
                }
                druidColNames.add(field.getName());
                if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                metrics.add(field.getName());
            }
            List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
            rowType = dtFactory.createStructType(druidColTypes, druidColNames);
            RelOptHiveTable optTable = new RelOptHiveTable(null, fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
            HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
            tableRel = DruidQuery.create((RelOptCluster)cluster, (RelTraitSet)cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, ImmutableList.of(scan), ImmutableMap.of());
        } else {
            RelOptHiveTable optTable = new RelOptHiveTable(null, fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            tableRel = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
        }
        return tableRel;
    }

    private static RelNode parseQuery(HiveConf conf, String viewQuery) {
        try {
            ASTNode node = ParseUtils.parse(viewQuery);
            QueryState qs = new QueryState.Builder().withHiveConf(conf).build();
            CalcitePlanner analyzer = new CalcitePlanner(qs);
            Context ctx = new Context(conf);
            ctx.setIsLoadingMaterializedView(true);
            analyzer.initCtx(ctx);
            analyzer.init(false);
            return analyzer.genLogicalPlan(node);
        }
        catch (Exception e) {
            LOG.error("Error parsing original query for materialized view", e);
            return null;
        }
    }

    private static TableType obtainTableType(Table tabMetaData) {
        if (tabMetaData.getStorageHandler() != null) {
            String storageHandlerStr = tabMetaData.getStorageHandler().toString();
            if (storageHandlerStr.equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                return TableType.DRUID;
            }
            if (storageHandlerStr.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                return TableType.JDBC;
            }
        }
        return TableType.NATIVE;
    }

    private static enum OpType {
        CREATE,
        LOAD;

    }

    private static enum TableType {
        DRUID,
        NATIVE,
        JDBC;

    }

    private class Loader
    implements Runnable {
        private final Hive db;

        private Loader(Hive db) {
            this.db = db;
        }

        @Override
        public void run() {
            try {
                SessionState.start(this.db.getConf());
                for (String dbName : this.db.getAllDatabases()) {
                    for (Table mv : this.db.getAllMaterializedViewObjects(dbName)) {
                        HiveMaterializedViewsRegistry.this.addMaterializedView(this.db.getConf(), mv, OpType.LOAD);
                    }
                }
                HiveMaterializedViewsRegistry.this.initialized.set(true);
                LOG.info("Materialized views registry has been initialized");
            }
            catch (HiveException e) {
                LOG.error("Problem connecting to the metastore when initializing the view registry", e);
            }
        }
    }
}

