/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.ReplLoadWork;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.parse.GenTezWork;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkWork;
import org.apache.hadoop.hive.ql.plan.ArchiveWork;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.BasicStatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.ExplainSQRewriteWork;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class QueryPlanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QueryPlanPostProcessor.class);

    public QueryPlanPostProcessor(List<Task<?>> rootTasks, Set<FileSinkDesc> acidSinks, String executionId) {
        for (Task<?> t : rootTasks) {
            Object work = t.getWork();
            if (work instanceof TezWork) {
                for (BaseWork bw : ((TezWork)work).getAllWorkUnsorted()) {
                    this.collectFileSinkDescs(bw.getAllLeafOperators(), acidSinks);
                }
                continue;
            }
            if (work instanceof BaseWork) {
                this.collectFileSinkDescs(((BaseWork)work).getAllLeafOperators(), acidSinks);
                continue;
            }
            if (work instanceof MapredWork) {
                MapredWork w = (MapredWork)work;
                if (w.getMapWork() != null) {
                    this.collectFileSinkDescs(w.getMapWork().getAllLeafOperators(), acidSinks);
                }
                if (w.getReduceWork() == null) continue;
                this.collectFileSinkDescs(w.getReduceWork().getAllLeafOperators(), acidSinks);
                continue;
            }
            if (work instanceof SparkWork) {
                for (BaseWork bw : ((SparkWork)work).getRoots()) {
                    this.collectFileSinkDescs(bw.getAllLeafOperators(), acidSinks);
                }
                continue;
            }
            if (work instanceof MapredLocalWork) {
                Set<FileSinkOperator> fileSinkOperatorSet = OperatorUtils.findOperators(((MapredLocalWork)work).getAliasToWork().values(), FileSinkOperator.class);
                for (FileSinkOperator fsop : fileSinkOperatorSet) {
                    this.collectFileSinkDescs(fsop, acidSinks);
                }
                continue;
            }
            if (work instanceof ExplainWork) {
                new QueryPlanPostProcessor(((ExplainWork)work).getRootTasks(), acidSinks, executionId);
                continue;
            }
            if (work instanceof ReplLoadWork || work instanceof ReplStateLogWork || work instanceof GenTezWork || work instanceof GenSparkWork || work instanceof ArchiveWork || work instanceof ColumnStatsUpdateWork || work instanceof BasicStatsWork || work instanceof ConditionalWork || work instanceof CopyWork || work instanceof DDLWork || work instanceof DependencyCollectionWork || work instanceof ExplainSQRewriteWork || work instanceof FetchWork || work instanceof FunctionWork || work instanceof MoveWork || work instanceof BasicStatsNoJobWork || work instanceof StatsWork) {
                LOG.debug("Found " + work.getClass().getName() + " - no FileSinkOperation can be present.  executionId=" + executionId);
                continue;
            }
            throw new IllegalArgumentException("Unexpected Work object: " + work.getClass() + " executionId=" + executionId);
        }
    }

    private void collectFileSinkDescs(Operator<?> leaf, Set<FileSinkDesc> acidSinks) {
        FileSinkDesc fsd;
        if (leaf instanceof FileSinkOperator && (fsd = (FileSinkDesc)((FileSinkOperator)leaf).getConf()).getWriteType() != AcidUtils.Operation.NOT_ACID && acidSinks.add(fsd) && LOG.isDebugEnabled()) {
            LOG.debug("Found Acid Sink: " + fsd.getDirName());
        }
    }

    private void collectFileSinkDescs(Set<Operator<?>> leaves, Set<FileSinkDesc> acidSinks) {
        for (Operator<?> leaf : leaves) {
            this.collectFileSinkDescs(leaf, acidSinks);
        }
    }
}

