/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;

public class HiveRemoveGBYSemiJoinRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRemoveGBYSemiJoinRule.class);
    public static final HiveRemoveGBYSemiJoinRule INSTANCE = new HiveRemoveGBYSemiJoinRule();

    public HiveRemoveGBYSemiJoinRule() {
        super(HiveRemoveGBYSemiJoinRule.operand(HiveSemiJoin.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.some((RelOptRuleOperand)HiveRemoveGBYSemiJoinRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveRemoveGBYSemiJoinRule.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.any())})), HiveRelFactories.HIVE_BUILDER, "HiveRemoveGBYSemiJoinRule");
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSemiJoin semijoin = (HiveSemiJoin)call.rel(0);
        if (semijoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        RelNode left = call.rel(1);
        Aggregate rightAggregate = (Aggregate)call.rel(2);
        if (rightAggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return;
        }
        if (rightAggregate.indicator) {
            return;
        }
        if (!rightAggregate.getAggCallList().isEmpty()) {
            return;
        }
        JoinInfo joinInfo = semijoin.analyzeCondition();
        boolean shouldTransform = joinInfo.rightSet().equals((Object)ImmutableBitSet.range((int)rightAggregate.getGroupCount()));
        if (shouldTransform) {
            RelBuilder relBuilder = call.builder();
            RelNode newRightInput = relBuilder.project((Iterable)relBuilder.push(rightAggregate.getInput()).fields(rightAggregate.getGroupSet().asList())).build();
            RelNode newSemiJoin = call.builder().push(left).push(newRightInput).semiJoin(new RexNode[]{semijoin.getCondition()}).build();
            call.transformTo(newSemiJoin);
        }
    }
}

