/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;

public abstract class JDBCAbstractSplitFilterRule
extends RelOptRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCAbstractSplitFilterRule.class);
    public static final JDBCAbstractSplitFilterRule SPLIT_FILTER_ABOVE_JOIN = new JDBCSplitFilterAboveJoinRule();
    public static final JDBCAbstractSplitFilterRule SPLIT_FILTER_ABOVE_CONVERTER = new JDBCSplitFilterRule();

    protected JDBCAbstractSplitFilterRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public static boolean canSplitFilter(RexNode cond, SqlDialect dialect) {
        FilterSupportedFunctionsVisitor visitor = new FilterSupportedFunctionsVisitor(dialect);
        cond.accept((RexVisitor)visitor);
        return visitor.canBeSplit();
    }

    public boolean matches(RelOptRuleCall call, SqlDialect dialect) {
        LOGGER.debug("MySplitFilter.matches has been called");
        HiveFilter filter = (HiveFilter)call.rel(0);
        RexNode cond = filter.getCondition();
        return JDBCAbstractSplitFilterRule.canSplitFilter(cond, dialect);
    }

    public void onMatch(RelOptRuleCall call, SqlDialect dialect) {
        LOGGER.debug("MySplitFilter.onMatch has been called");
        HiveFilter filter = (HiveFilter)call.rel(0);
        RexCall callExpression = (RexCall)filter.getCondition();
        FilterSupportedFunctionsVisitor visitor = new FilterSupportedFunctionsVisitor(dialect);
        callExpression.accept((RexVisitor)visitor);
        ArrayList<RexCall> validJdbcNode = visitor.getValidJdbcNode();
        ArrayList<RexCall> invalidJdbcNode = visitor.getInvalidJdbcNode();
        assert (validJdbcNode.size() != 0 && invalidJdbcNode.size() != 0);
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode validCondition = validJdbcNode.size() == 1 ? (RexNode)validJdbcNode.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, validJdbcNode);
        HiveFilter newJdbcValidFilter = new HiveFilter(filter.getCluster(), filter.getTraitSet(), filter.getInput(), validCondition);
        RexNode invalidCondition = invalidJdbcNode.size() == 1 ? (RexNode)invalidJdbcNode.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, invalidJdbcNode);
        HiveFilter newJdbcInvalidFilter = new HiveFilter(filter.getCluster(), filter.getTraitSet(), newJdbcValidFilter, invalidCondition);
        call.transformTo((RelNode)newJdbcInvalidFilter);
    }

    public static class JDBCSplitFilterRule
    extends JDBCAbstractSplitFilterRule {
        public JDBCSplitFilterRule() {
            super(JDBCSplitFilterRule.operand(HiveFilter.class, (RelOptRuleOperand)JDBCSplitFilterRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCSplitFilterRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public boolean matches(RelOptRuleCall call) {
            HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
            return super.matches(call, conv.getJdbcDialect());
        }

        public void onMatch(RelOptRuleCall call) {
            HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
            super.onMatch(call, conv.getJdbcDialect());
        }
    }

    public static class JDBCSplitFilterAboveJoinRule
    extends JDBCAbstractSplitFilterRule {
        public JDBCSplitFilterAboveJoinRule() {
            super(JDBCSplitFilterAboveJoinRule.operand(HiveFilter.class, (RelOptRuleOperand)JDBCSplitFilterAboveJoinRule.operand(HiveJoin.class, (RelOptRuleOperand)JDBCSplitFilterAboveJoinRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCSplitFilterAboveJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public boolean matches(RelOptRuleCall call) {
            LOGGER.debug("MyUpperJoinFilterFilter.matches has been called");
            HiveJoin join = (HiveJoin)call.rel(1);
            HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(2);
            RexNode joinCond = join.getCondition();
            return super.matches(call) && JDBCRexCallValidator.isValidJdbcOperation(joinCond, conv.getJdbcDialect());
        }

        public void onMatch(RelOptRuleCall call) {
            HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(0);
            super.onMatch(call, conv.getJdbcDialect());
        }
    }

    public static class FilterSupportedFunctionsVisitor
    extends RexVisitorImpl<Void> {
        private final SqlDialect dialect;
        private final ArrayList<RexCall> validJdbcNode = new ArrayList();
        private final ArrayList<RexCall> invalidJdbcNode = new ArrayList();

        public FilterSupportedFunctionsVisitor(SqlDialect dialect) {
            super(true);
            this.dialect = dialect;
        }

        public ArrayList<RexCall> getValidJdbcNode() {
            return this.validJdbcNode;
        }

        public ArrayList<RexCall> getInvalidJdbcNode() {
            return this.invalidJdbcNode;
        }

        public Void visitCall(RexCall call) {
            if (call.getKind() == SqlKind.AND) {
                return (Void)super.visitCall(call);
            }
            boolean isValidCall = JDBCRexCallValidator.isValidJdbcOperation((RexNode)call, this.dialect);
            if (isValidCall) {
                this.validJdbcNode.add(call);
            } else {
                this.invalidJdbcNode.add(call);
            }
            return null;
        }

        public boolean canBeSplit() {
            return !this.validJdbcNode.isEmpty() && !this.invalidJdbcNode.isEmpty();
        }
    }
}

