/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Export Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ExportWork
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(ExportWork.class);
    private static final long serialVersionUID = 1L;
    private final String exportRootDirName;
    private BaseSemanticAnalyzer.TableSpec tableSpec;
    private ReplicationSpec replicationSpec;
    private String astRepresentationForErrorMsg;
    private String acidFqTableName;
    private final MmContext mmContext;

    public ExportWork(String exportRootDirName, BaseSemanticAnalyzer.TableSpec tableSpec, ReplicationSpec replicationSpec, String astRepresentationForErrorMsg, String acidFqTableName, MmContext mmContext) {
        this.exportRootDirName = exportRootDirName;
        this.tableSpec = tableSpec;
        this.replicationSpec = replicationSpec;
        this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
        this.mmContext = mmContext;
        this.acidFqTableName = acidFqTableName;
    }

    public String getExportRootDir() {
        return this.exportRootDirName;
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    public String getAstRepresentationForErrorMsg() {
        return this.astRepresentationForErrorMsg;
    }

    public MmContext getMmContext() {
        return this.mmContext;
    }

    public void acidPostProcess(Hive db) throws HiveException {
        if (this.acidFqTableName != null) {
            LOG.info("Swapping export of " + this.tableSpec.tableName + " to " + this.acidFqTableName + " using partSpec=" + this.tableSpec.partSpec);
            this.tableSpec = new BaseSemanticAnalyzer.TableSpec(db, this.acidFqTableName, this.tableSpec.partSpec, true);
        }
    }

    public static final class MmContext {
        private final String fqTableName;

        private MmContext(String fqTableName) {
            this.fqTableName = fqTableName;
        }

        public String toString() {
            return "[" + this.fqTableName + "]";
        }

        public static MmContext createIfNeeded(Table t) {
            if (t == null) {
                return null;
            }
            if (!AcidUtils.isInsertOnlyTable(t.getParameters())) {
                return null;
            }
            return new MmContext(AcidUtils.getFullTableName(t.getDbName(), t.getTableName()));
        }

        public String getFqTableName() {
            return this.fqTableName;
        }
    }
}

